/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.common.Entities;

import com.danny.dannys_expansion.core.Util.NetworkUtil;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.projectile.ProjectileHelper;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public abstract class AbstractSpellEntity
extends Entity {
    private LivingEntity caster;
    private UUID casterUuid;
    public int lifeTick;
    public int lifeTime;
    public float spellYaw;
    public float prevSpellYaw;
    public float spellPitch;
    public float prevSpellPitch;
    public Vector3d forward;
    public LivingEntity attackTarget;

    public AbstractSpellEntity(EntityType<? extends AbstractSpellEntity> entityTypeIn, World worldIn) {
        super(entityTypeIn, worldIn);
    }

    protected void func_70088_a() {
    }

    public void setCaster(@Nullable LivingEntity p_190549_1_) {
        this.caster = p_190549_1_;
        this.casterUuid = p_190549_1_ == null ? null : p_190549_1_.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("Owner")) {
            this.casterUuid = compound.func_186857_a("Owner");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.casterUuid != null) {
            compound.func_186854_a("Owner", this.casterUuid);
        }
    }

    public void setDeath() {
        this.onLifeEnd();
        this.func_70106_y();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.forward = Vector3d.func_189986_a((float)this.spellPitch, (float)this.spellYaw);
        if (this.lifeTick == 0) {
            this.onLifeStart();
        }
        if (++this.lifeTick >= this.lifeTime) {
            this.setDeath();
        }
        RayTraceResult raytraceresult = ProjectileHelper.func_234618_a_((Entity)this, this::func_230298_a_);
        this.onImpact(raytraceresult);
        this.func_213315_a(MoverType.SELF, this.func_213322_ci());
        if (this.getCaster() != null && this.attackTarget != null) {
            this.attackTick();
        }
    }

    public void attackTick() {
    }

    public void onLifeStart() {
        if (this.casterHasAttackTarget()) {
            this.attackTarget = ((MobEntity)this.getCaster()).func_70638_az();
        }
    }

    public boolean casterHasAttackTarget() {
        if (this.getCaster() != null && this.getCaster() instanceof MobEntity) {
            return ((MobEntity)this.getCaster()).func_70638_az() != null;
        }
        return false;
    }

    public void onLifeEnd() {
    }

    public void setLifeTick(int lifeTick) {
        this.lifeTick = lifeTick;
    }

    public int getLifeTick() {
        return this.lifeTick;
    }

    protected void onImpact(RayTraceResult result) {
        RayTraceResult.Type type = result.func_216346_c();
        if (type == RayTraceResult.Type.ENTITY && ((EntityRayTraceResult)result).func_216348_a() != this.getCaster()) {
            this.onEntityHit((EntityRayTraceResult)result);
        } else if (type == RayTraceResult.Type.BLOCK) {
            this.onBlockHit((BlockRayTraceResult)result);
        }
    }

    public boolean func_230298_a_(Entity entityIn) {
        return !entityIn.func_175149_v() && entityIn.func_70089_S() && entityIn.func_70067_L();
    }

    protected void onEntityHit(EntityRayTraceResult result) {
    }

    protected void onBlockHit(BlockRayTraceResult result) {
    }

    public void setRotations(float yaw, float pitch) {
        this.spellYaw = yaw;
        this.spellPitch = pitch;
        this.field_70177_z = yaw;
        this.field_70125_A = pitch;
        NetworkUtil.setSpellRotation(this, yaw, pitch, false);
    }

    public void func_70080_a(double x, double y, double z, float yaw, float pitch) {
        this.func_242281_f(x, y, z);
        this.field_70177_z = yaw % 360.0f;
        this.field_70125_A = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f) % 360.0f;
        this.field_70126_B = this.field_70177_z;
        this.field_70127_C = this.field_70125_A;
        this.spellYaw = yaw % 360.0f;
        this.spellPitch = MathHelper.func_76131_a((float)pitch, (float)-90.0f, (float)90.0f) % 360.0f;
        this.prevSpellYaw = this.spellYaw;
        this.prevSpellPitch = this.spellPitch;
    }

    public void castersDamage(LivingEntity livingEntity, float amount) {
        if (this.getCaster() != null) {
            livingEntity.func_70097_a(DamageSource.func_76358_a((LivingEntity)this.getCaster()), amount);
        } else {
            livingEntity.func_70097_a(DamageSource.field_76376_m, amount);
        }
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

