/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.common.Entities.living;

import com.danny.dannys_expansion.common.Entities.living.FloatingEntity;
import com.danny.dannys_expansion.common.Entities.living.slime.MundaneSlimeEntity;
import com.danny.dannys_expansion.common.Entities.util.GetAttributes;
import com.danny.dannys_expansion.core.Util.MathUtil;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.controller.MovementController;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.World;

public abstract class MeleeHoveringEntity
extends FloatingEntity {
    public MeleeHoveringEntity(EntityType<? extends MeleeHoveringEntity> type, World worldIn) {
        super(type, worldIn);
        this.field_70765_h = new MeleeHoveringMovementController(this);
    }

    @Override
    protected void func_184651_r() {
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (Goal)new NearestAttackableTargetGoal((MobEntity)this, MundaneSlimeEntity.class, false));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, false));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, false));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return MobEntity.func_233666_p_().func_233815_a_(GetAttributes.maxHealth, 50.0).func_233815_a_(GetAttributes.followRange, 70.0).func_233815_a_(GetAttributes.knockbackResistance, 1.0).func_233815_a_(GetAttributes.movementSpeed, 0.25).func_233815_a_(GetAttributes.attackDamage, 8.0);
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        List entities = this.field_70170_p.func_175647_a(LivingEntity.class, this.func_174813_aQ().func_186662_g(0.3), null);
        for (LivingEntity livingEntity : entities) {
            if (!(livingEntity instanceof IronGolemEntity) && !(livingEntity instanceof PlayerEntity) && livingEntity != this.func_70638_az()) continue;
            this.func_70652_k((Entity)livingEntity);
        }
    }

    protected void func_82167_n(Entity entityIn) {
        super.func_82167_n(entityIn);
    }

    public class MeleeHoveringMovementController
    extends MovementController {
        final MeleeHoveringEntity iceElement;
        boolean isAttacking;
        boolean isGainingMomentum;
        boolean attackFinish;
        float attackSpeed;
        int giveUpTimer;
        int momentumTimer;
        int momentumTimerCap;
        float momentumRand;
        int momentumRandCap;
        float verticalRand;
        float horizontalRand;

        public MeleeHoveringMovementController(MeleeHoveringEntity mob) {
            super((MobEntity)mob);
            this.isAttacking = false;
            this.isGainingMomentum = true;
            this.attackFinish = false;
            this.attackSpeed = 0.2f;
            this.giveUpTimer = 0;
            this.momentumTimer = 0;
            this.momentumTimerCap = 0;
            this.iceElement = mob;
        }

        public void func_75641_c() {
            super.func_75641_c();
            Vector3d forward = Vector3d.func_189986_a((float)MeleeHoveringEntity.this.field_70125_A, (float)MeleeHoveringEntity.this.field_70759_as);
            if (this.iceElement.func_70638_az() != null) {
                if (!this.isAttacking) {
                    this.attackSpeed = (float)((double)this.attackSpeed - 0.1);
                    this.setAttackSpeed(this.attackSpeed);
                    this.iceElement.addMotion((double)this.attackSpeed * forward.field_72450_a * 0.01, (double)this.attackSpeed * forward.field_72448_b * 0.01, (double)this.attackSpeed * forward.field_72449_c * 0.01);
                } else {
                    if (this.attackFinish) {
                        this.attackSpeed = (float)((double)this.attackSpeed - 0.05);
                        this.setAttackSpeed(this.attackSpeed);
                    } else {
                        this.attackSpeed = (float)((double)this.attackSpeed + 0.06);
                        this.setAttackSpeed(this.attackSpeed);
                    }
                    if (++this.giveUpTimer >= 300 || this.iceElement.func_174813_aQ().func_186662_g(1.0).func_72326_a(this.iceElement.func_70638_az().func_174813_aQ())) {
                        this.attackFinish = true;
                        this.giveUpTimer = 0;
                    }
                    this.iceElement.addMotion((double)this.attackSpeed * forward.field_72450_a * 0.12, (double)this.attackSpeed * forward.field_72448_b * 0.8, (double)this.attackSpeed * forward.field_72449_c * 0.12);
                }
                if (this.attackFinish && (double)this.attackSpeed < 0.25) {
                    float random0 = (float)((double)MeleeHoveringEntity.this.field_70146_Z.nextFloat() * 0.5 + 0.5);
                    int random1 = 30 + MeleeHoveringEntity.this.field_70146_Z.nextInt(20);
                    this.isAttacking = false;
                    this.attackFinish = false;
                    this.isGainingMomentum = true;
                    this.momentumTimerCap = 120 + MeleeHoveringEntity.this.field_70146_Z.nextInt(100);
                    this.verticalRand = MathHelper.func_151240_a((Random)MeleeHoveringEntity.this.field_70146_Z, (float)4.0f, (float)10.0f);
                    this.horizontalRand = (float)(MeleeHoveringEntity.this.field_70146_Z.nextGaussian() * 2.0);
                    this.momentumRand = MathUtil.motionHelper(random0, 0.0f, 0, random1, this.momentumTimer);
                    this.momentumRandCap = random1;
                }
                if (this.isGainingMomentum) {
                    if (this.momentumTimer < this.momentumRandCap) {
                        this.iceElement.addMotion((double)(-this.momentumRand / (float)this.momentumRandCap) * forward.field_72450_a, (double)(-this.momentumRand / (float)this.momentumRandCap) * forward.field_72448_b, (double)(-this.momentumRand / (float)this.momentumRandCap) * forward.field_72449_c);
                    }
                    Vector3d counterClockwise90 = Vector3d.func_189986_a((float)(MathHelper.func_76142_g((float)MeleeHoveringEntity.this.field_70125_A) + 270.0f), (float)(MathHelper.func_76142_g((float)MeleeHoveringEntity.this.field_70759_as) + 270.0f));
                    this.iceElement.addMotion((double)(this.horizontalRand / (float)this.momentumTimerCap) * counterClockwise90.field_72450_a, (double)(this.verticalRand / (float)this.momentumTimerCap) * counterClockwise90.field_72448_b, (double)(this.horizontalRand / (float)this.momentumTimerCap) * counterClockwise90.field_72449_c);
                    if (++this.momentumTimer > this.momentumTimerCap) {
                        this.isAttacking = true;
                        this.isGainingMomentum = false;
                        this.momentumTimer = 0;
                    }
                }
                this.iceElement.func_70671_ap().func_75651_a((Entity)this.iceElement.func_70638_az(), 30.0f, 180.0f);
                this.iceElement.field_70177_z = MathUtil.getTargetYaw((Entity)this.iceElement, (Entity)this.iceElement.func_70638_az());
                this.iceElement.field_70761_aq = MathUtil.getTargetYaw((Entity)this.iceElement, (Entity)this.iceElement.func_70638_az());
                this.iceElement.field_70126_B = MathUtil.getTargetYaw((Entity)this.iceElement, (Entity)this.iceElement.func_70638_az());
            }
        }

        public void setAttackSpeed(float attackSpeed) {
            this.attackSpeed = MathHelper.func_76131_a((float)attackSpeed, (float)0.2f, (float)1.0f);
        }
    }
}

