/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.common.Entities.living;

import com.danny.dannys_expansion.core.Util.NetworkUtil;
import com.danny.dannys_expansion.core.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.SoundEvent;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

public abstract class MoreContentEntity
extends CreatureEntity {
    public Animation animation = Animation.NO_ANIMATION;
    public int animationTick;
    public int livingSoundBound = 1000;
    public int livingSoundTick;
    public int meleeDelay;
    public int rangedDelay;

    public MoreContentEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        super.func_184651_r();
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.getAnimationTick() < this.animation.getDuration()) {
            ++this.animationTick;
        } else {
            this.setAnimation(Animation.NO_ANIMATION);
        }
        if (this.meleeDelay < this.meleeDelayBound()) {
            ++this.meleeDelay;
        }
        if (this.rangedDelay < this.rangedDelayBound()) {
            ++this.rangedDelay;
        }
        if (this.func_110143_aJ() <= 0.0f) {
            if (this.getDeathAnimation() != null) {
                if (this.func_70613_aW() && !this.isAnimationPlaying(this.getDeathAnimation())) {
                    this.setAnimation(this.getDeathAnimation());
                    this.onDeathStart();
                }
                this.onDeathUpdate(this.getDeathAnimation().getDuration());
            } else {
                this.onDeathUpdate(20);
            }
        }
        if (this.func_70089_S() && this.field_70146_Z.nextInt(this.livingSoundBound / 2) + this.livingSoundBound / 2 < this.livingSoundTick++) {
            this.playLivingSound();
            this.livingSoundTick = 0;
        }
    }

    protected void consumeItemFromStack(PlayerEntity player, ItemStack stack) {
        if (!player.field_71075_bZ.field_75098_d) {
            stack.func_190918_g(1);
        }
    }

    public void setAnimation(Animation animation) {
        this.animation = animation;
        NetworkUtil.setAnimation(this, animation);
        this.setAnimationTick(0);
    }

    public Animation[] getAnimations() {
        return new Animation[0];
    }

    public boolean isAnimationPlaying(Animation animation) {
        return this.animation == animation;
    }

    public int getAnimationTick() {
        return this.animationTick;
    }

    public void setAnimationTick(int animationTick) {
        this.animationTick = animationTick;
    }

    public Animation getAnimation() {
        return this.animation;
    }

    public Animation getDeathAnimation() {
        return null;
    }

    protected void func_70609_aI() {
    }

    protected void onDeathUpdate(int duration) {
        ++this.field_70725_aQ;
        if (this.field_70725_aQ >= duration) {
            this.onDeathEnd();
            this.func_70106_y();
        }
    }

    protected void onDeathStart() {
    }

    protected void onDeathEnd() {
    }

    @Nullable
    public SoundEvent getLivingSound() {
        return super.func_184639_G();
    }

    public void playLivingSound() {
        SoundEvent soundevent = this.getLivingSound();
        if (soundevent != null) {
            this.func_184185_a(soundevent, 0.8f + this.field_70146_Z.nextFloat() * 0.4f, 0.8f + this.field_70146_Z.nextFloat() * 0.4f);
        }
    }

    public boolean onGround() {
        return this.field_70122_E;
    }

    public boolean InFluid() {
        return this.func_70090_H() || this.func_180799_ab();
    }

    public boolean func_213380_a(IWorld worldIn, SpawnReason spawnReasonIn) {
        return true;
    }

    public int meleeDelayBound() {
        return 0;
    }

    public int rangedDelayBound() {
        return 0;
    }
}

