/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.common.Entities.living.animal.rammer;

import com.danny.dannys_expansion.common.Entities.ai.goals.FollowTargetGoal;
import com.danny.dannys_expansion.common.Entities.ai.goals.RammerBreedGoal;
import com.danny.dannys_expansion.common.Entities.ai.goals.RammerPickAppleGoal;
import com.danny.dannys_expansion.common.Entities.ai.goals.meleeAI.RamAttackGoal;
import com.danny.dannys_expansion.common.Entities.living.MoreContentEntity;
import com.danny.dannys_expansion.common.Entities.living.animal.rammer.GrandRammerEntity;
import com.danny.dannys_expansion.common.Entities.util.GetAttributes;
import com.danny.dannys_expansion.core.Registries.ModEntityTypes;
import com.danny.dannys_expansion.core.Util.EntityUtil;
import com.danny.dannys_expansion.core.Util.NetworkUtil;
import com.danny.dannys_expansion.core.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.RandomWalkingGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.item.ItemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ItemParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.Explosion;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public class RammerEntity
extends MoreContentEntity {
    private static final DataParameter<Boolean> IS_TRANSFORMING = EntityDataManager.func_187226_a(RammerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Boolean> IS_IN_LOVE = EntityDataManager.func_187226_a(RammerEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(RammerEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    private static final Ingredient TEMPTATION_ITEMS = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151034_e, Items.field_151153_ao});
    public static final Animation RAM_ATTACK = new Animation(16);
    int transformingTime = 100;
    public int stuffedTicks;
    public int eatTicks;
    int loveTicks;

    public RammerEntity(EntityType<? extends RammerEntity> type, World worldIn) {
        super(type, worldIn);
        this.func_184598_c(Hand.MAIN_HAND);
        this.func_98053_h(true);
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.setSize(1.0f + this.field_70146_Z.nextFloat() * 0.2f);
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(5, (Goal)new RandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new RammerPickAppleGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new FollowTargetGoal(this, 1.2));
        this.field_70714_bg.func_75776_a(0, (Goal)new RammerBreedGoal(this));
        this.field_70714_bg.func_75776_a(6, (Goal)new LookRandomlyGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.0, TEMPTATION_ITEMS, false));
        this.field_70714_bg.func_75776_a(1, (Goal)new RamAttackGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
    }

    public static AttributeModifierMap.MutableAttribute Attributes() {
        return CreatureEntity.func_233666_p_().func_233815_a_(GetAttributes.maxHealth, 40.0).func_233815_a_(GetAttributes.knockbackResistance, 0.8).func_233815_a_(GetAttributes.movementSpeed, 0.26).func_233815_a_(GetAttributes.attackDamage, 6.0);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(IS_TRANSFORMING, (Object)false);
        this.field_70180_af.func_187214_a(IS_IN_LOVE, (Object)false);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSize(MathHelper.func_76131_a((float)compound.func_74760_g("Size"), (float)1.0f, (float)5.0f));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74776_a("Size", this.getSize());
    }

    public void func_184206_a(DataParameter<?> key) {
        if (SIZE.equals(key)) {
            this.func_213323_x_();
        }
        super.func_184206_a(key);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.8f;
    }

    public void setSize(float sizeIn) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(sizeIn));
        this.func_213323_x_();
        this.func_110148_a(GetAttributes.maxHealth).func_111128_a(this.func_110148_a(GetAttributes.maxHealth).func_111125_b() * (double)this.getSize());
        this.func_110148_a(GetAttributes.attackDamage).func_111128_a(this.func_110148_a(GetAttributes.attackDamage).func_111125_b() * (double)this.getSize());
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.isTransforming() && this.func_70089_S()) {
            --this.transformingTime;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197607_R, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 1.0, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 1.0, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 1.0, 0.0, 0.0, 0.0);
            if (this.transformingTime <= 0) {
                this.doTransform();
            }
        }
        if (this.loveTicks > 0) {
            --this.loveTicks;
            if (this.field_70146_Z.nextInt(3) == 1) {
                this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197633_z, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * (double)0.4f, this.func_226278_cu_() + 0.3 + this.field_70146_Z.nextGaussian() * (double)0.4f, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * (double)0.4f, 0.0, 0.0, 0.0);
            }
        } else {
            this.func_184212_Q().func_187227_b(IS_IN_LOVE, (Object)false);
        }
        if (this.stuffedTicks > 0) {
            --this.stuffedTicks;
            if (this.stuffedTicks >= 650) {
                Vector3d forward = Vector3d.func_189986_a((float)0.0f, (float)this.field_70761_aq);
                double x = 1.0 * forward.field_72450_a;
                double y = 0.575;
                double z = 1.0 * forward.field_72449_c;
                if (this.field_70146_Z.nextInt(3) == 1) {
                    this.field_70170_p.func_195594_a((IParticleData)new ItemParticleData(ParticleTypes.field_197591_B, this.func_184614_ca()), this.func_226277_ct_() + x, this.func_226278_cu_() + y, this.func_226281_cx_() + z, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02, this.field_70146_Z.nextGaussian() * 0.02);
                }
            }
            for (int eatSoundTick = 0; eatSoundTick < 40; ++eatSoundTick) {
                if (this.stuffedTicks != 650 + eatSoundTick * 5) continue;
                this.func_184185_a(SoundEvents.field_187537_bA, 1.0f, 1.0f);
            }
            if (this.stuffedTicks <= 650) {
                if (this.func_184614_ca().func_77973_b() == Items.field_151153_ao) {
                    this.startTransforming();
                } else if (this.func_184614_ca().func_77973_b() == Items.field_151034_e) {
                    this.setInLove(true);
                }
                this.func_184611_a(Hand.MAIN_HAND, ItemStack.field_190927_a);
            }
        } else if (this.func_184614_ca().func_77973_b() == Items.field_151034_e || this.func_184614_ca().func_77973_b() == Items.field_151153_ao) {
            NetworkUtil.rammerEatMessage(this);
        }
    }

    protected ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (this.stuffedTicks == 0) {
            if (itemstack.func_77973_b() == Items.field_151153_ao) {
                this.consumeItemFromStack(player, itemstack);
                this.func_184611_a(Hand.MAIN_HAND, Items.field_151153_ao.func_190903_i());
            } else if (itemstack.func_77973_b() == Items.field_151034_e) {
                this.consumeItemFromStack(player, itemstack);
                this.func_184611_a(Hand.MAIN_HAND, Items.field_151034_e.func_190903_i());
            }
        }
        return super.func_230254_b_(player, hand);
    }

    public void startTransforming() {
        this.func_184212_Q().func_187227_b(IS_TRANSFORMING, (Object)true);
        this.func_195064_c(new EffectInstance(Effects.field_76420_g, 720, 1));
        for (int i = 0; i < this.field_70146_Z.nextInt(10) + 10; ++i) {
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + this.field_70146_Z.nextGaussian() * 1.0, this.func_226278_cu_() + this.field_70146_Z.nextGaussian() * 1.0, this.func_226281_cx_() + this.field_70146_Z.nextGaussian() * 1.0, 0.0, 0.0, 0.0);
        }
    }

    public void doTransform() {
        GrandRammerEntity grandRammerEntity = new GrandRammerEntity((EntityType<? extends GrandRammerEntity>)((EntityType)ModEntityTypes.GRAND_RAMMER.get()), this.field_70170_p);
        grandRammerEntity.setSize(this.getSize());
        grandRammerEntity.func_82149_j((Entity)this);
        this.field_70170_p.func_217385_a((Entity)this, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 3.0f, Explosion.Mode.NONE);
        this.field_70170_p.func_217376_c((Entity)grandRammerEntity);
        this.func_70106_y();
    }

    public void setInLove(boolean bool) {
        this.loveTicks = bool ? 200 : 0;
        this.func_184212_Q().func_187227_b(IS_IN_LOVE, (Object)bool);
    }

    public boolean func_98052_bS() {
        return this.stuffedTicks == 0 && super.func_98052_bS();
    }

    public boolean func_213365_e(ItemStack itemstackIn) {
        return itemstackIn.func_77973_b() == Items.field_151034_e || itemstackIn.func_77973_b() == Items.field_151153_ao;
    }

    private void spitOutItem(ItemStack stackIn) {
        if (!stackIn.func_190926_b() && !this.field_70170_p.field_72995_K) {
            ItemEntity itementity = new ItemEntity(this.field_70170_p, this.func_226277_ct_() + this.func_70040_Z().field_72450_a, this.func_226278_cu_() + 1.0, this.func_226281_cx_() + this.func_70040_Z().field_72449_c, stackIn);
            itementity.func_174867_a(40);
            itementity.func_200216_c(this.func_110124_au());
            this.func_184185_a(SoundEvents.field_219629_dC, 1.0f, 1.0f);
            this.field_70170_p.func_217376_c((Entity)itementity);
        }
    }

    protected void func_175445_a(ItemEntity itemEntity) {
        ItemStack itemstack = itemEntity.func_92059_d();
        if (itemEntity.func_92059_d().func_77973_b() == Items.field_151034_e || itemEntity.func_92059_d().func_77973_b() == Items.field_151153_ao) {
            int i = itemstack.func_190916_E();
            if (i > 1) {
                EntityUtil.spawnItem(itemstack.func_77979_a(i - 1), this.field_70170_p, this.func_213303_ch());
            }
            this.spitOutItem(this.func_184582_a(EquipmentSlotType.MAINHAND));
            this.func_233630_a_(itemEntity);
            this.func_184201_a(EquipmentSlotType.MAINHAND, itemstack.func_77979_a(1));
            this.field_82174_bp[EquipmentSlotType.MAINHAND.func_188454_b()] = 2.0f;
            this.func_71001_a((Entity)itemEntity, itemstack.func_190916_E());
            itemEntity.func_70106_y();
        }
    }

    public boolean isTransforming() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_TRANSFORMING);
    }

    public boolean isInLove() {
        return (Boolean)this.func_184212_Q().func_187225_a(IS_IN_LOVE);
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getSize());
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{RAM_ATTACK};
    }
}

