/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.common.Entities.living.slime;

import com.danny.dannys_expansion.common.Entities.ai.goals.slime.RotateRandomlyGoal;
import com.danny.dannys_expansion.common.Entities.ai.goals.slime.RotateToTargetGoal;
import com.danny.dannys_expansion.common.Entities.living.MoreContentEntity;
import com.danny.dannys_expansion.common.Entities.living.animal.rammer.ChildRammerEntity;
import com.danny.dannys_expansion.core.animation.Animation;
import javax.annotation.Nullable;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.HurtByTargetGoal;
import net.minecraft.entity.ai.goal.NearestAttackableTargetGoal;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IronGolemEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;

public abstract class AbstractSlimeEntity
extends MoreContentEntity
implements IMob {
    private static final DataParameter<Float> SIZE = EntityDataManager.func_187226_a(ChildRammerEntity.class, (IDataSerializer)DataSerializers.field_187193_c);
    public static final Animation JUMP = new Animation(17);
    public static final Animation DEATH = new Animation(10);
    public int hopDelayTime;
    public int hopDelay;
    public float horizontalHopSpeed;
    public float hopHeight;
    public boolean wasJumping;

    public AbstractSlimeEntity(EntityType<? extends CreatureEntity> type, World worldIn) {
        super(type, worldIn);
        this.hopDelay = this.hopDelayTime;
        this.horizontalHopSpeed = 0.1f;
        this.hopHeight = 0.7f;
        this.func_213323_x_();
    }

    public ILivingEntityData func_213386_a(IServerWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        this.func_213323_x_();
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    @Override
    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (Goal)new RotateToTargetGoal(this));
        this.field_70714_bg.func_75776_a(2, (Goal)new RotateRandomlyGoal(this));
        this.field_70715_bh.func_75776_a(1, (Goal)new HurtByTargetGoal((CreatureEntity)this, new Class[0]));
        this.field_70715_bh.func_75776_a(2, (Goal)new NearestAttackableTargetGoal((MobEntity)this, PlayerEntity.class, true));
        this.field_70715_bh.func_75776_a(3, (Goal)new NearestAttackableTargetGoal((MobEntity)this, IronGolemEntity.class, true));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SIZE, (Object)Float.valueOf(1.0f));
    }

    public void func_184206_a(DataParameter<?> key) {
        super.func_184206_a(key);
        this.func_213323_x_();
    }

    public void setSize(float sizeIn) {
        this.field_70180_af.func_187227_b(SIZE, (Object)Float.valueOf(sizeIn));
    }

    public EntitySize func_213305_a(Pose poseIn) {
        return super.func_213305_a(poseIn).func_220313_a(this.getSize());
    }

    public float getSize() {
        return ((Float)this.field_70180_af.func_187225_a(SIZE)).floatValue();
    }

    @Override
    public void func_70071_h_() {
        super.func_70071_h_();
        this.field_70143_R = 0.0f;
        if (this.isAnimationPlaying(JUMP) && this.animationTick >= 3 && this.animationTick < 8) {
            float d0 = MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180)));
            float d1 = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180)));
            this.func_70024_g(this.horizontalHopSpeed * -d0, 0.0, this.horizontalHopSpeed * d1);
            if (this.animationTick == 3) {
                this.func_70024_g(0.0, this.hopHeight, 0.0);
                this.func_184185_a(SoundEvents.field_226135_eP_, 0.3f + this.field_70146_Z.nextFloat() * 0.4f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
            }
            if (this.animationTick == 5) {
                this.wasJumping = true;
            }
        }
        if (!this.field_70170_p.field_72995_K) {
            if (--this.hopDelay <= 0 && (this.onGround() || this.InFluid())) {
                this.hopDelay = this.hopDelayTime;
                this.setAnimation(JUMP);
            }
            if (this.wasJumping && this.onGround()) {
                this.func_184185_a(SoundEvents.field_226135_eP_, 0.3f + this.field_70146_Z.nextFloat() * 0.4f, 1.0f + this.field_70146_Z.nextFloat() * 0.2f);
                this.wasJumping = false;
            }
        }
    }

    public void func_70636_d() {
        super.func_70636_d();
        if (this.InFluid()) {
            this.func_70024_g(0.0, 0.05, 0.0);
        }
    }

    @Override
    public Animation[] getAnimations() {
        return new Animation[]{JUMP, DEATH};
    }

    @Nullable
    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_226136_eQ_;
    }
}

