/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.common.World;

import com.danny.dannys_expansion.core.Util.MathUtil;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ISeedReader;

public class GenerationUtil {
    public static void replaceAir(ISeedReader seedReader, BlockPos blockPos, BlockState newBlock) {
        GenerationUtil.replaceBlock(seedReader, blockPos, newBlock, Blocks.field_150350_a.func_176223_P());
    }

    public static void replaceBlock(ISeedReader seedReader, BlockPos blockPos, BlockState replaceBlock, BlockState replacedBlock) {
        if (seedReader.func_180495_p(blockPos) == replacedBlock) {
            seedReader.func_180501_a(blockPos, replaceBlock, 2);
        }
    }

    public static void generateBush(ISeedReader seedReader, BlockPos blockPos, BlockState leaves, BlockState trunk, int height, int width) {
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(0, 0, 0), trunk);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(1, 0, 0), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(-1, 0, 0), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(0, 0, 1), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(0, 0, -1), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(0, height, 0), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(1, height, 0), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(-1, height, 0), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(0, height, 1), leaves);
        GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(0, height, -1), leaves);
        for (int i = -width; i < width; ++i) {
            for (int j = -width + 1; j < width - 1; ++j) {
                for (int k = 0; k < height; ++k) {
                    GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(j, k, i), leaves);
                    GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(i, k, j), leaves);
                }
            }
        }
    }

    public static void generateCube(ISeedReader seedReader, BlockPos blockPos, BlockState blockState, int height, int width, int depth, boolean replaceAir) {
        if (!replaceAir) {
            for (int i = -height; i < height; ++i) {
                for (int j = -width; j < width; ++j) {
                    for (int k = -depth; k < depth; ++k) {
                        seedReader.func_180501_a(blockPos.func_177982_a(width, height, depth), blockState, 2);
                    }
                }
            }
        } else {
            GenerationUtil.replaceAir(seedReader, blockPos.func_177982_a(width, height, depth), blockState);
        }
    }

    public static void generateSmartLine(ISeedReader seedReader, BlockPos start, BlockPos end, BlockState blockState) {
        int XDifference = end.func_177958_n() - start.func_177958_n();
        int YDifference = end.func_177956_o() - start.func_177956_o();
        int ZDifference = end.func_177952_p() - start.func_177952_p();
        double XY = MathUtil.getBlockDistance(XDifference, YDifference);
        double YZ = MathUtil.getBlockDistance(YDifference, ZDifference);
        double ZX = MathUtil.getBlockDistance(ZDifference, XDifference);
        for (float i = 0.0f; i < (float)XDifference || i > (float)XDifference; i += (float)((double)XDifference / YZ)) {
            for (float j = 0.0f; j < (float)YDifference || i > (float)YDifference; j += (float)((double)YDifference / ZX)) {
                for (float k = 0.0f; k < (float)ZDifference || i > (float)ZDifference; k += (float)((double)ZDifference / XY)) {
                    seedReader.func_180501_a(start.func_177963_a((double)i, (double)j, (double)k), blockState, 2);
                }
            }
        }
    }

    public static void cylinderBrush(ISeedReader seedReader, BlockPos pos, int radius, BlockState replaceBlock, BlockState replacedBlock) {
        for (int i = -radius; i < radius; ++i) {
            for (int j = -radius; j < radius; ++j) {
                if (!(MathUtil.getBlockDistance(0, 0, i, j) < (float)radius)) continue;
                for (int k = -7; k < 7; ++k) {
                    GenerationUtil.replaceBlock(seedReader, pos.func_177982_a(i, k, j), replaceBlock, replacedBlock);
                }
            }
        }
    }

    public static void generateSphere(ISeedReader seedReader, BlockPos pos, float radius, BlockState block) {
        int i = (int)(-radius);
        while ((float)i < radius) {
            int j = (int)(-radius);
            while ((float)j < radius) {
                int k = (int)(-radius);
                while ((float)k < radius) {
                    if (MathUtil.getBlockDistance(0, 0, 0, i, j, k) < radius) {
                        seedReader.func_180501_a(pos.func_177982_a(i, j, k), block, 2);
                    }
                    ++k;
                }
                ++j;
            }
            ++i;
        }
    }
}

