/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.Packets;

import com.danny.dannys_expansion.common.Entities.living.MoreContentEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class AnimationPacket {
    private final int entityId;
    private final int animationIndex;

    public AnimationPacket(PacketBuffer packetBuffer) {
        this.entityId = packetBuffer.readInt();
        this.animationIndex = packetBuffer.readInt();
    }

    public AnimationPacket(int entityId, int index) {
        this.entityId = entityId;
        this.animationIndex = index;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.entityId);
        packetBuffer.writeInt(this.animationIndex);
    }

    public static void handle(AnimationPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                MoreContentEntity entity;
                if (Minecraft.func_71410_x().field_71439_g != null && (entity = (MoreContentEntity)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(msg.entityId)) != null && msg.animationIndex != -1) {
                    entity.setAnimation(entity.getAnimations()[msg.animationIndex]);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

