/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.Packets;

import com.danny.dannys_expansion.common.Entities.AbstractSpellEntity;
import java.util.function.Supplier;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class CRotationPacket {
    private int entityId;
    private final float rotationYaw;
    private final float rotationPitch;

    public static CRotationPacket cRotationPacket(PacketBuffer buf) {
        return new CRotationPacket(buf.readInt(), buf.readFloat(), buf.readFloat());
    }

    public CRotationPacket(int entityId, float rotationYaw, float rotationPitch) {
        this.entityId = entityId;
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.entityId);
        packetBuffer.writeFloat(this.rotationYaw);
        packetBuffer.writeFloat(this.rotationPitch);
    }

    public static void handle(CRotationPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                AbstractSpellEntity entity = (AbstractSpellEntity)context.getSender().field_70170_p.func_73045_a(msg.entityId);
                entity.spellYaw = msg.rotationYaw;
                entity.spellPitch = msg.rotationYaw;
            });
            context.setPacketHandled(true);
        }
    }
}

