/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.Packets;

import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class EntityMotionPacket {
    private final int entityId;
    private final float x;
    private final float y;
    private final float z;

    public EntityMotionPacket(PacketBuffer packetBuffer) {
        this.entityId = packetBuffer.readInt();
        this.x = packetBuffer.readFloat();
        this.y = packetBuffer.readFloat();
        this.z = packetBuffer.readFloat();
    }

    public EntityMotionPacket(int entityId, float x, float y, float z) {
        this.entityId = entityId;
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.entityId);
        packetBuffer.writeFloat(this.x);
        packetBuffer.writeFloat(this.y);
        packetBuffer.writeFloat(this.z);
    }

    public static void handle(EntityMotionPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                Entity entity;
                if (Minecraft.func_71410_x().field_71439_g != null && (entity = Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(msg.entityId)) != null) {
                    entity.func_213293_j((double)msg.x, (double)msg.y, (double)msg.z);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

