/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.Packets;

import com.danny.dannys_expansion.common.Entities.AbstractSpellEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class RotationPacket {
    private final int entityId;
    private final float rotationYaw;
    private final float rotationPitch;
    private final boolean sharpTrans;

    public RotationPacket(PacketBuffer packetBuffer) {
        this.entityId = packetBuffer.readInt();
        this.rotationYaw = packetBuffer.readFloat();
        this.rotationPitch = packetBuffer.readFloat();
        this.sharpTrans = packetBuffer.readBoolean();
    }

    public RotationPacket(int entityId, float rotationYaw, float rotationPitch, boolean sharpTrans) {
        this.entityId = entityId;
        this.rotationYaw = rotationYaw;
        this.rotationPitch = rotationPitch;
        this.sharpTrans = sharpTrans;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.entityId);
        packetBuffer.writeFloat(this.rotationYaw);
        packetBuffer.writeFloat(this.rotationPitch);
        packetBuffer.writeBoolean(this.sharpTrans);
    }

    public static void handle(RotationPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                AbstractSpellEntity entity;
                if (Minecraft.func_71410_x().field_71439_g != null && (entity = (AbstractSpellEntity)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(msg.entityId)) != null) {
                    if (msg.sharpTrans) {
                        entity.prevSpellYaw = entity.spellYaw = msg.rotationYaw;
                        entity.prevSpellPitch = entity.spellPitch = msg.rotationPitch;
                    } else {
                        entity.prevSpellYaw = entity.spellYaw;
                        entity.field_70177_z = msg.rotationYaw;
                        entity.spellYaw = msg.rotationYaw;
                        entity.prevSpellPitch = entity.spellPitch;
                        entity.field_70125_A = msg.rotationPitch;
                        entity.spellPitch = msg.rotationPitch;
                    }
                }
            });
            context.setPacketHandled(true);
        }
    }
}

