/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.Packets;

import com.danny.dannys_expansion.common.Entities.AbstractSpellEntity;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.PacketBuffer;
import net.minecraftforge.fml.LogicalSide;
import net.minecraftforge.fml.network.NetworkEvent;

public class SpellAttackPacket {
    private final int entityId;
    private final int lifeTime;

    public SpellAttackPacket(PacketBuffer packetBuffer) {
        this.entityId = packetBuffer.readInt();
        this.lifeTime = packetBuffer.readInt();
    }

    public SpellAttackPacket(int entityId, int lifeTime) {
        this.entityId = entityId;
        this.lifeTime = lifeTime;
    }

    public void encode(PacketBuffer packetBuffer) {
        packetBuffer.writeInt(this.entityId);
        packetBuffer.writeInt(this.lifeTime);
    }

    public static void handle(SpellAttackPacket msg, Supplier<NetworkEvent.Context> ctx) {
        NetworkEvent.Context context = ctx.get();
        if (context.getDirection().getReceptionSide() == LogicalSide.CLIENT) {
            context.enqueueWork(() -> {
                AbstractSpellEntity entity;
                if (Minecraft.func_71410_x().field_71439_g != null && (entity = (AbstractSpellEntity)Minecraft.func_71410_x().field_71439_g.field_70170_p.func_73045_a(msg.entityId)) != null) {
                    entity.setLifeTick(msg.lifeTime);
                }
            });
            context.setPacketHandled(true);
        }
    }
}

