/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.Util;

import com.danny.dannys_expansion.core.animation.Easing;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.IBlockReader;

public class MathUtil {
    public static float getBlockDistance(int a1, int a2, int b1, int b2) {
        return (float)Math.sqrt(Math.pow(a1 - b1, 2.0) + Math.pow(a2 - b2, 2.0));
    }

    public static float getBlockDistance(int pos1, int pos2) {
        return (float)Math.sqrt(Math.pow(pos1, 2.0) + Math.pow(pos2, 2.0));
    }

    public static float getBlockDistance(int a1, int a2, int a3, int b1, int b2, int b3) {
        return (float)Math.sqrt(Math.pow(a1 - b1, 2.0) + Math.pow(a2 - b2, 2.0) + Math.pow(a3 - b3, 2.0));
    }

    public static float freeAnimator(float amount, float weight, int prevTick, int tick, Easing easing, float timer) {
        return MathUtil.freeAnimator(amount, weight, prevTick, tick, easing, timer, false);
    }

    public static float freeAnimator(float amount, float weight, int prevTick, int tick, Easing easing, float timer, boolean keepValue) {
        if (timer >= (float)prevTick && timer < (float)tick) {
            float uneasedProg = (timer - (float)prevTick) / (float)(tick - prevTick);
            float prog = easing.progression(uneasedProg) * amount + weight;
            return prog;
        }
        if (keepValue) {
            return timer > (float)tick ? 1.0f : 0.0f;
        }
        return 0.0f;
    }

    public static float motionHelper(float amount, float weight, int prevTick, int tick, int timer) {
        if (timer >= prevTick && timer < tick) {
            return amount + weight;
        }
        return 0.0f;
    }

    public static float clampedRotate(float from, float to, float maxDelta) {
        float f = MathHelper.func_203302_c((float)from, (float)to);
        float f1 = MathHelper.func_76131_a((float)f, (float)(-maxDelta), (float)maxDelta);
        return from + f1;
    }

    public static float getTargetPitch(Entity entity1, Entity entity2) {
        double d0 = entity2.func_226277_ct_() - entity1.func_226277_ct_();
        double d1 = entity2.func_226278_cu_() + entity2.func_174813_aQ().func_216360_c() / 2.0 - entity1.func_226278_cu_();
        double d2 = entity2.func_226281_cx_() - entity1.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        return (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
    }

    public static float getTargetPitch(Entity entity1, double x, double y, double z) {
        double d0 = x - entity1.func_226277_ct_();
        double d1 = y - entity1.func_226278_cu_();
        double d2 = z - entity1.func_226281_cx_();
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d2 * d2));
        return (float)(-(MathHelper.func_181159_b((double)d1, (double)d3) * 57.2957763671875));
    }

    public static float getTargetYaw(Entity entity1, Entity entity2) {
        double d0 = entity2.func_226277_ct_() - entity1.func_226277_ct_();
        double d1 = entity2.func_226281_cx_() - entity1.func_226281_cx_();
        return (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    public static float getTargetYaw(Entity entity1, double x, double y) {
        double d0 = x - entity1.func_226277_ct_();
        double d1 = y - entity1.func_226281_cx_();
        return (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    public static float getTargetYaw(double x, double y, double x1, double y1) {
        double d0 = x1 - x;
        double d1 = y1 - y;
        return (float)(MathHelper.func_181159_b((double)d1, (double)d0) * 57.2957763671875) - 90.0f;
    }

    public static Vector3d fromPitchYaw(float pitch, float yaw) {
        float f = MathHelper.func_76134_b((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f1 = MathHelper.func_76126_a((float)(-yaw * ((float)Math.PI / 180) - (float)Math.PI));
        float f2 = -MathHelper.func_76134_b((float)(-pitch * ((float)Math.PI / 180)));
        float f3 = MathHelper.func_76126_a((float)(-pitch * ((float)Math.PI / 180)));
        return new Vector3d((double)(f1 * f2), (double)f3, (double)(f * f2));
    }

    public static int verticalNonSolid(IBlockReader worldIn, BlockPos pos, int sum, int max) {
        int j = 0;
        for (int i = 0; !(i >= Math.abs(max) || worldIn.func_180495_p(pos.func_177963_a(0.0, (double)(j + sum), 0.0)).func_200132_m() && worldIn.func_180495_p(pos.func_177963_a(0.0, (double)(j + sum), 0.0)) != Blocks.field_150432_aD.func_176223_P()); ++i) {
            j += sum;
        }
        return Math.abs(j);
    }
}

