/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.animation;

import com.danny.dannys_expansion.core.Util.ClientInstance;
import com.danny.dannys_expansion.core.animation.MoreContentModelRenderer;
import com.google.common.collect.Lists;
import java.util.List;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public abstract class CustomEntityModel<E extends Entity>
extends EntityModel<E> {
    public List<MoreContentModelRenderer> defaultValues = Lists.newArrayList();
    protected float partialTick = ClientInstance.partialTicks();
    public E entity;
    public float radian = (float)Math.PI / 180;
    public float globalSpeed;
    public float netHeadYaw;
    public float headPitch;

    public void func_225597_a_(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        this.setDefaultState();
        this.entity = entityIn;
        this.netHeadYaw = netHeadYaw * this.radian / 180.0f;
        this.headPitch = headPitch * this.radian / 180.0f;
    }

    public void func_212843_a_(E entityIn, float limbSwing, float limbSwingAmount, float partialTick) {
        super.func_212843_a_(entityIn, limbSwing, limbSwingAmount, partialTick);
        this.partialTick = partialTick;
    }

    public void getDefaultState() {
        this.defaultValues.forEach(MoreContentModelRenderer::getDefaultState);
    }

    public void setDefaultState() {
        this.defaultValues.forEach(MoreContentModelRenderer::setDefaultState);
    }

    public void setRotationAngle(MoreContentModelRenderer MoreContentModelRenderer2, float x, float y, float z) {
        MoreContentModelRenderer2.field_78795_f = x;
        MoreContentModelRenderer2.field_78796_g = y;
        MoreContentModelRenderer2.field_78808_h = z;
    }

    public void setOffset(MoreContentModelRenderer part, float x, float y, float z) {
        part.field_78800_c = x;
        part.field_78797_d = y;
        part.field_78798_e = z;
    }

    public void setSize(MoreContentModelRenderer part, float x, float y, float z) {
        part.scaleX = x;
        part.scaleY = y;
        part.scaleZ = z;
    }

    public void addRotation(MoreContentModelRenderer part, float x, float y, float z) {
        part.field_78795_f = (float)((double)part.field_78795_f + Math.toRadians(x));
        part.field_78796_g = (float)((double)part.field_78796_g + Math.toRadians(y));
        part.field_78808_h = (float)((double)part.field_78808_h + Math.toRadians(z));
    }

    public void addOffset(MoreContentModelRenderer part, float x, float y, float z) {
        part.field_78800_c += x;
        part.field_78797_d += y;
        part.field_78798_e += z;
    }

    public void addSize(MoreContentModelRenderer part, float x, float y, float z) {
        part.scaleX += x;
        part.scaleY += y;
        part.scaleZ += z;
    }

    public void addRotation(MoreContentModelRenderer part, float x, float y, float z, float mult) {
        part.field_78795_f = (float)((double)part.field_78795_f + Math.toRadians(x) * (double)mult);
        part.field_78796_g = (float)((double)part.field_78796_g + Math.toRadians(y) * (double)mult);
        part.field_78808_h = (float)((double)part.field_78808_h + Math.toRadians(z) * (double)mult);
    }

    public void addOffset(MoreContentModelRenderer part, float x, float y, float z, float mult) {
        part.field_78800_c += x * mult;
        part.field_78797_d += y * mult;
        part.field_78798_e += z * mult;
    }

    public void addSize(MoreContentModelRenderer part, float x, float y, float z, float mult) {
        part.scaleX += x * mult;
        part.scaleY += y * mult;
        part.scaleZ += z * mult;
    }

    public float walkRotationHelper(float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        return invert ? MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (-amount * this.radian * 2.0f) * limbSwingAmount + weight * limbSwingAmount * this.radian : MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (amount * this.radian * 2.0f) * limbSwingAmount + weight * limbSwingAmount * this.radian;
    }

    public float walkOffsetHelper(float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        return invert ? MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (-amount * 2.0f) * limbSwingAmount + weight * limbSwingAmount : MathHelper.func_76134_b((float)(limbSwing * speed + desync * (float)Math.PI)) * (amount * 2.0f) * limbSwingAmount + weight * limbSwingAmount;
    }

    public void walkRotateX(MoreContentModelRenderer part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78795_f += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkRotateY(MoreContentModelRenderer part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78796_g += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkRotateZ(MoreContentModelRenderer part, float speed, float degrees, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78808_h += this.walkRotationHelper(speed, degrees, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkOffsetX(MoreContentModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78800_c += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkOffsetY(MoreContentModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78797_d += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }

    public void walkOffsetZ(MoreContentModelRenderer part, float speed, float amount, float desync, float weight, float limbSwing, float limbSwingAmount, boolean invert) {
        part.field_78798_e += this.walkOffsetHelper(speed, amount, desync, weight, limbSwing, limbSwingAmount, invert);
    }
}

