/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.animation;

public abstract class Easing {
    public static final Easing LINEAR = new Easing(){

        @Override
        public float progression(float value) {
            return value;
        }
    };
    public static final Easing EASE_IN_CUBIC = new Easing(){

        @Override
        public float progression(float value) {
            return value * value * value;
        }
    };
    public static final Easing EASE_OUT_CUBIC = new Easing(){

        @Override
        public float progression(float value) {
            return (float)(1.0 - Math.pow(1.0f - value, 3.0));
        }
    };
    public static final Easing EASE_BOTH_CUBIC = new Easing(){

        @Override
        public float progression(float value) {
            return (double)value <= 0.5 ? value * value * value : (float)(1.0 - Math.pow(1.0f - value, 3.0));
        }
    };
    public static final Easing EASE_IN_SQUARE = new Easing(){

        @Override
        public float progression(float value) {
            return value * value;
        }
    };
    public static final Easing EASE_OUT_SQUARE = new Easing(){

        @Override
        public float progression(float value) {
            return (float)(1.0 - Math.pow(1.0f - value, 2.0));
        }
    };
    public static final Easing EASE_IN_OUT_BACK = new Easing(){

        @Override
        public float progression(float value) {
            double c4 = 2.0943951023931953;
            return value == 0.0f ? 0.0f : (float)(value == 1.0f ? 1.0 : Math.pow(2.0, -10.0f * value) * Math.sin(((double)(value * 10.0f) - 0.75) * c4) + 1.0);
        }
    };
    public static final Easing BOUNCE_OUT = new Easing(){

        @Override
        public float progression(float value) {
            double n1 = 7.5625;
            double d1 = 2.75;
            if ((double)value < 1.0 / d1) {
                return (float)(n1 * (double)value * (double)value);
            }
            if ((double)value < 2.0 / d1) {
                value = (float)((double)value - 1.5 / d1);
                return (float)(n1 * (double)value * (double)value + 0.75);
            }
            if ((double)value < 2.5 / d1) {
                value = (float)((double)value - 2.25 / d1);
                return (float)(n1 * (double)value * (double)value + 0.9375);
            }
            value = (float)((double)value - 2.625 / d1);
            return (float)(n1 * (double)value * (double)value + 0.984375);
        }
    };

    public abstract float progression(float var1);
}

