/*
 * Decompiled with CFR 0.152.
 */
package com.danny.dannys_expansion.core.animation;

import com.danny.dannys_expansion.common.Entities.AbstractSpellEntity;
import com.danny.dannys_expansion.core.animation.CustomEntityModel;
import com.danny.dannys_expansion.core.animation.Easing;
import com.danny.dannys_expansion.core.animation.MoreContentModelRenderer;
import com.danny.dannys_expansion.core.animation.Transform;
import com.google.common.collect.Maps;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.vertex.IVertexBuilder;
import java.util.Map;

public abstract class SpellEntityModel<E extends AbstractSpellEntity>
extends CustomEntityModel<E> {
    private final Map<MoreContentModelRenderer, Transform> transformMap = Maps.newHashMap();
    private final Map<MoreContentModelRenderer, Transform> prevTransformMap = Maps.newHashMap();
    public int tick = 0;
    public int prevtick = 0;

    public void setRotationAngles(E entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        super.func_225597_a_(entityIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch);
        this.animateModel((AbstractSpellEntity)this.entity);
    }

    public void func_225598_a_(MatrixStack matrixStackIn, IVertexBuilder bufferIn, int packedLightIn, int packedOverlayIn, float red, float green, float blue, float alpha) {
        this.animateModel((AbstractSpellEntity)this.entity);
    }

    public void animateModel(E entity) {
        this.tick = 0;
        this.prevtick = 0;
        this.transformMap.clear();
        this.prevTransformMap.clear();
    }

    public void getPartialTick(float partialTick) {
        this.partialTick = partialTick;
    }

    private Transform getTransform(MoreContentModelRenderer part) {
        return this.transformMap.computeIfAbsent(part, transform -> new Transform());
    }

    public void rotate(MoreContentModelRenderer box, float x, float y, float z) {
        this.getTransform(box).addRotation(x, y, z);
    }

    public void move(MoreContentModelRenderer box, float x, float y, float z) {
        this.getTransform(box).addOffset(x, y, z);
    }

    public void scale(MoreContentModelRenderer box, float x, float y, float z) {
        this.getTransform(box).addScale(x, y, z);
    }

    public void setKeyframeDuration(int duration) {
        this.prevtick = this.tick;
        this.tick += duration;
    }

    public void resetKeyframe(int duration, Easing easing) {
        this.setKeyframeDuration(duration);
        this.setTransformToModel(easing);
    }

    public void setStaticKeyframe(int duration) {
        this.setKeyframeDuration(duration);
        this.addTransformToModel(Easing.LINEAR);
    }

    public void setTransformToModel(Easing easing) {
        float animationTick = (float)((AbstractSpellEntity)this.entity).getLifeTick() + this.partialTick;
        if (animationTick >= (float)this.prevtick && animationTick < (float)this.tick) {
            Transform transform;
            float uneasedProg = (animationTick - (float)this.prevtick) / (float)(this.tick - this.prevtick);
            float prog = easing.progression(uneasedProg);
            float invProg = 1.0f - prog;
            for (MoreContentModelRenderer box : this.prevTransformMap.keySet()) {
                transform = this.prevTransformMap.get((Object)box);
                box.field_78795_f += invProg * transform.getRotationX();
                box.field_78796_g += invProg * transform.getRotationY();
                box.field_78808_h += invProg * transform.getRotationZ();
                box.field_78800_c += invProg * transform.getOffsetX();
                box.field_78797_d += invProg * transform.getOffsetY();
                box.field_78798_e += invProg * transform.getOffsetZ();
                box.scaleX += invProg * transform.getScaleX();
                box.scaleY += invProg * transform.getScaleY();
                box.scaleZ += invProg * transform.getScaleZ();
            }
            for (MoreContentModelRenderer box : this.transformMap.keySet()) {
                transform = this.transformMap.get((Object)box);
                box.field_78795_f += prog * transform.getRotationX();
                box.field_78796_g += prog * transform.getRotationY();
                box.field_78808_h += prog * transform.getRotationZ();
                box.field_78800_c += prog * transform.getOffsetX();
                box.field_78797_d += prog * transform.getOffsetY();
                box.field_78798_e += prog * transform.getOffsetZ();
                box.scaleX += prog * transform.getScaleX();
                box.scaleY += prog * transform.getScaleY();
                box.scaleZ += prog * transform.getScaleZ();
            }
        }
        this.prevTransformMap.clear();
        this.prevTransformMap.putAll(this.transformMap);
        this.transformMap.clear();
    }

    public void setTransformToModel() {
        this.setTransformToModel(Easing.LINEAR);
    }

    public void addTransformToModel(Easing easing) {
        float animationTick = (float)((AbstractSpellEntity)this.entity).getLifeTick() + this.partialTick;
        if (animationTick >= (float)this.prevtick && animationTick < (float)this.tick) {
            Transform transform;
            float uneasedProg = (animationTick - (float)this.prevtick) / (float)(this.tick - this.prevtick);
            float prog = easing.progression(uneasedProg);
            float invProg = 1.0f - prog;
            for (MoreContentModelRenderer box : this.prevTransformMap.keySet()) {
                transform = this.prevTransformMap.get((Object)box);
                box.field_78795_f += transform.getRotationX();
                box.field_78796_g += transform.getRotationY();
                box.field_78808_h += transform.getRotationZ();
                box.field_78800_c += transform.getOffsetX();
                box.field_78797_d += transform.getOffsetY();
                box.field_78798_e += transform.getOffsetZ();
                box.scaleX += transform.getScaleX();
                box.scaleY += transform.getScaleY();
                box.scaleZ += transform.getScaleZ();
            }
            for (MoreContentModelRenderer box : this.transformMap.keySet()) {
                transform = this.transformMap.get((Object)box);
                box.field_78795_f += prog * transform.getRotationX();
                box.field_78796_g += prog * transform.getRotationY();
                box.field_78808_h += prog * transform.getRotationZ();
                box.field_78800_c += prog * transform.getOffsetX();
                box.field_78797_d += prog * transform.getOffsetY();
                box.field_78798_e += prog * transform.getOffsetZ();
                box.scaleX += prog * transform.getScaleX();
                box.scaleY += prog * transform.getScaleY();
                box.scaleZ += prog * transform.getScaleZ();
            }
        }
    }
}

