/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.audio;

import net.minecraft.block.Blocks;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.LightType;

public class MovingWeatherSound
extends TickableSound {
    private final float originalVolume;

    public MovingWeatherSound(SoundEvent soundIn, int replayRate, SoundCategory categoryIn, BlockPos initialPosition, float originalVolume, float pitch) {
        super(soundIn, categoryIn);
        this.field_147660_d = initialPosition.func_177958_n();
        this.field_147661_e = initialPosition.func_177956_o();
        this.field_147658_f = initialPosition.func_177952_p();
        this.originalVolume = originalVolume;
        this.field_147662_b = originalVolume;
        this.field_147663_c = pitch;
        this.field_147659_g = true;
        this.field_147665_h = replayRate;
    }

    public void func_73660_a() {
        Minecraft mc = Minecraft.func_71410_x();
        BlockPos livePosition = mc.field_71460_t.func_215316_n().func_216780_d();
        this.field_147660_d = livePosition.func_177958_n();
        this.field_147661_e = livePosition.func_177956_o();
        this.field_147658_f = livePosition.func_177952_p();
        this.changeVolumeDynamically(mc, livePosition);
    }

    public void changeVolumeDynamically(Minecraft mc, BlockPos livePosition) {
        float partialTicks = mc.func_147113_T() ? mc.field_193996_ah : mc.field_71428_T.field_194147_b;
        float fade = mc.field_71441_e.func_72867_j(partialTicks);
        float finalVolume = this.originalVolume;
        IsInsideAudioHelper isInsideAudioHelper = new IsInsideAudioHelper(livePosition, mc, this.originalVolume);
        finalVolume = isInsideAudioHelper.getFinalVolume();
        if (mc.field_71441_e.func_180495_p(livePosition).func_177230_c() == Blocks.field_150355_j && mc.field_71441_e.func_180495_p(livePosition).func_204520_s().func_206882_g() >= 6) {
            finalVolume /= 2.0f;
        }
        float clampedFinalVolume = MathHelper.func_76131_a((float)finalVolume, (float)0.01f, (float)1.0f);
        this.field_147662_b = fade * clampedFinalVolume;
        if (this.field_147662_b == 0.0f) {
            this.func_239509_o_();
        }
    }

    public static class IsInsideAudioHelper {
        private final float originalVolume;
        private final float finalVolume;

        private IsInsideAudioHelper(BlockPos playerLivePos, Minecraft mc, float originalVolume) {
            this.originalVolume = originalVolume;
            int lightLevel = mc.field_71441_e.func_226658_a_(LightType.SKY, playerLivePos);
            float multiplier = originalVolume / 15.0f;
            this.finalVolume = (float)lightLevel * multiplier;
        }

        public float getFinalVolume() {
            return MathHelper.func_76131_a((float)this.finalVolume, (float)0.01f, (float)this.originalVolume);
        }
    }
}

