/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.config.json.overrides;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.config.json.overrides.BiomeToOverrideStorageJsonStorage;
import corgitaco.betterweather.config.json.overrides.OverrideDeserializer;
import corgitaco.betterweather.season.Season;
import corgitaco.betterweather.util.storage.OverrideStorage;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.IdentityHashMap;

public class BiomeOverrideJsonHandler {
    public static void handleOverrideJsonConfigs(Path path, IdentityHashMap<Object, OverrideStorage> objectToOverrideStorageDefault, Season.SubSeason subSeason) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(BiomeToOverrideStorageJsonStorage.class, (Object)new OverrideDeserializer());
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        File CONFIG_FILE = new File(String.valueOf(path));
        if (!CONFIG_FILE.exists() && !objectToOverrideStorageDefault.isEmpty()) {
            BiomeOverrideJsonHandler.createOverridesJson(path, objectToOverrideStorageDefault);
        }
        if (CONFIG_FILE.exists()) {
            try (FileReader reader = new FileReader(path.toString());){
                BiomeToOverrideStorageJsonStorage biomeToOverrideStorageJsonStorage = (BiomeToOverrideStorageJsonStorage)gson.fromJson((Reader)reader, BiomeToOverrideStorageJsonStorage.class);
                if (biomeToOverrideStorageJsonStorage != null) {
                    subSeason.setBiomeToOverrideStorage(biomeToOverrideStorageJsonStorage.getBiomeToOverrideStorage());
                    subSeason.setCropToMultiplierStorage(biomeToOverrideStorageJsonStorage.getSeasonCropOverrides());
                } else {
                    BetterWeather.LOGGER.error("betterweather-biomes.json could not be read");
                }
            }
            catch (IOException e) {
                BetterWeather.LOGGER.error("betterweather-biomes.json could not be read");
            }
        }
    }

    public static void createOverridesJson(Path path, IdentityHashMap<Object, OverrideStorage> objectToOverrideStorageDefault) {
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter(BiomeToOverrideStorageJsonStorage.ObjectToOverrideStorageJsonStorage.class, (Object)new OverrideDeserializer.ObjectToOverrideStorageJsonStorageSerializer());
        gsonBuilder.setPrettyPrinting();
        gsonBuilder.disableHtmlEscaping();
        Gson gson = gsonBuilder.create();
        String jsonString = gson.toJson((Object)new BiomeToOverrideStorageJsonStorage.ObjectToOverrideStorageJsonStorage(objectToOverrideStorageDefault));
        try {
            Files.createDirectories(path.getParent(), new FileAttribute[0]);
            Files.write(path, jsonString.getBytes(), new OpenOption[0]);
        }
        catch (IOException e) {
            BetterWeather.LOGGER.error("betterweather-biomes.json could not be created");
        }
    }
}

