/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.datastorage;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.weatherevent.BetterWeatherID;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.api.weatherevent.WeatherEvent;
import corgitaco.betterweather.weatherevent.WeatherEventSystem;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.DimensionSavedDataManager;
import net.minecraft.world.storage.WorldSavedData;

public class BetterWeatherEventData
extends WorldSavedData {
    public static String DATA_NAME = "betterweather:weather_event_data";
    private BetterWeatherID event = WeatherEventSystem.CLEAR;
    private boolean isWeatherForced;
    private boolean modified;

    public BetterWeatherEventData() {
        super(DATA_NAME);
    }

    public BetterWeatherEventData(String s) {
        super(s);
    }

    public static BetterWeatherEventData get(IWorld world) {
        if (!(world instanceof ServerWorld)) {
            return new BetterWeatherEventData();
        }
        ServerWorld overWorld = ((ServerWorld)world).func_201672_e().func_73046_m().func_71218_a(World.field_234918_g_);
        DimensionSavedDataManager data = overWorld.func_217481_x();
        BetterWeatherEventData weatherData = (BetterWeatherEventData)data.func_215752_a(BetterWeatherEventData::new, DATA_NAME);
        if (weatherData == null) {
            weatherData = new BetterWeatherEventData();
            data.func_215757_a((WorldSavedData)weatherData);
        }
        return weatherData;
    }

    public void func_76184_a(CompoundNBT nbt) {
        this.setEvent(nbt.func_74779_i("Event"));
        this.setWeatherForced(nbt.func_74767_n("Forced"));
        this.setModified(nbt.func_74767_n("Modified"));
    }

    public CompoundNBT func_189551_b(CompoundNBT compound) {
        compound.func_74778_a("Event", this.event.toString());
        compound.func_74757_a("Forced", this.isWeatherForced);
        compound.func_74757_a("Modified", this.modified);
        return compound;
    }

    @Deprecated
    public boolean isAcidRain() {
        return this.event == WeatherEventSystem.ACID_RAIN;
    }

    @Deprecated
    public boolean isBlizzard() {
        return this.event == WeatherEventSystem.BLIZZARD;
    }

    public String getEventString() {
        return this.event.toString();
    }

    public BetterWeatherID getEventID() {
        return this.event;
    }

    public WeatherEvent getEvent() {
        WeatherEvent weatherEvent = WeatherEventSystem.WEATHER_EVENTS.get(this.event);
        if (weatherEvent == null) {
            weatherEvent = WeatherEventSystem.WEATHER_EVENTS.get(WeatherEventSystem.CLEAR);
            BetterWeather.LOGGER.error("Getting the current Weather Event saved data was null for this world, restoring data by defaulting to clear...");
        }
        return weatherEvent;
    }

    public void setEvent(String event) {
        this.event = new BetterWeatherID(event);
        this.func_76185_a();
        WeatherEvent currentWeatherEvent = WeatherEventSystem.WEATHER_EVENTS.get(this.event);
        if (currentWeatherEvent == null) {
            WeatherData.currentWeatherEvent = WeatherEventSystem.WEATHER_EVENTS.get(WeatherEventSystem.CLEAR);
            BetterWeather.LOGGER.error("Setting the current Weather Event saved data was null for this world, restoring data by defaulting to clear...");
        } else {
            WeatherData.currentWeatherEvent = currentWeatherEvent;
        }
    }

    public boolean isWeatherForced() {
        return this.isWeatherForced;
    }

    public void setWeatherForced(boolean weatherForced) {
        this.isWeatherForced = weatherForced;
        this.func_76185_a();
    }

    public boolean isModified() {
        return this.modified;
    }

    public void setModified(boolean modified) {
        this.modified = modified;
        this.func_76185_a();
    }
}

