/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.entity;

import com.google.common.collect.ImmutableList;
import java.util.Arrays;
import net.minecraft.client.renderer.entity.model.SegmentedModel;
import net.minecraft.client.renderer.model.Model;
import net.minecraft.client.renderer.model.ModelRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class TornadoModel<T extends Entity>
extends SegmentedModel<T> {
    private final ModelRenderer[] tornadoObjects = new ModelRenderer[7680];
    private final ImmutableList<ModelRenderer> modelRenderers;

    public TornadoModel() {
        for (int i = 0; i < this.tornadoObjects.length; ++i) {
            this.tornadoObjects[i] = new ModelRenderer((Model)this, 0, 16);
            this.tornadoObjects[i].func_228302_a_(0.0f, 0.0f, 0.0f, 2.0f, 8.0f, 2.0f, 5.0f, 5.0f, 5.0f);
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        builder.addAll(Arrays.asList(this.tornadoObjects));
        this.modelRenderers = builder.build();
    }

    public Iterable<ModelRenderer> func_225601_a_() {
        return this.modelRenderers;
    }

    public void func_225597_a_(T entityIn, float limbSwing, float limbSwingAmount, float ageInTicks, float netHeadYaw, float headPitch) {
        float spinSpeed = 0.7853982f + ageInTicks * (float)Math.PI * 0.06f;
        for (int multiplier = 1; multiplier <= 30; ++multiplier) {
            int multipliedIDX = 256 * multiplier;
            float yHeight = -655 + multiplier * 20;
            float xzDistance = 260 - multiplier * 7;
            for (int idx = multipliedIDX - 256; idx < multipliedIDX; ++idx) {
                this.tornadoObjects[idx].field_78797_d = yHeight + MathHelper.func_76134_b((float)(((float)idx * 1.5f + ageInTicks) * 0.25f));
                this.tornadoObjects[idx].field_78800_c = MathHelper.func_76134_b((float)spinSpeed) * xzDistance;
                this.tornadoObjects[idx].field_78798_e = MathHelper.func_76126_a((float)spinSpeed) * xzDistance;
                spinSpeed += 1.0f;
            }
        }
    }
}

