/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.mixin.client;

import corgitaco.betterweather.BetterWeatherUtil;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import java.util.function.Supplier;
import net.minecraft.client.network.play.ClientPlayNetHandler;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.profiler.IProfiler;
import net.minecraft.util.RegistryKey;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DimensionType;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;

@Mixin(value={ClientWorld.class})
public abstract class MixinClientWorld {
    @Inject(method={"<init>"}, at={@At(value="RETURN")})
    private void setupClientBetterWeatherData(ClientPlayNetHandler handler, ClientWorld.ClientWorldInfo info, RegistryKey<World> key, DimensionType dimtype, int i, Supplier<IProfiler> profiler, WorldRenderer renderer, boolean b1, long b2, CallbackInfo ci) {
    }

    @Redirect(method={"getSkyColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    private float doNotDarkenSkyWithRainStrength(ClientWorld world, float delta) {
        return BetterWeatherUtil.isOverworld((RegistryKey<World>)world.func_234923_W_()) ? 0.0f : world.func_72867_j(delta);
    }

    @Redirect(method={"getCloudColor"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    private float doNotDarkenCloudsWithRainStrength(ClientWorld world, float delta) {
        return 0.0f;
    }

    @Inject(method={"getCloudColor"}, at={@At(value="RETURN")}, cancellable=true)
    private void modifyCloudColor(float partialTicks, CallbackInfoReturnable<Vector3d> cir) {
        if (BetterWeatherUtil.isOverworld((RegistryKey<World>)((ClientWorld)this).func_234923_W_())) {
            int rgbColor = WeatherData.currentWeatherEvent.modifyCloudColor(BetterWeatherUtil.transformFloatColor((Vector3d)cir.getReturnValue()), ((ClientWorld)this).func_72867_j(partialTicks)).getRGB();
            float r = (float)(rgbColor >> 16 & 0xFF) / 255.0f;
            float g = (float)(rgbColor >> 8 & 0xFF) / 255.0f;
            float b = (float)(rgbColor & 0xFF) / 255.0f;
            cir.setReturnValue((Object)new Vector3d((double)r, (double)g, (double)b));
        }
    }

    @Redirect(method={"getSunBrightness"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    private float sunBrightness(ClientWorld world, float delta) {
        float rainStrength = ((ClientWorld)this).func_72867_j(delta);
        if (BetterWeatherUtil.isOverworld((RegistryKey<World>)((ClientWorld)this).func_234923_W_())) {
            return BetterWeatherUtil.isOverworld((RegistryKey<World>)world.func_234923_W_()) ? rainStrength * WeatherData.currentWeatherEvent.dayLightDarkness() : rainStrength;
        }
        return rainStrength;
    }
}

