/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.mixin.client;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.BetterWeatherUtil;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.helper.ViewFrustumGetter;
import corgitaco.betterweather.helper.WeatherViewFrustum;
import corgitaco.betterweather.weatherevent.weatherevents.Blizzard;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.ViewFrustum;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.util.RegistryKey;
import net.minecraft.world.World;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={WorldRenderer.class})
public abstract class MixinWorldRenderer
implements ViewFrustumGetter {
    @Shadow
    public int field_72773_u;
    @Shadow
    @Final
    private Minecraft field_72777_q;
    @Shadow
    private ClientWorld field_72769_h;
    @Shadow
    private ViewFrustum field_175008_n;

    @Inject(at={@At(value="HEAD")}, method={"renderRainSnow(Lnet/minecraft/client/renderer/LightTexture;FDDD)V"}, cancellable=true)
    private void renderWeather(LightTexture lightmapIn, float partialTicks, double x, double y, double z, CallbackInfo ci) {
        if (BetterWeatherUtil.isOverworld((RegistryKey<World>)this.field_72777_q.field_71441_e.func_234923_W_()) && WeatherData.currentWeatherEvent.renderWeather(this.field_72777_q, this.field_72769_h, lightmapIn, this.field_72773_u, partialTicks, x, y, z)) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"loadRenderers()V"}, cancellable=true)
    private void handleOptifineCompat(CallbackInfo ci) {
        if (BetterWeather.usingOptifine && BetterWeatherUtil.isOverworld((RegistryKey<World>)this.field_72769_h.func_234923_W_()) && WeatherData.currentWeatherEvent.preventChunkRendererRefreshingWhenOptifineIsPresent()) {
            ci.cancel();
        }
    }

    @Inject(at={@At(value="TAIL")}, method={"loadRenderers()V"}, cancellable=true)
    private void forceWeatherEventRenderDistance(CallbackInfo ci) {
        if (!BetterWeather.usingOptifine && BetterWeatherUtil.isOverworld((RegistryKey<World>)this.field_72769_h.func_234923_W_())) {
            int renderDistance;
            ClientPlayerEntity player = this.field_72777_q.field_71439_g;
            if (this.field_72777_q.field_71441_e != null && player != null && Blizzard.doBlizzardsAffectDeserts(this.field_72777_q.field_71441_e.func_226691_t_(this.field_72777_q.field_71439_g.func_233580_cy_())) && (renderDistance = WeatherData.currentWeatherEvent.forcedRenderDistance()) != this.field_72777_q.field_71474_y.field_151451_c) {
                ((WeatherViewFrustum)this.field_175008_n).forceRenderDistance(renderDistance, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            }
        }
    }

    @Inject(at={@At(value="HEAD")}, method={"addRainParticles(Lnet/minecraft/client/renderer/ActiveRenderInfo;)V"}, cancellable=true)
    private void stopRainParticles(ActiveRenderInfo activeRenderInfoIn, CallbackInfo ci) {
        if (this.field_72777_q.field_71441_e != null && BetterWeatherUtil.isOverworld((RegistryKey<World>)this.field_72769_h.func_234923_W_()) && WeatherData.currentWeatherEvent.weatherParticlesAndSound(activeRenderInfoIn, this.field_72777_q)) {
            ci.cancel();
        }
    }

    @Redirect(method={"renderSky(Lcom/mojang/blaze3d/matrix/MatrixStack;F)V"}, at=@At(value="INVOKE", target="Lnet/minecraft/client/world/ClientWorld;getRainStrength(F)F"))
    public float sunRemoval(ClientWorld clientWorld, float delta) {
        float rainStrength = this.field_72769_h.func_72867_j(delta);
        return BetterWeatherUtil.isOverworld((RegistryKey<World>)this.field_72769_h.func_234923_W_()) ? rainStrength * WeatherData.currentWeatherEvent.skyOpacity() : rainStrength;
    }

    @Override
    public ViewFrustum getViewFrustum() {
        return this.field_175008_n;
    }
}

