/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.season;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.BetterWeatherClientUtil;
import corgitaco.betterweather.BetterWeatherUtil;
import corgitaco.betterweather.api.SeasonData;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.datastorage.BetterWeatherSeasonData;
import corgitaco.betterweather.datastorage.network.NetworkHandler;
import corgitaco.betterweather.datastorage.network.packet.SeasonPacket;
import corgitaco.betterweather.datastorage.network.packet.WeatherEventPacket;
import corgitaco.betterweather.datastorage.network.packet.util.RefreshRenderersPacket;
import corgitaco.betterweather.helper.IsWeatherForced;
import corgitaco.betterweather.season.Season;
import corgitaco.betterweather.server.BetterWeatherGameRules;
import corgitaco.betterweather.weatherevent.WeatherEventSystem;
import java.util.List;
import java.util.Random;
import java.util.concurrent.atomic.AtomicBoolean;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.ServerWorldInfo;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

public class SeasonSystem {
    private static SeasonData.SubSeasonVal privateSubSeasonVal;
    private static boolean isFadingOut;

    public static void updateSeasonTime(World world) {
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        int currentSeasonTime = BetterWeather.seasonData.getSeasonTime();
        if (world.func_82736_K().func_223586_b(BetterWeatherGameRules.DO_SEASON_CYCLE)) {
            if (currentSeasonTime > BetterWeather.SEASON_CYCLE_LENGTH) {
                BetterWeather.seasonData.setSeasonTime(0);
            } else {
                BetterWeather.seasonData.setSeasonTime(currentSeasonTime + 1);
            }
        }
        if (BetterWeather.seasonData.getSeasonCycleLength() != BetterWeather.SEASON_CYCLE_LENGTH) {
            BetterWeather.seasonData.setSeasonCycleLength(BetterWeather.SEASON_CYCLE_LENGTH);
        }
    }

    public static void updateSeasonPacket(List<ServerPlayerEntity> players, World world, boolean justJoined) {
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        int currentSeasonTime = BetterWeather.seasonData.getSeasonTime();
        SeasonData.SubSeasonVal subSeason = SeasonSystem.getSubSeasonFromTime(currentSeasonTime, BetterWeather.seasonData.getSeasonCycleLength()).getSubSeasonVal();
        if (SeasonData.currentSubSeason != subSeason || BetterWeather.seasonData.isForced() || justJoined) {
            BetterWeather.seasonData.setSubseason(subSeason.toString());
        }
        if (BetterWeather.seasonData.getSeasonTime() % 1200 == 0 || BetterWeather.seasonData.isForced() || justJoined) {
            players.forEach(player -> NetworkHandler.sendToClient(player, new SeasonPacket(BetterWeather.seasonData.getSeasonTime(), BetterWeather.SEASON_CYCLE_LENGTH)));
            if (BetterWeather.seasonData.isForced()) {
                BetterWeather.seasonData.setForced(false);
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSeason(ClientWorld world) {
        int currentSeasonTime;
        SeasonData.SubSeasonVal subSeason;
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        if (BetterWeather.seasonData == null) {
            BetterWeatherClientUtil.printDebugWarning("bw.warn.seasondata", new Object[0]);
            BetterWeather.LOGGER.error("Season data was called to early, this should never happen...\nSetting season data to prevent further issues, bugs and client desync with the server is possible!");
            BetterWeather.seasonData = BetterWeatherSeasonData.get((IWorld)world);
        }
        if (SeasonData.currentSubSeason != (subSeason = SeasonSystem.getSubSeasonFromTime(currentSeasonTime = BetterWeather.seasonData.getSeasonTime(), BetterWeather.seasonData.getSeasonCycleLength()).getSubSeasonVal())) {
            BetterWeather.seasonData.setSubseason(subSeason.toString());
            Minecraft minecraft = Minecraft.func_71410_x();
            SeasonData.currentSubSeason = subSeason;
            minecraft.field_71438_f.func_72712_a();
        }
    }

    public static Season.SubSeason getSubSeasonFromTime(int seasonTime, int seasonCycleLength) {
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        int perSeasonTime = seasonCycleLength / 4;
        SeasonData.SeasonVal seasonVal = SeasonSystem.getSeasonFromTime(seasonTime, seasonCycleLength);
        if (SeasonData.currentSeason != seasonVal) {
            BetterWeather.seasonData.setSeason(seasonVal.toString());
            SeasonData.currentSeason = seasonVal;
        }
        int perSeasonTime3rd = perSeasonTime / 3;
        int seasonOffset = perSeasonTime * seasonVal.ordinal();
        if (seasonTime < seasonOffset + perSeasonTime3rd) {
            return Season.getSeasonFromEnum(seasonVal).getStart();
        }
        if (seasonTime < seasonOffset + perSeasonTime3rd * 2) {
            return Season.getSeasonFromEnum(seasonVal).getMid();
        }
        return Season.getSeasonFromEnum(seasonVal).getEnd();
    }

    public static void tickCropForBiomeBlockOrSeason(ServerWorld world, BlockPos posIn, Block block, BlockState self, CallbackInfo ci) {
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        Season.SubSeason subSeason = Season.getSubSeasonFromEnum(SeasonData.currentSubSeason);
        if (subSeason.getBiomeToOverrideStorage().isEmpty() && subSeason.getCropToMultiplierStorage().isEmpty()) {
            if (BlockTags.field_226152_ab_.func_230235_a_((Object)block) || BlockTags.field_226153_ac_.func_230235_a_((Object)block) || BlockTags.field_200030_g.func_230235_a_((Object)block)) {
                SeasonSystem.cropTicker(world, posIn, block, subSeason, true, self, ci);
            }
        } else if (BlockTags.field_226152_ab_.func_230235_a_((Object)block) || BlockTags.field_226153_ac_.func_230235_a_((Object)block) || BlockTags.field_200030_g.func_230235_a_((Object)block)) {
            SeasonSystem.cropTicker(world, posIn, block, subSeason, false, self, ci);
        }
    }

    private static void cropTicker(ServerWorld world, BlockPos posIn, Block block, Season.SubSeason subSeason, boolean useSeasonDefault, BlockState self, CallbackInfo ci) {
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        double cropGrowthMultiplier = subSeason.getCropGrowthChanceMultiplier(BetterWeather.biomeRegistryEarlyAccess.func_177774_c((Object)world.func_226691_t_(posIn)), block, useSeasonDefault);
        if (cropGrowthMultiplier == 1.0) {
            return;
        }
        if (cropGrowthMultiplier < 1.0) {
            ci.cancel();
            if (world.func_201674_k().nextDouble() < cropGrowthMultiplier) {
                block.func_225542_b_(self, world, posIn, world.func_201674_k());
            }
        } else if (cropGrowthMultiplier > 1.0) {
            int numberOfTicks = world.func_201674_k().nextInt(world.func_201674_k().nextDouble() + (cropGrowthMultiplier - 1.0) < cropGrowthMultiplier ? (int)Math.ceil(cropGrowthMultiplier) : (int)cropGrowthMultiplier) + 1;
            for (int tick = 0; tick < numberOfTicks - 1; ++tick) {
                block.func_225542_b_(self, world, posIn, world.func_201674_k());
            }
        }
    }

    public static void rollWeatherEventChanceForSeason(Random random, ServerWorld world, boolean isRaining, boolean isThundering, ServerWorldInfo worldInfo, List<ServerPlayerEntity> players) {
        boolean privateSeasonIsNotCacheSeasonFlag;
        boolean isRainActive;
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        Season.SubSeason subSeason = Season.getSubSeasonFromEnum(SeasonData.currentSubSeason);
        boolean bl = isRainActive = isRaining || isThundering;
        if (privateSubSeasonVal == null) {
            privateSubSeasonVal = SeasonData.currentSubSeason;
        }
        boolean bl2 = privateSeasonIsNotCacheSeasonFlag = privateSubSeasonVal != SeasonData.currentSubSeason;
        if (!isRainActive) {
            if (!BetterWeather.weatherData.isModified() || privateSeasonIsNotCacheSeasonFlag) {
                worldInfo.func_76080_g(BetterWeatherUtil.transformRainOrThunderTimeToCurrentSeason(worldInfo.func_76083_p(), Season.getSubSeasonFromEnum(privateSubSeasonVal), subSeason));
                worldInfo.func_76090_f(BetterWeatherUtil.transformRainOrThunderTimeToCurrentSeason(worldInfo.func_76071_n(), Season.getSubSeasonFromEnum(privateSubSeasonVal), subSeason));
                BetterWeather.weatherData.setModified(true);
            }
        } else if (BetterWeather.weatherData.isModified()) {
            BetterWeather.weatherData.setModified(false);
        }
        if (world.field_73004_o == 0.0f) {
            if (isRainActive) {
                AtomicBoolean weatherEventWasSet = new AtomicBoolean(false);
                if (!BetterWeather.weatherData.isWeatherForced()) {
                    subSeason.getWeatherEventController().forEach((event, chance) -> {
                        if (!event.equals(WeatherEventSystem.CLEAR.toString()) && random.nextDouble() < chance) {
                            weatherEventWasSet.set(true);
                            BetterWeather.weatherData.setEvent((String)event);
                        }
                    });
                    if (!weatherEventWasSet.get()) {
                        BetterWeather.weatherData.setEvent(WeatherEventSystem.DEFAULT.toString());
                    }
                    players.forEach(player -> {
                        NetworkHandler.sendToClient(player, new WeatherEventPacket(BetterWeather.weatherData.getEventString()));
                        if (WeatherData.currentWeatherEvent.refreshPlayerRenderer()) {
                            NetworkHandler.sendToClient(player, new RefreshRenderersPacket());
                        }
                    });
                }
            }
        } else if (!isRainActive) {
            if (world.field_73004_o == 1.0f) {
                isFadingOut = true;
            } else if (world.field_73004_o <= 0.011f && isFadingOut) {
                boolean refreshRenderersPost = WeatherData.currentWeatherEvent.refreshPlayerRenderer();
                BetterWeather.weatherData.setEvent(WeatherEventSystem.CLEAR.toString());
                ((IsWeatherForced)worldInfo).setWeatherForced(false);
                BetterWeather.weatherData.setWeatherForced(((IsWeatherForced)worldInfo).isWeatherForced());
                players.forEach(player -> {
                    NetworkHandler.sendToClient(player, new WeatherEventPacket(BetterWeather.weatherData.getEventString()));
                    if (refreshRenderersPost) {
                        NetworkHandler.sendToClient(player, new RefreshRenderersPacket());
                    }
                });
                isFadingOut = false;
            }
        }
        if (privateSeasonIsNotCacheSeasonFlag) {
            privateSubSeasonVal = SeasonData.currentSubSeason;
        }
    }

    public static int getTimeInCycleForSubSeason(SeasonData.SubSeasonVal subSeasonVal, int seasonCycleLength) {
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        int perSubSeasonLength = seasonCycleLength / SeasonData.SubSeasonVal.values().length;
        return perSubSeasonLength * subSeasonVal.ordinal();
    }

    public static SeasonData.SeasonVal getSeasonFromTime(int seasonTime, int seasonCycleLength) {
        if (!BetterWeather.useSeasons) {
            throw new UnsupportedOperationException("Seasons are disabled in this instance!");
        }
        int perSeasonTime = seasonCycleLength / 4;
        if (seasonTime < perSeasonTime) {
            return SeasonData.SeasonVal.SPRING;
        }
        if (seasonTime < perSeasonTime * 2) {
            return SeasonData.SeasonVal.SUMMER;
        }
        if (seasonTime < perSeasonTime * 3) {
            return SeasonData.SeasonVal.AUTUMN;
        }
        return SeasonData.SeasonVal.WINTER;
    }

    static {
        isFadingOut = false;
    }
}

