/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.server;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.BetterWeatherEntryPoint;
import corgitaco.betterweather.api.weatherevent.BetterWeatherID;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.api.weatherevent.WeatherEvent;
import corgitaco.betterweather.datastorage.network.NetworkHandler;
import corgitaco.betterweather.datastorage.network.packet.OnCommandWeatherChangePacket;
import corgitaco.betterweather.datastorage.network.packet.WeatherEventPacket;
import corgitaco.betterweather.weatherevent.WeatherEventSystem;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.server.ServerWorld;

public class SetWeatherCommand {
    public static ArgumentBuilder<CommandSource, ?> register(CommandDispatcher<CommandSource> dispatcher) {
        List weatherTypes = BetterWeatherEntryPoint.WEATHER_EVENTS.stream().map(WeatherEvent::getID).map(BetterWeatherID::toString).collect(Collectors.toList());
        return Commands.func_197057_a((String)"setweather").then(Commands.func_197056_a((String)"weathertype", (ArgumentType)StringArgumentType.string()).suggests((ctx, sb) -> ISuggestionProvider.func_197013_a(weatherTypes.stream(), (SuggestionsBuilder)sb)).executes(cs -> SetWeatherCommand.betterWeatherSetWeatherType(((CommandSource)cs.getSource()).func_197023_e(), (CommandSource)cs.getSource(), (String)cs.getArgument("weathertype", String.class))));
    }

    public static int betterWeatherSetWeatherType(ServerWorld world, CommandSource source, String weatherType) {
        WeatherEvent weatherEvent = WeatherEventSystem.WEATHER_EVENTS.get(new BetterWeatherID(weatherType));
        WeatherEvent previousWeatherEvent = WeatherData.currentWeatherEvent;
        if (weatherEvent != null) {
            BetterWeather.weatherData.setEvent(weatherEvent.getID().toString());
            world.func_241113_a_(0, 6000, weatherEvent.getID() != WeatherEventSystem.CLEAR, false);
            source.func_197023_e().func_217369_A().forEach(player -> {
                NetworkHandler.sendToClient(player, new WeatherEventPacket(BetterWeather.weatherData.getEventString()));
                if (previousWeatherEvent != WeatherData.currentWeatherEvent) {
                    NetworkHandler.sendToClient(player, new OnCommandWeatherChangePacket(previousWeatherEvent.getID().toString()));
                }
            });
            source.func_197030_a((ITextComponent)weatherEvent.successTranslationTextComponent(), true);
        } else {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.bw.setweather.failed", new Object[]{weatherType}), true);
        }
        return 1;
    }
}

