/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weatherevent.weatherevents;

import com.mojang.blaze3d.systems.RenderSystem;
import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.BetterWeatherClientUtil;
import corgitaco.betterweather.SoundRegistry;
import corgitaco.betterweather.api.weatherevent.BetterWeatherID;
import corgitaco.betterweather.api.weatherevent.WeatherEvent;
import corgitaco.betterweather.audio.MovingWeatherSound;
import corgitaco.betterweather.config.BetterWeatherConfig;
import corgitaco.betterweather.config.BetterWeatherConfigClient;
import java.awt.Color;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.material.Material;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.SoundHandler;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.LightTexture;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.Effects;
import net.minecraft.profiler.IProfiler;
import net.minecraft.state.Property;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockDisplayReader;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.client.event.EntityViewRenderEvent;

public class Blizzard
extends WeatherEvent {
    public static final Color SKY_COLOR = new Color(155, 155, 155);
    static int idx2 = 0;
    private final float[] rainSizeX = new float[1024];
    private final float[] rainSizeZ = new float[1024];

    public Blizzard() {
        super(new BetterWeatherID("betterweather", "BLIZZARD"), 0.3);
        for (int i = 0; i < 32; ++i) {
            for (int j = 0; j < 32; ++j) {
                float f = j - 16;
                float f1 = i - 16;
                float f2 = MathHelper.func_76129_c((float)(f * f + f1 * f1));
                this.rainSizeX[i << 5 | j] = -f1 / f2;
                this.rainSizeZ[i << 5 | j] = f / f2;
            }
        }
    }

    @Override
    public Color modifySkyColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return SKY_COLOR;
    }

    @Override
    public Color modifyFogColor(Color biomeColor, Color returnColor, @Nullable Color seasonTargetColor, float rainStrength) {
        return SKY_COLOR;
    }

    @Override
    public Color modifyCloudColor(Color returnColor, float rainStrength) {
        return SKY_COLOR;
    }

    @Override
    public float dayLightDarkness() {
        return 2.0f;
    }

    public static boolean doBlizzardsAffectDeserts(Biome biome) {
        if (!((Boolean)BetterWeatherConfig.doBlizzardsOccurInDeserts.get()).booleanValue()) {
            return biome.func_201856_r() != Biome.Category.DESERT;
        }
        return true;
    }

    public static boolean doBlizzardsDestroyPlants(Material material) {
        if (!((Boolean)BetterWeatherConfig.doBlizzardsDestroyPlants.get()).booleanValue()) {
            return material != Material.field_151585_k && material != Material.field_151582_l && material != Material.field_203243_f;
        }
        return true;
    }

    public static void addSnowAndIce(Chunk chunk, World world, long worldTime) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int chunkXStart = chunkpos.func_180334_c();
        int chunkZStart = chunkpos.func_180333_d();
        IProfiler iprofiler = world.func_217381_Z();
        iprofiler.func_76320_a("blizzard");
        BlockPos blockpos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(chunkXStart, 0, chunkZStart, 15));
        Biome biome = world.func_226691_t_(blockpos);
        if (world.isAreaLoaded(blockpos, 1) && world.func_72912_H().func_76059_o() && worldTime % (long)((Integer)BetterWeatherConfig.tickSnowAndIcePlaceSpeed.get()).intValue() == 0L && biome.func_201856_r() != Biome.Category.NETHER && biome.func_201856_r() != Biome.Category.THEEND && biome.func_201856_r() != Biome.Category.NONE && Blizzard.doBlizzardsAffectDeserts(biome) && ((Boolean)BetterWeatherConfig.spawnSnowAndIce.get()).booleanValue()) {
            BlockState blockStateDown = world.func_180495_p(blockpos.func_177977_b());
            if (blockStateDown.func_177230_c() == Blocks.field_150355_j && blockStateDown.func_204520_s().func_206882_g() == 8) {
                world.func_175656_a(blockpos.func_177977_b(), Blocks.field_150432_aD.func_176223_P());
                return;
            }
            BlockState blockState = world.func_180495_p(blockpos);
            if (Blizzard.doesSnowGenerate((IWorldReader)world, blockpos) || Blizzard.doBlizzardsDestroyPlants(blockState.func_185904_a()) || blockStateDown.func_177230_c() == Blocks.field_150433_aE) {
                int snowLayerHeight;
                Block block;
                if (blockState.func_177230_c() != Blocks.field_150433_aE && blockStateDown.func_185904_a() != Material.field_151588_w && blockStateDown.func_204520_s().func_206882_g() == 0) {
                    world.func_175656_a(blockpos, Blocks.field_150433_aE.func_176223_P());
                }
                if ((block = blockState.func_177230_c()) == Blocks.field_150433_aE && blockState.func_235901_b_((Property)BlockStateProperties.field_208129_ad) && (snowLayerHeight = ((Integer)blockState.func_177229_b((Property)BlockStateProperties.field_208129_ad)).intValue()) < 7) {
                    world.func_175656_a(blockpos, (BlockState)block.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208129_ad, (Comparable)Integer.valueOf(snowLayerHeight + 1)));
                }
            }
        }
        iprofiler.func_76319_b();
    }

    public static boolean doesSnowGenerate(IWorldReader worldIn, BlockPos pos) {
        if (worldIn.func_226658_a_(LightType.BLOCK, pos) < 10) {
            BlockState blockstate = worldIn.func_180495_p(pos);
            return blockstate.isAir((IBlockReader)worldIn, pos) && Blocks.field_150433_aE.func_176223_P().func_196955_c(worldIn, pos);
        }
        return false;
    }

    @Override
    public void worldTick(ServerWorld world, int tickSpeed, long worldTime) {
    }

    @Override
    public void clientTick(ClientWorld world, int tickSpeed, long worldTime, Minecraft mc) {
        BlizzardClient.blizzardClient(world, worldTime, mc, this.forcedRenderDistance());
    }

    @Override
    public boolean renderWeather(Minecraft mc, ClientWorld world, LightTexture lightTexture, int ticks, float partialTicks, double x, double y, double z) {
        float rainStrength = world.func_72867_j(partialTicks);
        lightTexture.func_205109_c();
        int floorX = MathHelper.func_76128_c((double)x);
        int floorY = MathHelper.func_76128_c((double)y);
        int floorZ = MathHelper.func_76128_c((double)z);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferbuilder = tessellator.func_178180_c();
        RenderSystem.enableAlphaTest();
        RenderSystem.disableCull();
        RenderSystem.normal3f((float)0.0f, (float)1.0f, (float)0.0f);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.enableDepthTest();
        int graphicsQuality = 5;
        if (Minecraft.func_71375_t()) {
            graphicsQuality = 10;
        }
        RenderSystem.depthMask((boolean)Minecraft.func_238218_y_());
        int i1 = -1;
        float ticksAndPartialTicks = (float)ticks + partialTicks;
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        BlockPos.Mutable blockPos = new BlockPos.Mutable();
        for (int graphicQualityZ = floorZ - graphicsQuality; graphicQualityZ <= floorZ + graphicsQuality; ++graphicQualityZ) {
            for (int graphicQualityX = floorX - graphicsQuality; graphicQualityX <= floorX + graphicsQuality; ++graphicQualityX) {
                int rainSizeIdx = (graphicQualityZ - floorZ + 16) * 32 + graphicQualityX - floorX + 16;
                double rainSizeX = (double)this.rainSizeX[rainSizeIdx] * 0.5;
                double rainSizeZ = (double)this.rainSizeZ[rainSizeIdx] * 0.5;
                blockPos.func_181079_c(graphicQualityX, 0, graphicQualityZ);
                Biome biome = world.func_226691_t_((BlockPos)blockPos);
                int topPosY = mc.field_71441_e.func_201676_a(Heightmap.Type.MOTION_BLOCKING, blockPos.func_177958_n(), blockPos.func_177952_p());
                int floorYMinusGraphicsQuality = floorY - graphicsQuality;
                int floorYPlusGraphicsQuality = floorY + graphicsQuality;
                if (floorYMinusGraphicsQuality < topPosY) {
                    floorYMinusGraphicsQuality = topPosY;
                }
                if (floorYPlusGraphicsQuality < topPosY) {
                    floorYPlusGraphicsQuality = topPosY;
                }
                int posY2 = topPosY;
                if (topPosY < floorY) {
                    posY2 = floorY;
                }
                if (floorYMinusGraphicsQuality == floorYPlusGraphicsQuality) continue;
                Random random = new Random(graphicQualityX * graphicQualityX * 3121 + graphicQualityX * 45238971 ^ graphicQualityZ * graphicQualityZ * 418711 + graphicQualityZ * 13761);
                blockPos.func_181079_c(graphicQualityX, floorYMinusGraphicsQuality, graphicQualityZ);
                if (i1 != 1) {
                    if (i1 >= 0) {
                        tessellator.func_78381_a();
                    }
                    i1 = 1;
                    mc.func_110434_K().func_110577_a(WorldRenderer.field_228414_i_);
                    bufferbuilder.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                }
                float f7 = (float)(random.nextDouble() + (double)(ticksAndPartialTicks * (float)random.nextGaussian()) * 0.03);
                float fallSpeed = (float)(random.nextDouble() + (double)(ticksAndPartialTicks * (float)random.nextGaussian()) * 0.03);
                double d3 = (double)((float)graphicQualityX + 0.5f) - x;
                double d5 = (double)((float)graphicQualityZ + 0.5f) - z;
                float f9 = MathHelper.func_76133_a((double)(d3 * d3 + d5 * d5)) / (float)graphicsQuality;
                float ticksAndPartialTicks0 = ((1.0f - f9 * f9) * 0.3f + 0.5f) * rainStrength;
                blockPos.func_181079_c(graphicQualityX, posY2, graphicQualityZ);
                int k3 = WorldRenderer.func_228421_a_((IBlockDisplayReader)world, (BlockPos)blockPos);
                int l3 = k3 >> 16 & 0xFFFF;
                int i4 = (k3 & 0xFFFF) * 3;
                int j4 = (l3 * 3 + 240) / 4;
                int k4 = (i4 * 3 + 240) / 4;
                if (!Blizzard.doBlizzardsAffectDeserts(biome)) continue;
                bufferbuilder.func_225582_a_((double)graphicQualityX - x - rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYPlusGraphicsQuality - y, (double)graphicQualityZ - z - rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(0.0f + f7, (float)floorYMinusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
                bufferbuilder.func_225582_a_((double)graphicQualityX - x + rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYPlusGraphicsQuality - y, (double)graphicQualityZ - z + rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(1.0f + f7, (float)floorYMinusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
                bufferbuilder.func_225582_a_((double)graphicQualityX - x + rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYMinusGraphicsQuality - y, (double)graphicQualityZ - z + rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(1.0f + f7, (float)floorYPlusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
                bufferbuilder.func_225582_a_((double)graphicQualityX - x - rainSizeX + 0.5 + random.nextGaussian() * 2.0, (double)floorYMinusGraphicsQuality - y, (double)graphicQualityZ - z - rainSizeZ + 0.5 + random.nextGaussian()).func_225583_a_(0.0f + f7, (float)floorYPlusGraphicsQuality * 0.25f - Math.abs(fallSpeed)).func_227885_a_(1.0f, 1.0f, 1.0f, ticksAndPartialTicks0).func_225587_b_(k4, j4).func_181675_d();
            }
        }
        if (i1 >= 0) {
            tessellator.func_78381_a();
        }
        RenderSystem.enableCull();
        RenderSystem.disableBlend();
        RenderSystem.defaultAlphaFunc();
        RenderSystem.disableAlphaTest();
        lightTexture.func_205108_b();
        return true;
    }

    @Override
    public void onCommandWeatherChange() {
        BlizzardClient.stopPlaying();
    }

    @Override
    public void handleFogDensity(EntityViewRenderEvent.FogDensity event, Minecraft mc) {
        if (((Boolean)BetterWeatherConfigClient.blizzardFog.get()).booleanValue() && mc.field_71441_e != null && mc.field_71439_g != null) {
            BlockPos playerPos = new BlockPos(mc.field_71439_g.func_213303_ch());
            if (Blizzard.doBlizzardsAffectDeserts(mc.field_71441_e.func_226691_t_(playerPos))) {
                float partialTicks = mc.func_147113_T() ? mc.field_193996_ah : mc.field_71428_T.field_194147_b;
                float fade = mc.field_71441_e.func_72867_j(partialTicks);
                event.setDensity(fade * 0.1f);
                event.setCanceled(true);
                if (idx2 != 0) {
                    idx2 = 0;
                }
            } else if (idx2 == 0) {
                event.setCanceled(false);
                ++idx2;
            }
        }
    }

    @Override
    public void livingEntityUpdate(Entity entity) {
        if (entity instanceof LivingEntity && ((Boolean)BetterWeatherConfig.doBlizzardsSlowPlayers.get()).booleanValue() && entity.func_233580_cy_().func_177956_o() < entity.field_70170_p.func_201676_a(Heightmap.Type.MOTION_BLOCKING, entity.func_233580_cy_().func_177958_n(), entity.func_233580_cy_().func_177952_p())) {
            ((LivingEntity)entity).func_195064_c(new EffectInstance(Effects.field_76421_d, 5, ((Integer)BetterWeatherConfig.blizzardSlownessAmplifier.get()).intValue(), true, false));
        }
    }

    @Override
    public boolean disableSkyColor() {
        return true;
    }

    @Override
    public float modifyTemperature(float biomeTemp, float modifiedBiomeTemp, double seasonModifier) {
        return Math.max(-0.5f, modifiedBiomeTemp - 0.5f);
    }

    @Override
    public int forcedRenderDistance() {
        return (Integer)BetterWeatherConfigClient.forcedRenderDistanceDuringBlizzards.get();
    }

    @Override
    public void tickLiveChunks(Chunk chunk, ServerWorld world) {
        Blizzard.addSnowAndIce(chunk, (World)world, world.func_72912_H().func_82573_f());
    }

    @Override
    public boolean refreshPlayerRenderer() {
        return BetterWeather.usingOptifine;
    }

    @Override
    public boolean preventChunkRendererRefreshingWhenOptifineIsPresent() {
        return true;
    }

    public static class BlizzardClient {
        public static MovingWeatherSound BLIZZARD_SOUND = new MovingWeatherSound(SoundRegistry.BLIZZARD_LOOP1, ((BlizzardLoopSoundTrack)((Object)BetterWeatherConfigClient.blizzardLoopEnumValue.get())).getReplayRate(), SoundCategory.WEATHER, Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216780_d(), ((Double)BetterWeatherConfigClient.blizzardVolume.get()).floatValue(), ((Double)BetterWeatherConfigClient.blizzardPitch.get()).floatValue());

        public static void blizzardClient(ClientWorld world, long worldTime, Minecraft mc, int forcedRenderDistance) {
            SoundHandler soundHandler = mc.func_147118_V();
            if (!soundHandler.func_215294_c((ISound)BLIZZARD_SOUND) && Blizzard.doBlizzardsAffectDeserts(mc.field_71441_e.func_226691_t_(mc.field_71460_t.func_215316_n().func_216780_d()))) {
                MovingWeatherSound blizzardSound = new MovingWeatherSound(((BlizzardLoopSoundTrack)((Object)BetterWeatherConfigClient.blizzardLoopEnumValue.get())).getSoundEvent(), ((BlizzardLoopSoundTrack)((Object)BetterWeatherConfigClient.blizzardLoopEnumValue.get())).getReplayRate(), SoundCategory.WEATHER, Minecraft.func_71410_x().field_71460_t.func_215316_n().func_216780_d(), ((Double)BetterWeatherConfigClient.blizzardVolume.get()).floatValue(), ((Double)BetterWeatherConfigClient.blizzardPitch.get()).floatValue());
                soundHandler.func_147682_a((ISound)blizzardSound);
                BLIZZARD_SOUND = blizzardSound;
            }
            if (!BLIZZARD_SOUND.func_147667_k() && !Blizzard.doBlizzardsAffectDeserts(mc.field_71441_e.func_226691_t_(mc.field_71460_t.func_215316_n().func_216780_d()))) {
                BLIZZARD_SOUND.func_239509_o_();
            }
            if (BetterWeather.usingOptifine) {
                mc.field_71438_f.field_72739_F = forcedRenderDistance;
            } else if (worldTime % 20L == 0L) {
                if (Blizzard.doBlizzardsAffectDeserts(world.func_226691_t_(mc.field_71439_g.func_233580_cy_()))) {
                    BetterWeatherClientUtil.refreshViewFrustum(mc, forcedRenderDistance);
                } else {
                    BetterWeatherClientUtil.refreshViewFrustum(mc, mc.field_71474_y.field_151451_c);
                }
            }
        }

        public static void stopPlaying() {
            BLIZZARD_SOUND.func_239509_o_();
        }
    }

    public static enum BlizzardLoopSoundTrack {
        LOOP1(SoundRegistry.BLIZZARD_LOOP1, 2400),
        LOOP2(SoundRegistry.BLIZZARD_LOOP2, 2400),
        LOOP3(SoundRegistry.BLIZZARD_LOOP3, 2400),
        LOOP4(SoundRegistry.BLIZZARD_LOOP4, 2400),
        LOOP5(SoundRegistry.BLIZZARD_LOOP5, 2400),
        LOOP6(SoundRegistry.BLIZZARD_LOOP6, 2400),
        LOOP7(SoundRegistry.BLIZZARD_LOOP7, 1200);

        private final SoundEvent soundEvent;
        private final int replayRate;

        private BlizzardLoopSoundTrack(SoundEvent soundEvent, int tickReplayRate) {
            this.soundEvent = soundEvent;
            this.replayRate = tickReplayRate;
        }

        public SoundEvent getSoundEvent() {
            return this.soundEvent;
        }

        public int getReplayRate() {
            return this.replayRate;
        }
    }
}

