/*
 * Decompiled with CFR 0.152.
 */
package corgitaco.betterweather.weatherevent.weatherevents;

import corgitaco.betterweather.BetterWeather;
import corgitaco.betterweather.api.weatherevent.WeatherData;
import corgitaco.betterweather.season.SeasonSystem;
import corgitaco.betterweather.weatherevent.WeatherEventSystem;
import net.minecraft.block.Blocks;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.gen.Heightmap;
import net.minecraft.world.server.ServerWorld;
import net.minecraft.world.storage.IServerWorldInfo;
import net.minecraft.world.storage.ServerWorldInfo;

public class WeatherEventUtil {
    public static void doVanillaWeather(IServerWorldInfo worldInfo, ServerWorld world) {
        int clearWeatherTime = worldInfo.func_230395_g_();
        int thunderTime = worldInfo.func_76071_n();
        int rainTime = worldInfo.func_76083_p();
        boolean isThundering = world.func_72912_H().func_76061_m();
        boolean isRaining = world.func_72912_H().func_76059_o();
        if (clearWeatherTime > 0) {
            --clearWeatherTime;
            thunderTime = isThundering ? 0 : 1;
            rainTime = isRaining ? 0 : 1;
            isThundering = false;
            isRaining = false;
        } else {
            if (thunderTime > 0) {
                if (--thunderTime == 0) {
                    isThundering = !isThundering;
                }
            } else {
                thunderTime = isThundering ? world.field_73012_v.nextInt(12000) + 3600 : world.field_73012_v.nextInt(168000) + 12000;
            }
            if (rainTime > 0) {
                if (--rainTime == 0) {
                    isRaining = !isRaining;
                }
            } else {
                rainTime = isRaining ? world.field_73012_v.nextInt(12000) + 12000 : world.field_73012_v.nextInt(168000) + 12000;
            }
        }
        worldInfo.func_76090_f(thunderTime);
        worldInfo.func_76080_g(rainTime);
        worldInfo.func_230391_a_(clearWeatherTime);
        worldInfo.func_76069_a(isThundering);
        worldInfo.func_76084_b(isRaining);
    }

    public static void doWeatherAndRollWeatherEventChance(IServerWorldInfo worldInfo, ServerWorld world) {
        WeatherEventUtil.doWeather(worldInfo, world);
        if (BetterWeather.useSeasons) {
            SeasonSystem.rollWeatherEventChanceForSeason(world.field_73012_v, world, worldInfo.func_76059_o(), worldInfo.func_76061_m(), (ServerWorldInfo)worldInfo, world.func_217369_A());
        } else {
            WeatherEventSystem.rollWeatherEventChance(world.field_73012_v, world, worldInfo.func_76059_o(), (ServerWorldInfo)worldInfo, world.func_217369_A());
        }
    }

    public static void doWeather(IServerWorldInfo worldInfo, ServerWorld world) {
        int clearWeatherTime = worldInfo.func_230395_g_();
        int rainTime = worldInfo.func_76083_p();
        boolean isRaining = world.func_72912_H().func_76059_o();
        if (clearWeatherTime > 0) {
            --clearWeatherTime;
            rainTime = isRaining ? 0 : 1;
            isRaining = false;
        } else if (rainTime > 0) {
            if (--rainTime == 0) {
                isRaining = !isRaining;
            }
        } else {
            rainTime = isRaining ? world.field_73012_v.nextInt(12000) + 12000 : world.field_73012_v.nextInt(168000) + 12000;
        }
        worldInfo.func_76080_g(rainTime);
        worldInfo.func_230391_a_(clearWeatherTime);
        worldInfo.func_76084_b(isRaining);
    }

    public static void vanillaIceAndSnowChunkTicks(Chunk chunk, ServerWorld world) {
        ChunkPos chunkpos = chunk.func_76632_l();
        int xStart = chunkpos.func_180334_c();
        int zStart = chunkpos.func_180333_d();
        boolean isRaining = world.func_72896_J();
        BlockPos randomPos = world.func_205770_a(Heightmap.Type.MOTION_BLOCKING, world.func_217383_a(xStart, 0, zStart, 15));
        BlockPos randomPosDown = randomPos.func_177977_b();
        Biome biome = world.func_226691_t_(randomPos);
        if (world.isAreaLoaded(randomPos, 1) && biome.func_201848_a((IWorldReader)world, randomPosDown)) {
            world.func_175656_a(randomPosDown, Blocks.field_150432_aD.func_176223_P());
        }
        if (isRaining && biome.func_201850_b((IWorldReader)world, randomPos) && WeatherData.currentWeatherEvent.spawnSnowInFreezingClimates()) {
            world.func_175656_a(randomPos, Blocks.field_150433_aE.func_176223_P());
        }
        if (isRaining && biome.func_201851_b() == Biome.RainType.RAIN && WeatherData.currentWeatherEvent.fillBlocksWithWater()) {
            world.func_180495_p(randomPosDown).func_177230_c().func_176224_k((World)world, randomPosDown);
        }
    }
}

