/*
 * Decompiled with CFR 0.152.
 */
package bones.entity.skeleton_pig;

import bones.entity.UndeadAnimalEntity;
import bones.setup.Entities;
import bones.setup.Items;
import bones.setup.SoundEvents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.ZombiePigmanEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;

@ParametersAreNonnullByDefault
public class SkeletonPigEntity
extends UndeadAnimalEntity {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(SkeletonPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(SkeletonPigEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;

    public SkeletonPigEntity(EntityType<? extends SkeletonPigEntity> entityType, World world) {
        super(entityType, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.PORKCHOP_ON_A_STICK}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{net.minecraft.item.Items.field_151147_al})));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(12.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        return player.func_184614_ca().func_77973_b() == Items.PORKCHOP_ON_A_STICK || player.func_184592_cb().func_77973_b() == Items.PORKCHOP_ON_A_STICK;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BOOST_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.boosting = true;
            this.boostTime = 0;
            this.totalBoostTime = (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Saddle", this.getSaddled());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        ZombiePigmanEntity pigman;
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        if (world.func_201674_k().nextInt(50) == 0 && world.func_201675_m().func_177495_o() && (pigman = (ZombiePigmanEntity)EntityType.field_200785_Y.func_200721_a(this.field_70170_p)) != null) {
            this.setSaddled(true);
            pigman.func_70012_b(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70177_z, 0.0f);
            pigman.func_213386_a(world, difficulty, reason, null, null);
            world.func_217376_c((Entity)pigman);
            pigman.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.PORKCHOP_ON_A_STICK));
            pigman.func_184220_m((Entity)this);
        }
        return spawnData;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.SKELETON_PIG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.SKELETON_PIG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.SKELETON_PIG_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(net.minecraft.util.SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        if (!super.func_184645_a(player, hand)) {
            ItemStack itemstack = player.func_184586_b(hand);
            if (itemstack.func_77973_b() == net.minecraft.item.Items.field_151057_cb) {
                itemstack.func_111282_a(player, (LivingEntity)this, hand);
                return true;
            }
            if (this.getSaddled() && !this.func_184207_aI()) {
                if (!this.field_70170_p.field_72995_K) {
                    player.func_184220_m((Entity)this);
                }
                return true;
            }
            if (itemstack.func_77973_b() == net.minecraft.item.Items.field_151141_av) {
                itemstack.func_111282_a(player, (LivingEntity)this, hand);
                if (this.func_70089_S() && !this.getSaddled() && !this.func_70631_g_()) {
                    this.setSaddled(true);
                    this.field_70170_p.func_184148_a(player, this.field_70165_t, this.field_70163_u, this.field_70161_v, net.minecraft.util.SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                    itemstack.func_190918_g(1);
                }
                return true;
            }
            return false;
        }
        return true;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.getSaddled()) {
            this.func_199703_a((IItemProvider)net.minecraft.item.Items.field_151141_av);
        }
    }

    public boolean getSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        if (saddled) {
            this.field_70180_af.func_187227_b(SADDLED, (Object)true);
        } else {
            this.field_70180_af.func_187227_b(SADDLED, (Object)false);
        }
    }

    public void func_213352_e(Vec3d p_213352_1_) {
        if (this.func_70089_S()) {
            Entity entity;
            Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (entity != null && this.func_184207_aI() && this.func_82171_bF()) {
                this.field_70126_B = this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.boosting && this.boostTime++ > this.totalBoostTime) {
                    this.boosting = false;
                }
                if (this.func_184186_bw()) {
                    float f = (float)this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 0.5f;
                    if (this.boosting) {
                        f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                    }
                    this.func_70659_e(f);
                    super.func_213352_e(new Vec3d(0.0, 0.0, 1.0));
                } else {
                    this.func_213317_d(Vec3d.field_186680_a);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double motionX = this.field_70165_t - this.field_70169_q;
                double motionZ = this.field_70161_v - this.field_70166_s;
                float f1 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ)) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_213352_e(p_213352_1_);
            }
        }
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        this.func_184212_Q().func_187227_b(BOOST_TIME, (Object)this.totalBoostTime);
        return true;
    }

    public SkeletonPigEntity createChild(AgeableEntity ageable) {
        return (SkeletonPigEntity)Entities.SKELETON_PIG.func_200721_a(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == net.minecraft.item.Items.field_151147_al;
    }
}

