/*
 * Decompiled with CFR 0.152.
 */
package bones.setup;

import bones.entity.skeleton_chicken.SkeletonChickenEntity;
import bones.entity.skeleton_chicken.SkeletonChickenRenderer;
import bones.entity.skeleton_cow.SkeletonCowEntity;
import bones.entity.skeleton_cow.SkeletonCowRenderer;
import bones.entity.skeleton_pig.SkeletonPigEntity;
import bones.entity.skeleton_pig.SkeletonPigRenderer;
import bones.entity.skeleton_sheep.SkeletonSheepEntity;
import bones.entity.skeleton_sheep.SkeletonSheepRenderer;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorld;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class Entities {
    public static final EntityType<SkeletonSheepEntity> SKELETON_SHEEP = EntityType.Builder.func_220322_a(SkeletonSheepEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.3f).func_220320_c().func_206830_a("skeleton_sheep");
    public static final EntityType<SkeletonPigEntity> SKELETON_PIG = EntityType.Builder.func_220322_a(SkeletonPigEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 0.9f).func_220320_c().func_206830_a("skeleton_pig");
    public static final EntityType<SkeletonCowEntity> SKELETON_COW = EntityType.Builder.func_220322_a(SkeletonCowEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f).func_220320_c().func_206830_a("skeleton_cow");
    public static final EntityType<SkeletonChickenEntity> SKELETON_CHICKEN = EntityType.Builder.func_220322_a(SkeletonChickenEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f).func_220320_c().func_206830_a("skeleton_chicken");

    public static void register(RegistryEvent.Register<EntityType<?>> event) {
        SKELETON_SHEEP.setRegistryName(new ResourceLocation("bones", "skeleton_sheep"));
        SKELETON_PIG.setRegistryName(new ResourceLocation("bones", "skeleton_pig"));
        SKELETON_COW.setRegistryName(new ResourceLocation("bones", "skeleton_cow"));
        SKELETON_CHICKEN.setRegistryName(new ResourceLocation("bones", "skeleton_chicken"));
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{SKELETON_SHEEP, SKELETON_PIG, SKELETON_COW, SKELETON_CHICKEN});
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_SHEEP, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, Entities::mobCondition);
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_PIG, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, Entities::mobCondition);
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_COW, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, Entities::mobCondition);
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_CHICKEN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, Entities::mobCondition);
    }

    private static boolean mobCondition(EntityType<? extends MobEntity> entityType, IWorld world, SpawnReason spawnReason, BlockPos pos, Random random) {
        BlockPos blockpos = pos.func_177977_b();
        return spawnReason == SpawnReason.SPAWNER || world.func_180495_p(blockpos).func_215688_a((IBlockReader)world, blockpos, entityType);
    }

    public static void addSpawns() {
        Set netherBiomes = BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.NETHER);
        HashSet spookyBiomes = new HashSet(BiomeDictionary.getBiomes((BiomeDictionary.Type)BiomeDictionary.Type.SPOOKY));
        spookyBiomes.removeAll(netherBiomes);
        for (Biome biome : netherBiomes) {
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_SHEEP, 24, 3, 7));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_PIG, 24, 2, 5));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_COW, 24, 2, 8));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_CHICKEN, 24, 2, 5));
        }
        for (Biome biome : spookyBiomes) {
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_SHEEP, 1, 1, 3));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_PIG, 1, 1, 3));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_COW, 1, 1, 3));
            biome.func_76747_a(EntityClassification.CREATURE).add(new Biome.SpawnListEntry(SKELETON_CHICKEN, 1, 1, 3));
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void registerRenderingHandlers() {
        RenderingRegistry.registerEntityRenderingHandler(SkeletonSheepEntity.class, SkeletonSheepRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SkeletonPigEntity.class, SkeletonPigRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SkeletonCowEntity.class, SkeletonCowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SkeletonChickenEntity.class, SkeletonChickenRenderer::new);
    }
}

