/*
 * Decompiled with CFR 0.152.
 */
package bones.entity.skeleton_sheep;

import bones.entity.UndeadAnimalEntity;
import bones.setup.Entities;
import bones.setup.SoundEvents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mcp.MethodsReturnNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;

@ParametersAreNonnullByDefault
@MethodsReturnNonnullByDefault
public class SkeletonSheepEntity
extends UndeadAnimalEntity
implements IShearable {
    private static final DataParameter<Boolean> IS_SHEARED = EntityDataManager.func_187226_a(SkeletonSheepEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final ResourceLocation LOOT_TABLE_UNSHEARED = new ResourceLocation("bones", "entities/skeleton_sheep_unsheared");

    public SkeletonSheepEntity(EntityType<? extends SkeletonSheepEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh, Items.field_179561_bm}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.23);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_SHEARED, (Object)true);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(IS_SHEARED, (Object)(!compound.func_74767_n("IsShearable") ? 1 : 0));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsShearable", !this.isSheared());
    }

    protected ResourceLocation func_184647_J() {
        if (!this.isSheared()) {
            return LOOT_TABLE_UNSHEARED;
        }
        return super.func_184647_J();
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld worldIn, DifficultyInstance difficultyIn, SpawnReason reason, @Nullable ILivingEntityData spawnDataIn, @Nullable CompoundNBT dataTag) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.field_70180_af.func_187227_b(IS_SHEARED, (Object)false);
        }
        return super.func_213386_a(worldIn, difficultyIn, reason, spawnDataIn, dataTag);
    }

    protected float func_213348_b(Pose poseIn, EntitySize sizeIn) {
        return 0.95f * sizeIn.field_220316_b;
    }

    @Nullable
    public AgeableEntity func_90011_a(AgeableEntity ageable) {
        return (AgeableEntity)Entities.SKELETON_SHEEP.func_200721_a(ageable.field_70170_p);
    }

    public List<ItemStack> onSheared(ItemStack item, IWorld world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!this.field_70170_p.field_72995_K) {
            this.field_70180_af.func_187227_b(IS_SHEARED, (Object)true);
            int i = 1 + this.field_70146_Z.nextInt(3);
            for (int j = 0; j < i; ++j) {
                result.add(new ItemStack((IItemProvider)Items.field_179561_bm));
            }
        }
        this.func_184185_a(SoundEvents.SKELETON_SHEEP_SHEAR, 1.0f, 1.0f);
        return result;
    }

    public boolean isShearable(@Nonnull ItemStack item, IWorldReader world, BlockPos pos) {
        return !this.isSheared();
    }

    public boolean isSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SHEARED);
    }

    public boolean func_184645_a(PlayerEntity player, Hand hand) {
        ItemStack stack;
        if (!super.func_184645_a(player, hand) && (stack = player.func_184586_b(hand)).func_77973_b() == Items.field_151078_bh && this.isSheared()) {
            this.func_175505_a(player, stack);
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.field_70180_af.func_187227_b(IS_SHEARED, (Object)false);
                }
            } else {
                for (int i = 4 + this.field_70146_Z.nextInt(4); i > 0; --i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
            }
            return true;
        }
        return false;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.SKELETON_SHEEP_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.SKELETON_SHEEP_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.SKELETON_SHEEP_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(net.minecraft.util.SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_179561_bm;
    }
}

