/*
 * Decompiled with CFR 0.152.
 */
package bones.entity.skeleton_pig;

import bones.entity.UndeadAnimalEntity;
import bones.setup.Entities;
import bones.setup.Items;
import bones.setup.SoundEvents;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.BoostHelper;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.IEquipable;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.IRideable;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IWorld;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@ParametersAreNonnullByDefault
public class SkeletonPigEntity
extends UndeadAnimalEntity
implements IRideable,
IEquipable {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(SkeletonPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(SkeletonPigEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private final BoostHelper boostHelper;

    public SkeletonPigEntity(EntityType<? extends SkeletonPigEntity> entityType, World world) {
        super(entityType, world);
        this.boostHelper = new BoostHelper(this.field_70180_af, BOOST_TIME, SADDLED);
    }

    public static AttributeModifierMap.MutableAttribute getAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.PORKCHOP_ON_A_STICK}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{net.minecraft.item.Items.field_151147_al})));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    @Nullable
    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        return player.func_184614_ca().func_77973_b() == Items.PORKCHOP_ON_A_STICK || player.func_184592_cb().func_77973_b() == Items.PORKCHOP_ON_A_STICK;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BOOST_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.boostHelper.func_233616_a_();
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        this.boostHelper.func_233618_a_(compound);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.boostHelper.func_233621_b_(compound);
    }

    @Nullable
    public ILivingEntityData func_213386_a(IWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        PiglinEntity piglin;
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        if (world.func_201674_k().nextInt(50) == 0 && (piglin = (PiglinEntity)EntityType.field_233591_ai_.func_200721_a(this.field_70170_p)) != null) {
            this.boostHelper.func_233619_a_(true);
            piglin.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            piglin.func_213386_a(world, difficulty, reason, null, null);
            world.func_217376_c((Entity)piglin);
            piglin.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)Items.PORKCHOP_ON_A_STICK));
            piglin.func_184220_m((Entity)this);
        }
        return spawnData;
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.SKELETON_PIG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return SoundEvents.SKELETON_PIG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.SKELETON_PIG_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(net.minecraft.util.SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public ActionResultType func_230254_b_(PlayerEntity p_230254_1_, Hand p_230254_2_) {
        boolean flag = this.func_70877_b(p_230254_1_.func_184586_b(p_230254_2_));
        if (!flag && this.func_110257_ck() && !this.func_184207_aI()) {
            if (!this.field_70170_p.field_72995_K) {
                p_230254_1_.func_184220_m((Entity)this);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.field_72995_K);
        }
        ActionResultType actionresulttype = super.func_230254_b_(p_230254_1_, p_230254_2_);
        if (!actionresulttype.func_226246_a_()) {
            ItemStack itemstack = p_230254_1_.func_184586_b(p_230254_2_);
            return itemstack.func_77973_b() == net.minecraft.item.Items.field_151141_av ? itemstack.func_111282_a_(p_230254_1_, (LivingEntity)this, p_230254_2_) : ActionResultType.PASS;
        }
        return actionresulttype;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.func_110257_ck()) {
            this.func_199703_a((IItemProvider)net.minecraft.item.Items.field_151141_av);
        }
    }

    public boolean func_230264_L__() {
        return this.func_70089_S() && !this.func_70631_g_();
    }

    public boolean func_110257_ck() {
        return this.boostHelper.func_233620_b_();
    }

    public void func_230266_a_(@Nullable SoundCategory p_230266_1_) {
        this.boostHelper.func_233619_a_(true);
        if (p_230266_1_ != null) {
            this.field_70170_p.func_217384_a(null, (Entity)this, net.minecraft.util.SoundEvents.field_187706_dO, p_230266_1_, 0.5f, 1.0f);
        }
    }

    public float func_230265_N__() {
        return (float)this.func_233637_b_(Attributes.field_233821_d_) * 0.225f;
    }

    public void func_230267_a__(Vector3d p_230267_1_) {
        super.func_213352_e(p_230267_1_);
    }

    public boolean func_184762_da() {
        return this.boostHelper.func_233617_a_(this.func_70681_au());
    }

    @OnlyIn(value=Dist.CLIENT)
    public Vector3d func_241205_ce_() {
        return new Vector3d(0.0, 0.6 * (double)this.func_70047_e(), (double)this.func_213311_cf() * 0.4);
    }

    public void func_213352_e(Vector3d vector3d) {
        this.func_233622_a_((MobEntity)this, this.boostHelper, vector3d);
    }

    public SkeletonPigEntity createChild(AgeableEntity entity) {
        return (SkeletonPigEntity)Entities.SKELETON_PIG.func_200721_a(this.field_70170_p);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == net.minecraft.item.Items.field_151147_al;
    }
}

