/*
 * Decompiled with CFR 0.152.
 */
package bones.common.entity;

import bones.common.entity.UndeadAnimalEntity;
import bones.common.init.ModEntities;
import bones.common.init.ModItems;
import bones.common.init.ModSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.monster.piglin.PiglinEntity;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;

public class SkeletonPigEntity
extends UndeadAnimalEntity {
    private static final DataParameter<Boolean> SADDLED = EntityDataManager.func_187226_a(SkeletonPigEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final DataParameter<Integer> BOOST_TIME = EntityDataManager.func_187226_a(SkeletonPigEntity.class, (IDataSerializer)DataSerializers.field_187192_b);
    private boolean boosting;
    private int boostTime;
    private int totalBoostTime;

    public SkeletonPigEntity(EntityType<? extends SkeletonPigEntity> type, World world) {
        super(type, world);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(3, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{ModItems.PORKCHOP_ON_A_STICK}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new TemptGoal((CreatureEntity)this, 1.2, false, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151147_al})));
        this.field_70714_bg.func_75776_a(5, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 12.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    public Entity func_184179_bs() {
        return this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
    }

    public boolean func_82171_bF() {
        Entity entity = this.func_184179_bs();
        if (!(entity instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)entity;
        return player.func_184614_ca().func_77973_b() == ModItems.PORKCHOP_ON_A_STICK || player.func_184592_cb().func_77973_b() == ModItems.PORKCHOP_ON_A_STICK;
    }

    public void func_184206_a(DataParameter<?> key) {
        if (BOOST_TIME.equals(key) && this.field_70170_p.field_72995_K) {
            this.boosting = true;
            this.boostTime = 0;
            this.totalBoostTime = (Integer)this.field_70180_af.func_187225_a(BOOST_TIME);
        }
        super.func_184206_a(key);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SADDLED, (Object)false);
        this.field_70180_af.func_187214_a(BOOST_TIME, (Object)0);
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("Saddle", this.isSaddled());
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.setSaddled(compound.func_74767_n("Saddle"));
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        PiglinEntity piglin;
        spawnData = super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
        if (world.func_201674_k().nextInt(50) == 0 && reason == SpawnReason.NATURAL && (piglin = (PiglinEntity)EntityType.field_233591_ai_.func_200721_a(this.field_70170_p)) != null) {
            this.setSaddled(true);
            piglin.func_70012_b(this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), this.field_70177_z, 0.0f);
            piglin.func_213386_a(world, difficulty, reason, null, null);
            world.func_217376_c((Entity)piglin);
            piglin.func_184201_a(EquipmentSlotType.OFFHAND, new ItemStack((IItemProvider)ModItems.PORKCHOP_ON_A_STICK));
            piglin.func_184220_m((Entity)this);
        }
        return spawnData;
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.SKELETON_PIG_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSource) {
        return ModSoundEvents.SKELETON_PIG_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.SKELETON_PIG_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState block) {
        this.func_184185_a(SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack = player.func_184586_b(hand);
        if (!this.func_70877_b(stack) && !player.func_226563_dT_() && this.isSaddled() && !this.func_184207_aI()) {
            if (!this.field_70170_p.func_201670_d()) {
                player.func_184220_m((Entity)this);
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
        }
        ActionResultType actionResultType = super.func_230254_b_(player, hand);
        if (!actionResultType.func_226246_a_()) {
            if (!stack.func_190926_b() && stack.func_77973_b() == Items.field_151141_av && !this.isSaddled() && this.func_70089_S() && !this.func_70631_g_()) {
                this.setSaddled(true);
                this.field_70170_p.func_184148_a(player, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), SoundEvents.field_187706_dO, SoundCategory.NEUTRAL, 0.5f, 1.0f);
                this.func_175505_a(player, stack);
                return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
            }
            return ActionResultType.PASS;
        }
        return actionResultType;
    }

    protected void func_213337_cE() {
        super.func_213337_cE();
        if (this.isSaddled()) {
            this.func_199703_a((IItemProvider)Items.field_151141_av);
        }
    }

    public boolean isSaddled() {
        return (Boolean)this.field_70180_af.func_187225_a(SADDLED);
    }

    public void setSaddled(boolean saddled) {
        this.field_70180_af.func_187227_b(SADDLED, (Object)saddled);
    }

    public void func_213352_e(Vector3d motion) {
        if (this.func_70089_S()) {
            Entity entity;
            Entity entity2 = entity = this.func_184188_bt().isEmpty() ? null : (Entity)this.func_184188_bt().get(0);
            if (entity != null && this.func_184207_aI() && this.func_82171_bF()) {
                this.field_70126_B = this.field_70177_z = entity.field_70177_z;
                this.field_70125_A = entity.field_70125_A * 0.5f;
                this.func_70101_b(this.field_70177_z, this.field_70125_A);
                this.field_70761_aq = this.field_70177_z;
                this.field_70759_as = this.field_70177_z;
                this.field_70138_W = 1.0f;
                this.field_70747_aH = this.func_70689_ay() * 0.1f;
                if (this.boosting && this.boostTime++ > this.totalBoostTime) {
                    this.boosting = false;
                }
                if (this.func_184186_bw()) {
                    float f = (float)this.func_110148_a(Attributes.field_233821_d_).func_111126_e() * 0.5f;
                    if (this.boosting) {
                        f += f * 1.15f * MathHelper.func_76126_a((float)((float)this.boostTime / (float)this.totalBoostTime * (float)Math.PI));
                    }
                    this.func_70659_e(f);
                    super.func_213352_e(new Vector3d(0.0, 0.0, 1.0));
                } else {
                    this.func_213317_d(Vector3d.field_186680_a);
                }
                this.field_184618_aE = this.field_70721_aZ;
                double motionX = this.func_226277_ct_() - this.field_70169_q;
                double motionZ = this.func_226281_cx_() - this.field_70166_s;
                float f1 = MathHelper.func_76133_a((double)(motionX * motionX + motionZ * motionZ)) * 4.0f;
                if (f1 > 1.0f) {
                    f1 = 1.0f;
                }
                this.field_70721_aZ += (f1 - this.field_70721_aZ) * 0.4f;
                this.field_184619_aG += this.field_70721_aZ;
            } else {
                this.field_70138_W = 0.5f;
                this.field_70747_aH = 0.02f;
                super.func_213352_e(motion);
            }
        }
    }

    public boolean boost() {
        if (this.boosting) {
            return false;
        }
        this.boosting = true;
        this.boostTime = 0;
        this.totalBoostTime = this.func_70681_au().nextInt(841) + 140;
        this.func_184212_Q().func_187227_b(BOOST_TIME, (Object)this.totalBoostTime);
        return true;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity parent) {
        return (AgeableEntity)ModEntities.SKELETON_PIG.func_200721_a((World)world);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_151147_al;
    }
}

