/*
 * Decompiled with CFR 0.152.
 */
package bones.common.entity;

import bones.common.entity.UndeadAnimalEntity;
import bones.common.init.ModEntities;
import bones.common.init.ModSoundEvents;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.AgeableEntity;
import net.minecraft.entity.CreatureEntity;
import net.minecraft.entity.EntitySize;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.ILivingEntityData;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.Pose;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.AttributeModifierMap;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.BreedGoal;
import net.minecraft.entity.ai.goal.FollowParentGoal;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.LookRandomlyGoal;
import net.minecraft.entity.ai.goal.PanicGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.ai.goal.TemptGoal;
import net.minecraft.entity.ai.goal.WaterAvoidingRandomWalkingGoal;
import net.minecraft.entity.passive.AnimalEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.IForgeShearable;

public class SkeletonSheepEntity
extends UndeadAnimalEntity
implements IForgeShearable {
    private static final DataParameter<Boolean> IS_SHEARED = EntityDataManager.func_187226_a(SkeletonSheepEntity.class, (IDataSerializer)DataSerializers.field_187198_h);
    private static final ResourceLocation LOOT_TABLE_UNSHEARED = new ResourceLocation("bones", "entities/skeleton_sheep_unsheared");

    public SkeletonSheepEntity(EntityType<? extends SkeletonSheepEntity> type, World worldIn) {
        super(type, worldIn);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new PanicGoal((CreatureEntity)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (Goal)new BreedGoal((AnimalEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (Goal)new TemptGoal((CreatureEntity)this, 1.1, Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151078_bh, Items.field_179561_bm}), false));
        this.field_70714_bg.func_75776_a(4, (Goal)new FollowParentGoal((AnimalEntity)this, 1.1));
        this.field_70714_bg.func_75776_a(6, (Goal)new WaterAvoidingRandomWalkingGoal((CreatureEntity)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (Goal)new LookRandomlyGoal((MobEntity)this));
    }

    public static AttributeModifierMap.MutableAttribute createAttributes() {
        return MobEntity.func_233666_p_().func_233815_a_(Attributes.field_233818_a_, 8.0).func_233815_a_(Attributes.field_233821_d_, 0.25);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_SHEARED, (Object)true);
    }

    public void func_70037_a(CompoundNBT compound) {
        super.func_70037_a(compound);
        this.field_70180_af.func_187227_b(IS_SHEARED, (Object)(!compound.func_74767_n("IsShearable") ? 1 : 0));
    }

    public void func_213281_b(CompoundNBT compound) {
        super.func_213281_b(compound);
        compound.func_74757_a("IsShearable", !this.isSheared());
    }

    protected ResourceLocation func_184647_J() {
        if (!this.isSheared()) {
            return LOOT_TABLE_UNSHEARED;
        }
        return super.func_184647_J();
    }

    public ILivingEntityData func_213386_a(IServerWorld world, DifficultyInstance difficulty, SpawnReason reason, @Nullable ILivingEntityData spawnData, @Nullable CompoundNBT dataTag) {
        if (this.field_70146_Z.nextInt(4) == 0) {
            this.field_70180_af.func_187227_b(IS_SHEARED, (Object)false);
        }
        return super.func_213386_a(world, difficulty, reason, spawnData, dataTag);
    }

    protected float func_213348_b(Pose pose, EntitySize size) {
        return 0.95f * size.field_220316_b;
    }

    public AgeableEntity func_241840_a(ServerWorld world, AgeableEntity parent) {
        return (AgeableEntity)ModEntities.SKELETON_SHEEP.func_200721_a((World)world);
    }

    public List<ItemStack> onSheared(PlayerEntity player, ItemStack stack, World world, BlockPos pos, int fortune) {
        ArrayList<ItemStack> result = new ArrayList<ItemStack>();
        if (!world.func_201670_d()) {
            this.field_70180_af.func_187227_b(IS_SHEARED, (Object)true);
            int amount = 1 + this.field_70146_Z.nextInt(3);
            for (int i = 0; i < amount; ++i) {
                result.add(new ItemStack((IItemProvider)Items.field_179561_bm));
            }
        }
        this.func_184185_a(ModSoundEvents.SKELETON_SHEEP_SHEAR, 1.0f, 1.0f);
        return result;
    }

    public boolean isShearable(ItemStack item, World world, BlockPos pos) {
        return !this.isSheared();
    }

    public boolean isSheared() {
        return (Boolean)this.field_70180_af.func_187225_a(IS_SHEARED);
    }

    public ActionResultType func_230254_b_(PlayerEntity player, Hand hand) {
        ItemStack stack;
        ActionResultType actionResultType = super.func_230254_b_(player, hand);
        if (!actionResultType.func_226246_a_() && (stack = player.func_184586_b(hand)).func_77973_b() == Items.field_151078_bh && this.isSheared()) {
            this.func_175505_a(player, stack);
            if (!this.field_70170_p.field_72995_K) {
                if (this.field_70146_Z.nextInt(3) == 0) {
                    this.field_70180_af.func_187227_b(IS_SHEARED, (Object)false);
                }
            } else {
                for (int i = 4 + this.field_70146_Z.nextInt(4); i > 0; --i) {
                    this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197632_y, this.func_226277_ct_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), this.func_226278_cu_() + 0.5 + (double)(this.field_70146_Z.nextFloat() * this.func_213302_cg()), this.func_226281_cx_() + (double)(this.field_70146_Z.nextFloat() * this.func_213311_cf() * 2.0f) - (double)this.func_213311_cf(), 0.0, 0.0, 0.0);
                }
            }
            return ActionResultType.func_233537_a_((boolean)this.field_70170_p.func_201670_d());
        }
        return actionResultType;
    }

    protected SoundEvent func_184639_G() {
        return ModSoundEvents.SKELETON_SHEEP_AMBIENT;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return ModSoundEvents.SKELETON_SHEEP_HURT;
    }

    protected SoundEvent func_184615_bR() {
        return ModSoundEvents.SKELETON_SHEEP_DEATH;
    }

    protected void func_180429_a(BlockPos pos, BlockState blockIn) {
        this.func_184185_a(SoundEvents.field_187868_fj, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return stack.func_77973_b() == Items.field_179561_bm;
    }
}

