/*
 * Decompiled with CFR 0.152.
 */
package bones.common.init;

import bones.client.render.SkeletonChickenRenderer;
import bones.client.render.SkeletonCowRenderer;
import bones.client.render.SkeletonPigRenderer;
import bones.client.render.SkeletonSheepRenderer;
import bones.common.entity.SkeletonChickenEntity;
import bones.common.entity.SkeletonCowEntity;
import bones.common.entity.SkeletonPigEntity;
import bones.common.entity.SkeletonSheepEntity;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.MobSpawnInfo;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.event.entity.EntityAttributeCreationEvent;
import net.minecraftforge.event.world.BiomeLoadingEvent;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ModEntities {
    public static final EntityType<SkeletonSheepEntity> SKELETON_SHEEP = EntityType.Builder.func_220322_a(SkeletonSheepEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.3f).func_220320_c().func_206830_a("skeleton_sheep");
    public static final EntityType<SkeletonPigEntity> SKELETON_PIG = EntityType.Builder.func_220322_a(SkeletonPigEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 0.9f).func_220320_c().func_206830_a("skeleton_pig");
    public static final EntityType<SkeletonCowEntity> SKELETON_COW = EntityType.Builder.func_220322_a(SkeletonCowEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.9f, 1.4f).func_220320_c().func_206830_a("skeleton_cow");
    public static final EntityType<SkeletonChickenEntity> SKELETON_CHICKEN = EntityType.Builder.func_220322_a(SkeletonChickenEntity::new, (EntityClassification)EntityClassification.CREATURE).func_220321_a(0.4f, 0.7f).func_220320_c().func_206830_a("skeleton_chicken");

    public static void register(RegistryEvent.Register<EntityType<?>> event) {
        SKELETON_SHEEP.setRegistryName(new ResourceLocation("bones", "skeleton_sheep"));
        SKELETON_PIG.setRegistryName(new ResourceLocation("bones", "skeleton_pig"));
        SKELETON_COW.setRegistryName(new ResourceLocation("bones", "skeleton_cow"));
        SKELETON_CHICKEN.setRegistryName(new ResourceLocation("bones", "skeleton_chicken"));
        event.getRegistry().registerAll((IForgeRegistryEntry[])new EntityType[]{SKELETON_SHEEP, SKELETON_PIG, SKELETON_COW, SKELETON_CHICKEN});
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_SHEEP, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (animal, world, reason, pos, random) -> true);
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_PIG, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (animal, world, reason, pos, random) -> true);
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_COW, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (animal, world, reason, pos, random) -> true);
        EntitySpawnPlacementRegistry.func_209343_a(SKELETON_CHICKEN, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.ON_GROUND, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, (animal, world, reason, pos, random) -> true);
    }

    public static void addSpawns(BiomeLoadingEvent event) {
        if (event.getCategory() == Biome.Category.NETHER) {
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(SKELETON_SHEEP, 50, 2, 6));
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(SKELETON_PIG, 50, 2, 6));
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(SKELETON_COW, 50, 2, 6));
            event.getSpawns().getSpawner(EntityClassification.CREATURE).add(new MobSpawnInfo.Spawners(SKELETON_CHICKEN, 50, 2, 6));
        }
    }

    public static void addEntityAttributes(EntityAttributeCreationEvent event) {
        event.put(SKELETON_SHEEP, SkeletonSheepEntity.createAttributes().func_233813_a_());
        event.put(SKELETON_PIG, SkeletonPigEntity.createAttributes().func_233813_a_());
        event.put(SKELETON_COW, SkeletonCowEntity.createAttributes().func_233813_a_());
        event.put(SKELETON_CHICKEN, SkeletonChickenEntity.createAttributes().func_233813_a_());
    }

    public static void registerRenderingHandlers(FMLClientSetupEvent event) {
        RenderingRegistry.registerEntityRenderingHandler(SKELETON_SHEEP, SkeletonSheepRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SKELETON_PIG, SkeletonPigRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SKELETON_COW, SkeletonCowRenderer::new);
        RenderingRegistry.registerEntityRenderingHandler(SKELETON_CHICKEN, SkeletonChickenRenderer::new);
    }
}

