/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.core.handler;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.CompressedStreamTools;
import vazkii.botania.common.Botania;

public final class PersistentVariableHelper {
    private static final String TAG_FIRST_LOAD = "firstLoad";
    private static final String TAG_DOG = "dog";
    private static File cacheFile;
    public static boolean firstLoad;
    public static boolean dog;

    public static void save() {
        CompoundNBT cmp = new CompoundNBT();
        cmp.func_74757_a(TAG_FIRST_LOAD, firstLoad);
        cmp.func_74757_a(TAG_DOG, dog);
        PersistentVariableHelper.injectNBTToFile(cmp, cacheFile);
    }

    private static void load() {
        CompoundNBT cmp = PersistentVariableHelper.getCacheCompound(cacheFile);
        firstLoad = cmp.func_74764_b(TAG_FIRST_LOAD) ? cmp.func_74767_n(TAG_FIRST_LOAD) : firstLoad;
        dog = cmp.func_74767_n(TAG_DOG);
    }

    public static void init() {
        cacheFile = new File(Minecraft.func_71410_x().field_71412_D, "BotaniaVars.dat");
        try {
            cacheFile.createNewFile();
        }
        catch (IOException e) {
            Botania.LOGGER.error("Failed to create persistent variable file", (Throwable)e);
        }
        PersistentVariableHelper.load();
    }

    private static CompoundNBT getCacheCompound(File cache) {
        try {
            return CompressedStreamTools.func_74796_a((InputStream)new FileInputStream(cache));
        }
        catch (IOException e) {
            Botania.LOGGER.error("Failed to load persistent variables, overwriting with current state", (Throwable)e);
            PersistentVariableHelper.save();
            return new CompoundNBT();
        }
    }

    private static void injectNBTToFile(CompoundNBT cmp, File f) {
        try {
            CompressedStreamTools.func_74799_a((CompoundNBT)cmp, (OutputStream)new FileOutputStream(f));
        }
        catch (IOException e) {
            Botania.LOGGER.error("Failed to save persistent variables", (Throwable)e);
        }
    }

    static {
        firstLoad = true;
        dog = true;
    }
}

