/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.client.patchouli.processor;

import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.KeybindTextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import vazkii.botania.api.recipe.IManaInfusionRecipe;
import vazkii.botania.client.patchouli.PatchouliUtils;
import vazkii.botania.common.Botania;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.patchouli.api.IComponentProcessor;
import vazkii.patchouli.api.IVariable;
import vazkii.patchouli.api.IVariableProvider;

public class ManaInfusionProcessor
implements IComponentProcessor {
    private List<IManaInfusionRecipe> recipes;
    private boolean hasCustomHeading;

    public void setup(IVariableProvider variables) {
        if (variables.has("recipes") && variables.has("group")) {
            Botania.LOGGER.warn("Mana infusion template has both 'recipes' and 'group', ignoring 'recipes'");
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        if (variables.has("group")) {
            String group = variables.get("group").asString();
            builder.addAll(PatchouliUtils.getRecipeGroup(ModRecipeTypes.MANA_INFUSION_TYPE, group));
        } else {
            for (IVariable s : variables.get("recipes").asListOrSingleton()) {
                IManaInfusionRecipe recipe = PatchouliUtils.getRecipe(ModRecipeTypes.MANA_INFUSION_TYPE, new ResourceLocation(s.asString()));
                if (recipe == null) continue;
                builder.add((Object)recipe);
            }
        }
        this.recipes = builder.build();
        this.hasCustomHeading = variables.has("heading");
    }

    public IVariable process(String key) {
        if (this.recipes.isEmpty()) {
            return null;
        }
        switch (key) {
            case "heading": {
                if (!this.hasCustomHeading) {
                    return IVariable.from((Object)this.recipes.get(0).func_77571_b().func_200301_q());
                }
                return null;
            }
            case "input": {
                return PatchouliUtils.interweaveIngredients(this.recipes.stream().map(r -> (Ingredient)r.func_192400_c().get(0)).collect(Collectors.toList()));
            }
            case "output": {
                return IVariable.wrapList((Iterable)this.recipes.stream().map(IRecipe::func_77571_b).map(IVariable::from).collect(Collectors.toList()));
            }
            case "catalyst": {
                return IVariable.wrapList((Iterable)this.recipes.stream().map(IManaInfusionRecipe::getCatalyst).map(state -> {
                    if (state == null) {
                        return ItemStack.field_190927_a;
                    }
                    return new ItemStack((IItemProvider)state.func_177230_c().func_199767_j());
                }).map(IVariable::from).collect(Collectors.toList()));
            }
            case "mana": {
                return IVariable.wrapList((Iterable)this.recipes.stream().mapToInt(IManaInfusionRecipe::getManaToConsume).mapToObj(IVariable::wrap).collect(Collectors.toList()));
            }
            case "drop": {
                IFormattableTextComponent q = new StringTextComponent("(?)").func_240699_a_(TextFormatting.BOLD);
                return IVariable.from((Object)new TranslationTextComponent("botaniamisc.drop").func_240702_b_(" ").func_230529_a_((ITextComponent)q));
            }
            case "dropTip0": 
            case "dropTip1": {
                IFormattableTextComponent drop = new KeybindTextComponent("key.drop").func_240699_a_(TextFormatting.GREEN);
                return IVariable.from((Object)new TranslationTextComponent("botaniamisc." + key, new Object[]{drop}));
            }
        }
        return null;
    }
}

