/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.decor;

import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.DyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.VanillaPacketDispatcher;
import vazkii.botania.api.item.IFloatingFlower;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileFloatingFlower;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.item.IFloatingFlowerVariant;

public class BlockFloatingFlower
extends BlockModWaterloggable
implements ITileEntityProvider {
    private static final VoxelShape SHAPE = BlockFloatingFlower.func_208617_a((double)1.6, (double)1.6, (double)1.6, (double)14.4, (double)14.4, (double)14.4);
    public final DyeColor color;

    public BlockFloatingFlower(DyeColor color, AbstractBlock.Properties props) {
        super(props);
        this.color = color;
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public BlockRenderType func_149645_b(BlockState state) {
        return (Boolean)ConfigHandler.CLIENT.staticFloaters.get() != false ? BlockRenderType.MODEL : BlockRenderType.ENTITYBLOCK_ANIMATED;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World world, BlockPos pos, Random rand) {
        int hex = this.color.getColorValue();
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        if (rand.nextDouble() < (Double)ConfigHandler.CLIENT.flowerParticleFrequency.get()) {
            SparkleParticleData data = SparkleParticleData.sparkle(rand.nextFloat(), (float)r / 255.0f, (float)g / 255.0f, (float)b / 255.0f, 5);
            world.func_195594_a((IParticleData)data, (double)pos.func_177958_n() + 0.3 + (double)rand.nextFloat() * 0.5, (double)pos.func_177956_o() + 0.5 + (double)rand.nextFloat() * 0.5, (double)pos.func_177952_p() + 0.3 + (double)rand.nextFloat() * 0.5, 0.0, 0.0, 0.0);
        }
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        ItemStack stack = player.func_184586_b(hand);
        TileEntity te = world.func_175625_s(pos);
        if (!stack.func_190926_b() && te != null && te.getCapability(TileEntitySpecialFlower.FLOATING_FLOWER_CAP).isPresent()) {
            IFloatingFlower.IslandType newType;
            IFloatingFlower flower = (IFloatingFlower)te.getCapability(TileEntitySpecialFlower.FLOATING_FLOWER_CAP).orElseThrow(IllegalStateException::new);
            IFloatingFlower.IslandType type = null;
            if (stack.func_77973_b() == Items.field_151126_ay) {
                type = IFloatingFlower.IslandType.SNOW;
            } else if (stack.func_77973_b() instanceof IFloatingFlowerVariant && (newType = ((IFloatingFlowerVariant)stack.func_77973_b()).getIslandType(stack)) != null) {
                type = newType;
            }
            if (type != null && type != flower.getIslandType()) {
                if (!world.field_72995_K) {
                    flower.setIslandType(type);
                    VanillaPacketDispatcher.dispatchTEToNearbyPlayers(te);
                }
                if (!player.field_71075_bZ.field_75098_d) {
                    stack.func_190918_g(1);
                }
                return ActionResultType.SUCCESS;
            }
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TileFloatingFlower();
    }
}

