/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.mana;

import com.mojang.blaze3d.matrix.MatrixStack;
import javax.annotation.Nonnull;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.ITileEntityProvider;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.InventoryHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.ITextProperties;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.ILens;
import vazkii.botania.api.mana.IManaCollisionGhost;
import vazkii.botania.api.mana.IManaTrigger;
import vazkii.botania.api.state.BotaniaStateProps;
import vazkii.botania.api.wand.IWandHUD;
import vazkii.botania.common.block.BlockModWaterloggable;
import vazkii.botania.common.block.tile.TileSimpleInventory;
import vazkii.botania.common.block.tile.mana.TilePrism;
import vazkii.botania.common.entity.EntityManaBurst;

public class BlockPrism
extends BlockModWaterloggable
implements ITileEntityProvider,
IManaTrigger,
IManaCollisionGhost,
IWandHUD {
    private static final VoxelShape SHAPE = BlockPrism.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)16.0, (double)12.0);

    public BlockPrism(AbstractBlock.Properties builder) {
        super(builder);
        this.func_180632_j((BlockState)((BlockState)this.func_176223_P().func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false))).func_206870_a((Property)BotaniaStateProps.HAS_LENS, (Comparable)Boolean.valueOf(false)));
    }

    @Nonnull
    public VoxelShape func_220053_a(BlockState state, IBlockReader world, BlockPos pos, ISelectionContext ctx) {
        return SHAPE;
    }

    @Nonnull
    public VoxelShape func_220071_b(@Nonnull BlockState state, @Nonnull IBlockReader world, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        if (context.getEntity() instanceof EntityManaBurst) {
            return SHAPE;
        }
        return super.func_220071_b(state, world, pos, context);
    }

    @Override
    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{BlockStateProperties.field_208194_u, BotaniaStateProps.HAS_LENS});
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        boolean isHeldItemLens;
        TileEntity tile = world.func_175625_s(pos);
        if (!(tile instanceof TilePrism)) {
            return ActionResultType.PASS;
        }
        TilePrism prism = (TilePrism)tile;
        ItemStack lens = prism.getItemHandler().func_70301_a(0);
        ItemStack heldItem = player.func_184586_b(hand);
        boolean bl = isHeldItemLens = !heldItem.func_190926_b() && heldItem.func_77973_b() instanceof ILens;
        if (lens.func_190926_b() && isHeldItemLens) {
            if (!player.field_71075_bZ.field_75098_d) {
                player.func_184611_a(hand, ItemStack.field_190927_a);
            }
            prism.getItemHandler().func_70299_a(0, heldItem.func_77946_l());
        } else if (!lens.func_190926_b()) {
            player.field_71071_by.func_191975_a(player.field_70170_p, lens);
            prism.getItemHandler().func_70299_a(0, ItemStack.field_190927_a);
        }
        return ActionResultType.SUCCESS;
    }

    public void func_220069_a(BlockState state, World world, BlockPos pos, Block block, BlockPos fromPos, boolean isMoving) {
        boolean power = world.func_175687_A(pos) > 0 || world.func_175687_A(pos.func_177984_a()) > 0;
        boolean powered = (Boolean)state.func_177229_b((Property)BlockStateProperties.field_208194_u);
        if (!world.field_72995_K) {
            if (power && !powered) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(true)));
            } else if (!power && powered) {
                world.func_175656_a(pos, (BlockState)state.func_206870_a((Property)BlockStateProperties.field_208194_u, (Comparable)Boolean.valueOf(false)));
            }
        }
    }

    public void func_196243_a(@Nonnull BlockState state, @Nonnull World world, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean isMoving) {
        if (state.func_177230_c() != newState.func_177230_c()) {
            TileEntity te = world.func_175625_s(pos);
            if (te instanceof TileSimpleInventory) {
                InventoryHelper.func_180175_a((World)world, (BlockPos)pos, (IInventory)((TileSimpleInventory)te).getItemHandler());
            }
            super.func_196243_a(state, world, pos, newState, isMoving);
        }
    }

    @Nonnull
    public TileEntity func_196283_a_(@Nonnull IBlockReader world) {
        return new TilePrism();
    }

    @Override
    public void onBurstCollision(IManaBurst burst, World world, BlockPos pos) {
        TileEntity tile = world.func_175625_s(pos);
        if (tile instanceof TilePrism) {
            ((TilePrism)tile).onBurstCollision(burst);
        }
    }

    @Override
    public boolean isGhost(BlockState state, World world, BlockPos pos) {
        return true;
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderHUD(MatrixStack ms, Minecraft mc, World world, BlockPos pos) {
        ItemStack lens;
        TileEntity te = world.func_175625_s(pos);
        if (te instanceof TilePrism && !(lens = ((TilePrism)te).func_70301_a(0)).func_190926_b()) {
            ITextComponent lensName = lens.func_200301_q();
            int width = 16 + mc.field_71466_p.func_238414_a_((ITextProperties)lensName) / 2;
            int x = mc.func_228018_at_().func_198107_o() / 2 - width;
            int y = mc.func_228018_at_().func_198087_p() / 2;
            mc.field_71466_p.func_243246_a(ms, lensName, (float)(x + 20), (float)(y + 5), -1);
            mc.func_175599_af().func_180450_b(lens, x, y);
        }
    }
}

