/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.block.subtile;

import java.util.Arrays;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.World;
import vazkii.botania.api.recipe.IPureDaisyRecipe;
import vazkii.botania.api.subtile.RadiusDescriptor;
import vazkii.botania.api.subtile.TileEntitySpecialFlower;
import vazkii.botania.client.fx.SparkleParticleData;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.handler.ConfigHandler;
import vazkii.botania.common.crafting.ModRecipeTypes;

public class SubTilePureDaisy
extends TileEntitySpecialFlower {
    private static final String TAG_POSITION = "position";
    private static final String TAG_TICKS_REMAINING = "ticksRemaining";
    private static final int RECIPE_COMPLETE_EVENT = 0;
    private static final BlockPos[] POSITIONS = new BlockPos[]{new BlockPos(-1, 0, -1), new BlockPos(-1, 0, 0), new BlockPos(-1, 0, 1), new BlockPos(0, 0, 1), new BlockPos(1, 0, 1), new BlockPos(1, 0, 0), new BlockPos(1, 0, -1), new BlockPos(0, 0, -1)};
    private int positionAt = 0;
    private final int[] prevTicksRemaining = new int[POSITIONS.length];
    private final int[] ticksRemaining = new int[POSITIONS.length];

    public SubTilePureDaisy() {
        super(ModSubtiles.PURE_DAISY);
        Arrays.fill(this.prevTicksRemaining, -1);
        Arrays.fill(this.ticksRemaining, -1);
    }

    @Override
    public void tickFlower() {
        super.tickFlower();
        if (this.func_145831_w().field_72995_K) {
            for (int i = 0; i < POSITIONS.length; ++i) {
                if (this.ticksRemaining[i] <= 0) continue;
                BlockPos coords = this.getEffectivePos().func_177971_a((Vector3i)POSITIONS[i]);
                SparkleParticleData data = SparkleParticleData.sparkle((float)Math.random(), 1.0f, 1.0f, 1.0f, 5);
                this.field_145850_b.func_195594_a((IParticleData)data, (double)coords.func_177958_n() + Math.random(), (double)coords.func_177956_o() + Math.random(), (double)coords.func_177952_p() + Math.random(), 0.0, 0.0, 0.0);
            }
            return;
        }
        ++this.positionAt;
        if (this.positionAt == POSITIONS.length) {
            this.positionAt = 0;
        }
        BlockPos acoords = POSITIONS[this.positionAt];
        BlockPos coords = this.getEffectivePos().func_177971_a((Vector3i)acoords);
        World world = this.func_145831_w();
        if (!world.func_175623_d(coords)) {
            world.func_217381_Z().func_76320_a("findRecipe");
            IPureDaisyRecipe recipe = this.findRecipe(coords);
            world.func_217381_Z().func_76319_b();
            if (recipe != null) {
                if (this.ticksRemaining[this.positionAt] == -1) {
                    this.ticksRemaining[this.positionAt] = recipe.getTime();
                }
                int n = this.positionAt;
                this.ticksRemaining[n] = this.ticksRemaining[n] - 1;
                if (this.ticksRemaining[this.positionAt] <= 0) {
                    this.ticksRemaining[this.positionAt] = -1;
                    if (recipe.set(world, coords, this)) {
                        if (((Boolean)ConfigHandler.COMMON.blockBreakParticles.get()).booleanValue()) {
                            this.func_145831_w().func_217379_c(2001, coords, Block.func_196246_j((BlockState)recipe.getOutputState()));
                        }
                        this.func_145831_w().func_175641_c(this.func_174877_v(), this.func_195044_w().func_177230_c(), 0, this.positionAt);
                    }
                }
            } else {
                this.ticksRemaining[this.positionAt] = -1;
            }
        } else {
            this.ticksRemaining[this.positionAt] = -1;
        }
        if (!Arrays.equals(this.ticksRemaining, this.prevTicksRemaining)) {
            this.func_70296_d();
            this.sync();
            System.arraycopy(this.ticksRemaining, 0, this.prevTicksRemaining, 0, POSITIONS.length);
        }
    }

    @Nullable
    private IPureDaisyRecipe findRecipe(BlockPos coords) {
        BlockState state = this.func_145831_w().func_180495_p(coords);
        for (IRecipe recipe : ModRecipeTypes.getRecipes(this.field_145850_b, ModRecipeTypes.PURE_DAISY_TYPE).values()) {
            if (!(recipe instanceof IPureDaisyRecipe) || !((IPureDaisyRecipe)recipe).matches(this.func_145831_w(), coords, this, state)) continue;
            return (IPureDaisyRecipe)recipe;
        }
        return null;
    }

    public boolean func_145842_c(int type, int param) {
        switch (type) {
            case 0: {
                if (this.func_145831_w().field_72995_K) {
                    BlockPos coords = this.getEffectivePos().func_177971_a((Vector3i)POSITIONS[param]);
                    for (int i = 0; i < 25; ++i) {
                        double x = (double)coords.func_177958_n() + Math.random();
                        double y = (double)coords.func_177956_o() + Math.random() + 0.5;
                        double z = (double)coords.func_177952_p() + Math.random();
                        WispParticleData data = WispParticleData.wisp((float)Math.random() / 2.0f, 1.0f, 1.0f, 1.0f);
                        this.func_145831_w().func_195594_a((IParticleData)data, x, y, z, 0.0, 0.0, 0.0);
                    }
                }
                return true;
            }
        }
        return super.func_145842_c(type, param);
    }

    @Override
    public RadiusDescriptor getRadius() {
        return new RadiusDescriptor.Square(this.getEffectivePos(), 1);
    }

    @Override
    public void readFromPacketNBT(CompoundNBT cmp) {
        super.readFromPacketNBT(cmp);
        this.positionAt = cmp.func_74762_e(TAG_POSITION);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            this.ticksRemaining[i] = cmp.func_74762_e(TAG_TICKS_REMAINING + i);
        }
    }

    @Override
    public void writeToPacketNBT(CompoundNBT cmp) {
        super.writeToPacketNBT(cmp);
        cmp.func_74768_a(TAG_POSITION, this.positionAt);
        for (int i = 0; i < this.ticksRemaining.length; ++i) {
            cmp.func_74768_a(TAG_TICKS_REMAINING + i, this.ticksRemaining[i]);
        }
    }
}

