/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.entity;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import java.nio.FloatBuffer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.audio.TickableSound;
import net.minecraft.client.renderer.Rectangle2d;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.MobEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.ai.goal.Goal;
import net.minecraft.entity.ai.goal.LookAtGoal;
import net.minecraft.entity.ai.goal.SwimGoal;
import net.minecraft.entity.monster.WitherSkeletonEntity;
import net.minecraft.entity.monster.ZombieEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.datasync.IDataSerializer;
import net.minecraft.network.play.server.SRemoveEntityEffectPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.EffectType;
import net.minecraft.potion.Effects;
import net.minecraft.tags.ITag;
import net.minecraft.tileentity.BeaconTileEntity;
import net.minecraft.util.DamageSource;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.Util;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.BossInfo;
import net.minecraft.world.Difficulty;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IServerWorld;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerBossInfo;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.util.FakePlayer;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.NetworkHooks;
import vazkii.botania.client.core.handler.BossBarHandler;
import vazkii.botania.client.core.helper.ShaderCallback;
import vazkii.botania.client.core.helper.ShaderHelper;
import vazkii.botania.client.fx.WispParticleData;
import vazkii.botania.common.Botania;
import vazkii.botania.common.advancements.DopplegangerNoArmorTrigger;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.core.helper.MathHelper;
import vazkii.botania.common.core.helper.Vector3;
import vazkii.botania.common.entity.EntityMagicLandmine;
import vazkii.botania.common.entity.EntityMagicMissile;
import vazkii.botania.common.entity.EntityPixie;
import vazkii.botania.common.entity.ModEntities;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ModTags;
import vazkii.botania.common.lib.ResourceLocationHelper;
import vazkii.botania.common.network.PacketBotaniaEffect;
import vazkii.botania.common.network.PacketHandler;

public class EntityDoppleganger
extends MobEntity
implements IEntityAdditionalSpawnData {
    public static final float ARENA_RANGE = 12.0f;
    public static final int ARENA_HEIGHT = 5;
    private static final int SPAWN_TICKS = 160;
    public static final float MAX_HP = 320.0f;
    private static final int MOB_SPAWN_START_TICKS = 20;
    private static final int MOB_SPAWN_END_TICKS = 80;
    private static final int MOB_SPAWN_BASE_TICKS = 800;
    private static final int MOB_SPAWN_TICKS = 900;
    private static final int MOB_SPAWN_WAVES = 10;
    private static final int MOB_SPAWN_WAVE_TIME = 80;
    private static final String TAG_INVUL_TIME = "invulTime";
    private static final String TAG_AGGRO = "aggro";
    private static final String TAG_SOURCE_X = "sourceX";
    private static final String TAG_SOURCE_Y = "sourceY";
    private static final String TAG_SOURCE_Z = "sourcesZ";
    private static final String TAG_MOB_SPAWN_TICKS = "mobSpawnTicks";
    private static final String TAG_HARD_MODE = "hardMode";
    private static final String TAG_PLAYER_COUNT = "playerCount";
    private static final ITag.INamedTag<Block> BLACKLIST = ModTags.Blocks.GAIA_BREAK_BLACKLIST;
    private static final DataParameter<Integer> INVUL_TIME = EntityDataManager.func_187226_a(EntityDoppleganger.class, (IDataSerializer)DataSerializers.field_187192_b);
    private static final List<BlockPos> PYLON_LOCATIONS = ImmutableList.of((Object)new BlockPos(4, 1, 4), (Object)new BlockPos(4, 1, -4), (Object)new BlockPos(-4, 1, 4), (Object)new BlockPos(-4, 1, -4));
    private static final List<ResourceLocation> CHEATY_BLOCKS = Arrays.asList(new ResourceLocation("openblocks", "beartrap"), new ResourceLocation("thaumictinkerer", "magnet"));
    private boolean spawnLandmines = false;
    private boolean spawnPixies = false;
    private boolean anyWithArmor = false;
    private boolean aggro = false;
    private int tpDelay = 0;
    private int mobSpawnTicks = 0;
    private int playerCount = 0;
    private boolean hardMode = false;
    private BlockPos source = BlockPos.field_177992_a;
    private final List<UUID> playersWhoAttacked = new ArrayList<UUID>();
    private final ServerBossInfo bossInfo = (ServerBossInfo)new ServerBossInfo(ModEntities.DOPPLEGANGER.func_212546_e(), BossInfo.Color.PINK, BossInfo.Overlay.PROGRESS).func_186743_c(true);
    private UUID bossInfoUUID = this.bossInfo.func_186737_d();
    public PlayerEntity trueKiller = null;
    private static final Pattern FAKE_PLAYER_PATTERN = Pattern.compile("^(?:\\[.*\\])|(?:ComputerCraft)$");
    @OnlyIn(value=Dist.CLIENT)
    private ShaderCallback shaderCallback;

    public EntityDoppleganger(EntityType<EntityDoppleganger> type, World world) {
        super(type, world);
        this.field_70728_aV = 825;
        if (world.field_72995_K) {
            Botania.proxy.addBoss(this);
        }
    }

    public static boolean spawn(PlayerEntity player, ItemStack stack, World world, BlockPos pos, boolean hard) {
        if (!(world.func_175625_s(pos) instanceof BeaconTileEntity) || !EntityDoppleganger.isTruePlayer((Entity)player) || EntityDoppleganger.countGaiaGuardiansAround(world, pos) > 0) {
            return false;
        }
        if (world.func_175659_aa() == Difficulty.PEACEFUL) {
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("botaniamisc.peacefulNoob").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            return false;
        }
        List<BlockPos> invalidPylonBlocks = EntityDoppleganger.checkPylons(world, pos);
        if (!invalidPylonBlocks.isEmpty()) {
            if (world.field_72995_K) {
                EntityDoppleganger.warnInvalidBlocks(world, invalidPylonBlocks);
            } else {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("botaniamisc.needsCatalysts").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            return false;
        }
        List<BlockPos> invalidArenaBlocks = EntityDoppleganger.checkArena(world, pos);
        if (!invalidArenaBlocks.isEmpty()) {
            if (world.field_72995_K) {
                EntityDoppleganger.warnInvalidBlocks(world, invalidArenaBlocks);
            } else {
                PacketHandler.sendTo((ServerPlayerEntity)player, new PacketBotaniaEffect(PacketBotaniaEffect.EffectType.ARENA_INDICATOR, pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), new int[0]));
                player.func_145747_a((ITextComponent)new TranslationTextComponent("botaniamisc.badArena").func_240699_a_(TextFormatting.RED), Util.field_240973_b_);
            }
            return false;
        }
        if (!world.field_72995_K) {
            int playerCount;
            stack.func_190918_g(1);
            EntityDoppleganger e = (EntityDoppleganger)ModEntities.DOPPLEGANGER.func_200721_a(world);
            e.func_70107_b((double)pos.func_177958_n() + 0.5, pos.func_177956_o() + 3, (double)pos.func_177952_p() + 0.5);
            e.setInvulTime(160);
            e.func_70606_j(1.0f);
            e.source = pos;
            e.mobSpawnTicks = 900;
            e.hardMode = hard;
            e.playerCount = playerCount = e.getPlayersAround().size();
            e.func_110148_a(Attributes.field_233818_a_).func_111128_a((double)(320.0f * (float)playerCount));
            if (hard) {
                e.func_110148_a(Attributes.field_233826_i_).func_111128_a(15.0);
            }
            e.func_184185_a(SoundEvents.field_187525_aO, 10.0f, 0.1f);
            e.func_213386_a((IServerWorld)((ServerWorld)world), world.func_175649_E(e.func_233580_cy_()), SpawnReason.EVENT, null, null);
            world.func_217376_c((Entity)e);
        }
        return true;
    }

    private static List<BlockPos> checkPylons(World world, BlockPos beaconPos) {
        ArrayList<BlockPos> invalidPylonBlocks = new ArrayList<BlockPos>();
        for (BlockPos coords : PYLON_LOCATIONS) {
            BlockPos pos_ = beaconPos.func_177971_a((Vector3i)coords);
            BlockState state = world.func_180495_p(pos_);
            if (state.func_177230_c() == ModBlocks.gaiaPylon) continue;
            invalidPylonBlocks.add(pos_);
        }
        return invalidPylonBlocks;
    }

    private static List<BlockPos> checkArena(World world, BlockPos beaconPos) {
        ArrayList<BlockPos> trippedPositions = new ArrayList<BlockPos>();
        int range = (int)Math.ceil(12.0);
        for (int x = -range; x <= range; ++x) {
            for (int z = -range; z <= range; ++z) {
                if (Math.abs(x) == 4 && Math.abs(z) == 4 || MathHelper.pointDistancePlane(x, z, 0.0, 0.0) > 12.0f) continue;
                boolean hasFloor = false;
                for (int y = -2; y <= 5; ++y) {
                    boolean isBlockHere;
                    if (x == 0 && y == 0 && z == 0) continue;
                    BlockPos pos = beaconPos.func_177982_a(x, y, z);
                    BlockState state = world.func_180495_p(pos);
                    boolean allowBlockHere = y < 0;
                    boolean bl = isBlockHere = !state.func_196952_d((IBlockReader)world, pos).func_197766_b();
                    if (allowBlockHere && isBlockHere) {
                        hasFloor = true;
                    }
                    if (y == 0 && !hasFloor) {
                        trippedPositions.add(pos.func_177977_b());
                    }
                    if (allowBlockHere || !isBlockHere || BLACKLIST.func_230235_a_((Object)state.func_177230_c())) continue;
                    trippedPositions.add(pos);
                }
            }
        }
        return trippedPositions;
    }

    private static void warnInvalidBlocks(World world, Iterable<BlockPos> invalidPositions) {
        WispParticleData data = WispParticleData.wisp(0.5f, 1.0f, 0.2f, 0.2f, 8.0f, false);
        for (BlockPos pos_ : invalidPositions) {
            world.func_195594_a((IParticleData)data, (double)pos_.func_177958_n() + 0.5, (double)pos_.func_177956_o() + 0.5, (double)pos_.func_177952_p() + 0.5, 0.0, 0.0, 0.0);
        }
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (Goal)new SwimGoal((MobEntity)this));
        this.field_70714_bg.func_75776_a(1, (Goal)new LookAtGoal((MobEntity)this, PlayerEntity.class, 18.0f));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(INVUL_TIME, (Object)0);
    }

    public int getInvulTime() {
        return (Integer)this.field_70180_af.func_187225_a(INVUL_TIME);
    }

    public BlockPos getSource() {
        return this.source;
    }

    public void setInvulTime(int time) {
        this.field_70180_af.func_187227_b(INVUL_TIME, (Object)time);
    }

    public void func_213281_b(CompoundNBT cmp) {
        super.func_213281_b(cmp);
        cmp.func_74768_a(TAG_INVUL_TIME, this.getInvulTime());
        cmp.func_74757_a(TAG_AGGRO, this.aggro);
        cmp.func_74768_a(TAG_MOB_SPAWN_TICKS, this.mobSpawnTicks);
        cmp.func_74768_a(TAG_SOURCE_X, this.source.func_177958_n());
        cmp.func_74768_a(TAG_SOURCE_Y, this.source.func_177956_o());
        cmp.func_74768_a(TAG_SOURCE_Z, this.source.func_177952_p());
        cmp.func_74757_a(TAG_HARD_MODE, this.hardMode);
        cmp.func_74768_a(TAG_PLAYER_COUNT, this.playerCount);
    }

    public void func_70037_a(CompoundNBT cmp) {
        super.func_70037_a(cmp);
        this.setInvulTime(cmp.func_74762_e(TAG_INVUL_TIME));
        this.aggro = cmp.func_74767_n(TAG_AGGRO);
        this.mobSpawnTicks = cmp.func_74762_e(TAG_MOB_SPAWN_TICKS);
        int x = cmp.func_74762_e(TAG_SOURCE_X);
        int y = cmp.func_74762_e(TAG_SOURCE_Y);
        int z = cmp.func_74762_e(TAG_SOURCE_Z);
        this.source = new BlockPos(x, y, z);
        this.hardMode = cmp.func_74767_n(TAG_HARD_MODE);
        this.playerCount = cmp.func_74764_b(TAG_PLAYER_COUNT) ? cmp.func_74762_e(TAG_PLAYER_COUNT) : 1;
        if (this.func_145818_k_()) {
            this.bossInfo.func_186739_a(this.func_145748_c_());
        }
    }

    public void func_200203_b(@Nullable ITextComponent name) {
        super.func_200203_b(name);
        this.bossInfo.func_186739_a(this.func_145748_c_());
    }

    public void func_70691_i(float amount) {
        if (this.getInvulTime() == 0) {
            super.func_70691_i(amount);
        }
    }

    public void func_174812_G() {
        this.func_70606_j(0.0f);
    }

    public boolean func_70097_a(@Nonnull DamageSource source, float amount) {
        Entity e = source.func_76346_g();
        if (e instanceof PlayerEntity && EntityDoppleganger.isTruePlayer(e) && this.getInvulTime() == 0) {
            PlayerEntity player = (PlayerEntity)e;
            if (!this.playersWhoAttacked.contains(player.func_110124_au())) {
                this.playersWhoAttacked.add(player.func_110124_au());
            }
            int cap = 25;
            return super.func_70097_a(source, Math.min((float)cap, amount));
        }
        return false;
    }

    public static boolean isTruePlayer(Entity e) {
        if (!(e instanceof PlayerEntity)) {
            return false;
        }
        PlayerEntity player = (PlayerEntity)e;
        String name = player.func_200200_C_().getString();
        return !(player instanceof FakePlayer) && !FAKE_PLAYER_PATTERN.matcher(name).matches();
    }

    protected void func_70665_d(@Nonnull DamageSource source, float amount) {
        super.func_70665_d(source, amount);
        Entity attacker = source.func_76364_f();
        if (attacker != null) {
            Vector3 thisVector = Vector3.fromEntityCenter((Entity)this);
            Vector3 playerVector = Vector3.fromEntityCenter(attacker);
            Vector3 motionVector = thisVector.subtract(playerVector).normalize().multiply(0.75);
            if (this.func_110143_aJ() > 0.0f) {
                this.func_213293_j(-motionVector.x, 0.5, -motionVector.z);
                this.tpDelay = 4;
                this.spawnPixies = this.aggro;
            }
            this.aggro = true;
        }
    }

    public void func_70645_a(@Nonnull DamageSource source) {
        super.func_70645_a(source);
        LivingEntity entitylivingbase = this.func_94060_bK();
        if (entitylivingbase instanceof ServerPlayerEntity && !this.anyWithArmor) {
            DopplegangerNoArmorTrigger.INSTANCE.trigger((ServerPlayerEntity)entitylivingbase, this, source);
        }
        this.func_184185_a(SoundEvents.field_187539_bB, 20.0f, (1.0f + (this.field_70170_p.field_73012_v.nextFloat() - this.field_70170_p.field_73012_v.nextFloat()) * 0.2f) * 0.7f);
        this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197626_s, this.func_226277_ct_(), this.func_226278_cu_(), this.func_226281_cx_(), 1.0, 0.0, 0.0);
    }

    public boolean func_213397_c(double dist) {
        return false;
    }

    public ResourceLocation func_184647_J() {
        return ResourceLocationHelper.prefix(this.hardMode ? "gaia_guardian_2" : "gaia_guardian");
    }

    protected void func_213354_a(@Nonnull DamageSource source, boolean wasRecentlyHit) {
        if (wasRecentlyHit && source.func_76346_g() instanceof PlayerEntity) {
            this.trueKiller = (PlayerEntity)source.func_76346_g();
        }
        for (UUID u : this.playersWhoAttacked) {
            PlayerEntity player = this.field_70170_p.func_217371_b(u);
            if (player == null) continue;
            PlayerEntity saveLastAttacker = this.field_70717_bb;
            Vector3d savePos = this.func_213303_ch();
            this.field_70717_bb = player;
            this.func_70107_b(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_());
            super.func_213354_a(DamageSource.func_76365_a((PlayerEntity)player), wasRecentlyHit);
            this.func_70107_b(savePos.func_82615_a(), savePos.func_82617_b(), savePos.func_82616_c());
            this.field_70717_bb = saveLastAttacker;
        }
        this.trueKiller = null;
    }

    public void func_70106_y() {
        if (this.field_70170_p.field_72995_K) {
            Botania.proxy.removeBoss(this);
        }
        super.func_70106_y();
    }

    public List<PlayerEntity> getPlayersAround() {
        float range = 15.0f;
        return this.field_70170_p.func_175647_a(PlayerEntity.class, new AxisAlignedBB((double)this.source.func_177958_n() + 0.5 - (double)range, (double)this.source.func_177956_o() + 0.5 - (double)range, (double)this.source.func_177952_p() + 0.5 - (double)range, (double)this.source.func_177958_n() + 0.5 + (double)range, (double)this.source.func_177956_o() + 0.5 + (double)range, (double)this.source.func_177952_p() + 0.5 + (double)range), player -> EntityDoppleganger.isTruePlayer((Entity)player) && !player.func_175149_v());
    }

    private static int countGaiaGuardiansAround(World world, BlockPos source) {
        float range = 15.0f;
        List l = world.func_217357_a(EntityDoppleganger.class, new AxisAlignedBB((double)source.func_177958_n() + 0.5 - (double)range, (double)source.func_177956_o() + 0.5 - (double)range, (double)source.func_177952_p() + 0.5 - (double)range, (double)source.func_177958_n() + 0.5 + (double)range, (double)source.func_177956_o() + 0.5 + (double)range, (double)source.func_177952_p() + 0.5 + (double)range));
        return l.size();
    }

    private void particles() {
        float rad;
        for (int i = 0; i < 360; i += 8) {
            float r = 0.6f;
            float g = 0.0f;
            float b = 0.2f;
            float m = 0.15f;
            float mv = 0.35f;
            rad = (float)i * (float)Math.PI / 180.0f;
            double x = (double)this.source.func_177958_n() + 0.5 - Math.cos(rad) * 12.0;
            double y = (double)this.source.func_177956_o() + 0.5;
            double z = (double)this.source.func_177952_p() + 0.5 - Math.sin(rad) * 12.0;
            WispParticleData data = WispParticleData.wisp(0.5f, r, g, b);
            this.field_70170_p.func_195594_a((IParticleData)data, x, y, z, (double)((float)(Math.random() - 0.5) * m), (double)((float)(Math.random() - 0.5) * mv), (double)((float)(Math.random() - 0.5) * m));
        }
        if (this.getInvulTime() > 10) {
            Vector3 pos = Vector3.fromEntityCenter((Entity)this).subtract(new Vector3(0.0, 0.2, 0.0));
            for (BlockPos arr : PYLON_LOCATIONS) {
                Vector3 pylonPos = new Vector3(this.source.func_177958_n() + arr.func_177958_n(), this.source.func_177956_o() + arr.func_177956_o(), this.source.func_177952_p() + arr.func_177952_p());
                double worldTime = this.field_70173_aa;
                rad = 0.75f + (float)Math.random() * 0.05f;
                double xp = pylonPos.x + 0.5 + Math.cos(worldTime /= 5.0) * (double)rad;
                double zp = pylonPos.z + 0.5 + Math.sin(worldTime) * (double)rad;
                Vector3 partPos = new Vector3(xp, pylonPos.y, zp);
                Vector3 mot = pos.subtract(partPos).multiply(0.04);
                float r = 0.7f + (float)Math.random() * 0.3f;
                float g = (float)Math.random() * 0.3f;
                float b = 0.7f + (float)Math.random() * 0.3f;
                WispParticleData data = WispParticleData.wisp(0.25f + (float)Math.random() * 0.1f, r, g, b, 1.0f);
                this.field_70170_p.func_195594_a((IParticleData)data, partPos.x, partPos.y, partPos.z, 0.0, (double)(-(-0.075f - (float)Math.random() * 0.015f)), 0.0);
                WispParticleData data1 = WispParticleData.wisp(0.4f, r, g, b);
                this.field_70170_p.func_195594_a((IParticleData)data1, partPos.x, partPos.y, partPos.z, (double)((float)mot.x), (double)((float)mot.y), (double)((float)mot.z));
            }
        }
    }

    private void smashBlocksAround(int centerX, int centerY, int centerZ, int radius) {
        for (int dx = -radius; dx <= radius; ++dx) {
            for (int dy = -radius; dy <= radius + 1; ++dy) {
                for (int dz = -radius; dz <= radius; ++dz) {
                    int x = centerX + dx;
                    int y = centerY + dy;
                    int z = centerZ + dz;
                    BlockPos pos = new BlockPos(x, y, z);
                    BlockState state = this.field_70170_p.func_180495_p(pos);
                    Block block = state.func_177230_c();
                    if (state.func_185887_b((IBlockReader)this.field_70170_p, pos) == -1.0f) continue;
                    if (CHEATY_BLOCKS.contains(Registry.field_212618_g.func_177774_c((Object)block))) {
                        this.field_70170_p.func_175655_b(pos, true);
                        continue;
                    }
                    if (BLACKLIST.func_230235_a_((Object)block) || y < this.source.func_177956_o() || Math.abs(this.source.func_177958_n() - x) == 4 && Math.abs(this.source.func_177952_p() - z) == 4) continue;
                    this.field_70170_p.func_175655_b(pos, true);
                }
            }
        }
    }

    private void clearPotions(PlayerEntity player) {
        List<Effect> potionsToRemove = player.func_70651_bq().stream().filter(effect -> effect.func_76459_b() < 160 && effect.func_82720_e() && effect.func_188419_a().func_220303_e() != EffectType.HARMFUL).map(EffectInstance::func_188419_a).distinct().collect(Collectors.toList());
        potionsToRemove.forEach(potion -> {
            player.func_195063_d(potion);
            ((ServerWorld)this.field_70170_p).func_72863_F().func_217216_a((Entity)player, (IPacket)new SRemoveEntityEffectPacket(player.func_145782_y(), potion));
        });
    }

    private void keepInsideArena(PlayerEntity player) {
        if (MathHelper.pointDistanceSpace(player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), (double)this.source.func_177958_n() + 0.5, (double)this.source.func_177956_o() + 0.5, (double)this.source.func_177952_p() + 0.5) >= 12.0f) {
            Vector3 sourceVector = new Vector3((double)this.source.func_177958_n() + 0.5, (double)this.source.func_177956_o() + 0.5, (double)this.source.func_177952_p() + 0.5);
            Vector3 playerVector = Vector3.fromEntityCenter((Entity)player);
            Vector3 motion = sourceVector.subtract(playerVector).normalize();
            player.func_213293_j(motion.x, 0.2, motion.z);
            player.field_70133_I = true;
        }
    }

    private void spawnMobs(List<PlayerEntity> players) {
        for (int pl = 0; pl < this.playerCount; ++pl) {
            for (int i = 0; i < 3 + this.field_70170_p.field_73012_v.nextInt(2); ++i) {
                ZombieEntity entity = null;
                switch (this.field_70170_p.field_73012_v.nextInt(3)) {
                    case 0: {
                        entity = new ZombieEntity(this.field_70170_p);
                        if (this.field_70170_p.field_73012_v.nextInt(this.hardMode ? 3 : 12) != 0) break;
                        entity = (MobEntity)EntityType.field_200759_ay.func_200721_a(this.field_70170_p);
                        break;
                    }
                    case 1: {
                        entity = (MobEntity)EntityType.field_200741_ag.func_200721_a(this.field_70170_p);
                        if (this.field_70170_p.field_73012_v.nextInt(8) != 0) break;
                        entity = (MobEntity)EntityType.field_200722_aA.func_200721_a(this.field_70170_p);
                        break;
                    }
                    case 2: {
                        if (players.isEmpty()) break;
                        for (int j = 0; j < 1 + this.field_70170_p.field_73012_v.nextInt(this.hardMode ? 8 : 5); ++j) {
                            EntityPixie pixie = new EntityPixie(this.field_70170_p);
                            pixie.setProps((LivingEntity)players.get(this.field_70146_Z.nextInt(players.size())), (LivingEntity)this, 1, 8.0f);
                            pixie.func_70107_b(this.func_226277_ct_() + (double)(this.func_213311_cf() / 2.0f), this.func_226278_cu_() + 2.0, this.func_226281_cx_() + (double)(this.func_213311_cf() / 2.0f));
                            pixie.func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(pixie.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                            this.field_70170_p.func_217376_c((Entity)pixie);
                        }
                        break;
                    }
                }
                if (entity == null) continue;
                if (!entity.func_230279_az_()) {
                    entity.func_195064_c(new EffectInstance(Effects.field_76426_n, 600, 0));
                }
                float range = 6.0f;
                entity.func_70107_b(this.func_226277_ct_() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f), this.func_226278_cu_() - 1.0, this.func_226281_cx_() + 0.5 + Math.random() * (double)range - (double)(range / 2.0f));
                entity.func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(entity.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                if (entity instanceof WitherSkeletonEntity && this.hardMode) {
                    entity.func_184201_a(EquipmentSlotType.MAINHAND, new ItemStack((IItemProvider)ModItems.elementiumSword));
                }
                this.field_70170_p.func_217376_c((Entity)entity);
            }
        }
    }

    public void func_70636_d() {
        boolean spawnMissiles;
        super.func_70636_d();
        int invul = this.getInvulTime();
        if (this.field_70170_p.field_72995_K) {
            this.particles();
            PlayerEntity player = Botania.proxy.getClientPlayer();
            if (this.getPlayersAround().contains(player)) {
                player.field_71075_bZ.field_75100_b &= player.field_71075_bZ.field_75098_d;
            }
            return;
        }
        this.bossInfo.func_186735_a(this.func_110143_aJ() / this.func_110138_aP());
        if (this.func_184218_aH()) {
            this.func_184210_p();
        }
        if (this.field_70170_p.func_175659_aa() == Difficulty.PEACEFUL) {
            this.func_70106_y();
        }
        this.smashBlocksAround(net.minecraft.util.math.MathHelper.func_76128_c((double)this.func_226277_ct_()), net.minecraft.util.math.MathHelper.func_76128_c((double)this.func_226278_cu_()), net.minecraft.util.math.MathHelper.func_76128_c((double)this.func_226281_cx_()), 1);
        List<PlayerEntity> players = this.getPlayersAround();
        if (players.isEmpty() && !this.field_70170_p.func_217369_A().isEmpty()) {
            this.func_70106_y();
        } else {
            for (PlayerEntity player : players) {
                for (EquipmentSlotType e : EquipmentSlotType.values()) {
                    if (e.func_188453_a() != EquipmentSlotType.Group.ARMOR || player.func_184582_a(e).func_190926_b()) continue;
                    this.anyWithArmor = true;
                    break;
                }
                if (player.func_70608_bn()) {
                    player.func_213366_dy();
                }
                this.clearPotions(player);
                this.keepInsideArena(player);
                player.field_71075_bZ.field_75100_b &= player.field_71075_bZ.field_75098_d;
            }
        }
        if (!this.func_70089_S() || players.isEmpty()) {
            return;
        }
        boolean bl = spawnMissiles = this.hardMode && this.field_70173_aa % 15 < 4;
        if (invul > 0 && this.mobSpawnTicks == 900) {
            if (invul < 160 && invul > 80 && this.field_70170_p.field_73012_v.nextInt(160 - invul + 1) == 0) {
                for (int i = 0; i < 2; ++i) {
                    this.func_70656_aK();
                }
            }
            this.func_70606_j(this.func_110143_aJ() + (this.func_110138_aP() - 1.0f) / 160.0f);
            this.setInvulTime(invul - 1);
            this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.0, this.func_213322_ci().func_82616_c());
        } else if (this.aggro) {
            int i;
            boolean dying;
            boolean bl2 = dying = (double)(this.func_110143_aJ() / this.func_110138_aP()) < 0.2;
            if (dying && this.mobSpawnTicks > 0) {
                this.func_213317_d(Vector3d.field_186680_a);
                int reverseTicks = 900 - this.mobSpawnTicks;
                if (reverseTicks < 20) {
                    this.func_213293_j(this.func_213322_ci().func_82615_a(), 0.2, this.func_213322_ci().func_82616_c());
                    this.setInvulTime(invul + 1);
                }
                if (reverseTicks > 40 && this.mobSpawnTicks > 80 && this.mobSpawnTicks % 80 == 0) {
                    this.spawnMobs(players);
                    if (this.hardMode && this.field_70173_aa % 3 < 2) {
                        for (i = 0; i < this.playerCount; ++i) {
                            this.spawnMissile();
                        }
                        spawnMissiles = false;
                    }
                }
                --this.mobSpawnTicks;
                this.tpDelay = 10;
            } else if (this.tpDelay > 0) {
                if (invul > 0) {
                    this.setInvulTime(invul - 1);
                }
                --this.tpDelay;
                if (this.tpDelay == 0 && this.func_110143_aJ() > 0.0f) {
                    this.teleportRandomly();
                    if (this.spawnLandmines) {
                        int count = dying && this.hardMode ? 7 : 6;
                        for (i = 0; i < count; ++i) {
                            int x = this.source.func_177958_n() - 10 + this.field_70146_Z.nextInt(20);
                            int y = (int)players.get(this.field_70146_Z.nextInt(players.size())).func_226278_cu_();
                            int z = this.source.func_177952_p() - 10 + this.field_70146_Z.nextInt(20);
                            EntityMagicLandmine landmine = (EntityMagicLandmine)ModEntities.MAGIC_LANDMINE.func_200721_a(this.field_70170_p);
                            landmine.func_70107_b((double)x + 0.5, y, (double)z + 0.5);
                            landmine.summoner = this;
                            this.field_70170_p.func_217376_c((Entity)landmine);
                        }
                    }
                    for (int pl = 0; pl < this.playerCount; ++pl) {
                        for (i = 0; i < (this.spawnPixies ? this.field_70170_p.field_73012_v.nextInt(this.hardMode ? 6 : 3) : 1); ++i) {
                            EntityPixie pixie = new EntityPixie(this.field_70170_p);
                            pixie.setProps((LivingEntity)players.get(this.field_70146_Z.nextInt(players.size())), (LivingEntity)this, 1, 8.0f);
                            pixie.func_70107_b(this.func_226277_ct_() + (double)(this.func_213311_cf() / 2.0f), this.func_226278_cu_() + 2.0, this.func_226281_cx_() + (double)(this.func_213311_cf() / 2.0f));
                            pixie.func_213386_a((IServerWorld)((ServerWorld)this.field_70170_p), this.field_70170_p.func_175649_E(pixie.func_233580_cy_()), SpawnReason.MOB_SUMMONED, null, null);
                            this.field_70170_p.func_217376_c((Entity)pixie);
                        }
                    }
                    this.tpDelay = this.hardMode ? (dying ? 35 : 45) : (dying ? 40 : 60);
                    this.spawnLandmines = true;
                    this.spawnPixies = false;
                }
            }
            if (spawnMissiles) {
                this.spawnMissile();
            }
        } else {
            this.func_70665_d(DamageSource.func_76365_a((PlayerEntity)players.get(0)), 0.0f);
        }
    }

    public boolean func_184222_aU() {
        return false;
    }

    public void func_184178_b(ServerPlayerEntity player) {
        super.func_184178_b(player);
        this.bossInfo.func_186760_a(player);
    }

    public void func_184203_c(ServerPlayerEntity player) {
        super.func_184203_c(player);
        this.bossInfo.func_186761_b(player);
    }

    protected void func_85033_bc() {
        if (this.getInvulTime() == 0) {
            super.func_85033_bc();
        }
    }

    public boolean func_70104_M() {
        return super.func_70104_M() && this.getInvulTime() == 0;
    }

    private void spawnMissile() {
        EntityMagicMissile missile = new EntityMagicMissile((LivingEntity)this, true);
        missile.func_70107_b(this.func_226277_ct_() + (Math.random() - 0.05), this.func_226278_cu_() + 2.4 + (Math.random() - 0.05), this.func_226281_cx_() + (Math.random() - 0.05));
        if (missile.findTarget()) {
            this.func_184185_a(ModSounds.missile, 0.6f, 0.8f + (float)Math.random() * 0.2f);
            this.field_70170_p.func_217376_c((Entity)missile);
        }
    }

    private void teleportRandomly() {
        Vector3d newPosVec;
        BlockPos tentativeFloorPos;
        double newZ;
        double newX;
        double oldX = this.func_226277_ct_();
        double oldY = this.func_226278_cu_();
        double oldZ = this.func_226281_cx_();
        double newY = this.source.func_177956_o();
        int tries = 0;
        do {
            newX = (double)this.source.func_177958_n() + (this.field_70146_Z.nextDouble() - 0.5) * 12.0;
            newZ = (double)this.source.func_177952_p() + (this.field_70146_Z.nextDouble() - 0.5) * 12.0;
        } while (++tries < 50 && MathHelper.pointDistanceSpace(newX, newY, newZ, this.source.func_177958_n(), this.source.func_177956_o(), this.source.func_177952_p()) > 12.0f);
        if (tries == 50) {
            newX = (double)this.source.func_177958_n() + 0.5;
            newY = (double)this.source.func_177956_o() + 1.6;
            newZ = (double)this.source.func_177952_p() + 0.5;
        }
        if (this.field_70170_p.func_180495_p(tentativeFloorPos = new BlockPos(newX, newY - 1.0, newZ)).func_196952_d((IBlockReader)this.field_70170_p, tentativeFloorPos).func_197766_b()) {
            newY -= 1.0;
        }
        this.func_70634_a(newX, newY, newZ);
        this.field_70170_p.func_184148_a(null, oldX, oldY, oldZ, SoundEvents.field_187534_aX, this.func_184176_by(), 1.0f, 1.0f);
        this.func_184185_a(SoundEvents.field_187534_aX, 1.0f, 1.0f);
        Random random = this.func_70681_au();
        int particleCount = 128;
        for (int i = 0; i < particleCount; ++i) {
            double progress = (double)i / (double)(particleCount - 1);
            float vx = (random.nextFloat() - 0.5f) * 0.2f;
            float vy = (random.nextFloat() - 0.5f) * 0.2f;
            float vz = (random.nextFloat() - 0.5f) * 0.2f;
            double px = oldX + (newX - oldX) * progress + (random.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            double py = oldY + (newY - oldY) * progress + random.nextDouble() * (double)this.func_213302_cg();
            double pz = oldZ + (newZ - oldZ) * progress + (random.nextDouble() - 0.5) * (double)this.func_213311_cf() * 2.0;
            this.field_70170_p.func_195594_a((IParticleData)ParticleTypes.field_197599_J, px, py, pz, (double)vx, (double)vy, (double)vz);
        }
        Vector3d oldPosVec = new Vector3d(oldX, oldY + (double)(this.func_213302_cg() / 2.0f), oldZ);
        if (oldPosVec.func_72436_e(newPosVec = new Vector3d(newX, newY + (double)(this.func_213302_cg() / 2.0f), newZ)) > 1.0) {
            for (PlayerEntity player : this.getPlayersAround()) {
                boolean hit = player.func_174813_aQ().func_186662_g(0.25).func_216365_b(oldPosVec, newPosVec).isPresent();
                if (!hit) continue;
                player.func_70097_a(DamageSource.func_76358_a((LivingEntity)this), 6.0f);
            }
            int breakSteps = (int)oldPosVec.func_72438_d(newPosVec);
            if (breakSteps >= 2) {
                for (int i = 0; i < breakSteps; ++i) {
                    float progress = (float)i / (float)(breakSteps - 1);
                    int breakX = net.minecraft.util.math.MathHelper.func_76128_c((double)(oldX + (newX - oldX) * (double)progress));
                    int breakY = net.minecraft.util.math.MathHelper.func_76128_c((double)(oldY + (newY - oldY) * (double)progress));
                    int breakZ = net.minecraft.util.math.MathHelper.func_76128_c((double)(oldZ + (newZ - oldZ) * (double)progress));
                    this.smashBlocksAround(breakX, breakY, breakZ, 1);
                }
            }
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public ResourceLocation getBossBarTexture() {
        return BossBarHandler.defaultBossBar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rectangle2d getBossBarTextureRect() {
        return new Rectangle2d(0, 0, 185, 15);
    }

    @OnlyIn(value=Dist.CLIENT)
    public Rectangle2d getBossBarHPTextureRect() {
        Rectangle2d barRect = this.getBossBarTextureRect();
        return new Rectangle2d(0, barRect.func_199319_b() + barRect.func_199317_d(), 181, 7);
    }

    @OnlyIn(value=Dist.CLIENT)
    public int bossBarRenderCallback(MatrixStack ms, int x, int y) {
        ms.func_227860_a_();
        int px = x + 160;
        int py = y + 12;
        Minecraft mc = Minecraft.func_71410_x();
        ItemStack stack = new ItemStack((IItemProvider)Items.field_196184_dx);
        mc.func_175599_af().func_175042_a(stack, px, py);
        mc.field_71466_p.func_238405_a_(ms, Integer.toString(this.playerCount), (float)(px + 15), (float)(py + 4), 0xFFFFFF);
        ms.func_227865_b_();
        return 5;
    }

    public UUID getBossInfoUuid() {
        return this.bossInfoUUID;
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public ShaderHelper.BotaniaShader getBossBarShaderProgram(boolean background) {
        return background ? null : ShaderHelper.BotaniaShader.DOPPLEGANGER_BAR;
    }

    @OnlyIn(value=Dist.CLIENT)
    public ShaderCallback getBossBarShaderCallback(boolean background) {
        if (this.shaderCallback == null) {
            this.shaderCallback = shader1 -> {
                int grainIntensityUniform = GlStateManager.func_227680_b_((int)shader1, (CharSequence)"grainIntensity");
                int hpFractUniform = GlStateManager.func_227680_b_((int)shader1, (CharSequence)"hpFract");
                float time = this.getInvulTime();
                float grainIntensity = time > 20.0f ? 1.0f : Math.max(this.hardMode ? 0.5f : 0.0f, time / 20.0f);
                ShaderHelper.FLOAT_BUF.position(0);
                ShaderHelper.FLOAT_BUF.put(0, grainIntensity);
                RenderSystem.glUniform1((int)grainIntensityUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
                ShaderHelper.FLOAT_BUF.position(0);
                ShaderHelper.FLOAT_BUF.put(0, this.func_110143_aJ() / this.func_110138_aP());
                RenderSystem.glUniform1((int)hpFractUniform, (FloatBuffer)ShaderHelper.FLOAT_BUF);
            };
        }
        return background ? null : this.shaderCallback;
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.playerCount);
        buffer.writeBoolean(this.hardMode);
        buffer.writeLong(this.source.func_218275_a());
        buffer.writeLong(this.bossInfoUUID.getMostSignificantBits());
        buffer.writeLong(this.bossInfoUUID.getLeastSignificantBits());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readSpawnData(PacketBuffer additionalData) {
        this.playerCount = additionalData.readInt();
        this.hardMode = additionalData.readBoolean();
        this.source = BlockPos.func_218283_e((long)additionalData.readLong());
        long msb = additionalData.readLong();
        long lsb = additionalData.readLong();
        this.bossInfoUUID = new UUID(msb, lsb);
        Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new DopplegangerMusic(this));
    }

    @Nonnull
    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_184652_a(PlayerEntity player) {
        return false;
    }

    @OnlyIn(value=Dist.CLIENT)
    private static class DopplegangerMusic
    extends TickableSound {
        private final EntityDoppleganger guardian;

        public DopplegangerMusic(EntityDoppleganger guardian) {
            super(guardian.hardMode ? ModSounds.gaiaMusic2 : ModSounds.gaiaMusic1, SoundCategory.RECORDS);
            this.guardian = guardian;
            this.field_147660_d = guardian.getSource().func_177958_n();
            this.field_147661_e = guardian.getSource().func_177956_o();
            this.field_147658_f = guardian.getSource().func_177952_p();
        }

        public void func_73660_a() {
            if (!this.guardian.func_70089_S()) {
                this.func_239509_o_();
            }
        }
    }
}

