/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.integration.curios;

import com.google.common.collect.Multimap;
import com.mojang.blaze3d.matrix.MatrixStack;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.IEntityRenderer;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.client.renderer.entity.model.EntityModel;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.items.IItemHandlerModifiable;
import org.apache.commons.lang3.tuple.ImmutableTriple;
import top.theillusivec4.curios.api.CuriosApi;
import top.theillusivec4.curios.api.CuriosCapability;
import top.theillusivec4.curios.api.SlotTypePreset;
import top.theillusivec4.curios.api.event.DropRulesEvent;
import top.theillusivec4.curios.api.type.capability.ICurio;
import vazkii.botania.common.capability.SimpleCapProvider;
import vazkii.botania.common.core.handler.EquipmentHandler;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.item.ItemKeepIvy;
import vazkii.botania.common.item.equipment.bauble.ItemBauble;

public class CurioIntegration
extends EquipmentHandler {
    public static void sendImc(InterModEnqueueEvent evt) {
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.CHARM.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.RING.getMessageBuilder().size(2).build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BELT.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.BODY.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.HEAD.getMessageBuilder().build());
        InterModComms.sendTo((String)"curios", (String)"register_type", () -> SlotTypePreset.NECKLACE.getMessageBuilder().build());
    }

    public static void keepCurioDrops(DropRulesEvent event) {
        event.addOverride(stack -> {
            if (ItemKeepIvy.hasIvy(stack)) {
                stack.func_196083_e("Botania_keepIvy");
                return true;
            }
            return false;
        }, ICurio.DropRule.ALWAYS_KEEP);
    }

    @Override
    protected LazyOptional<IItemHandlerModifiable> getAllWornItems(LivingEntity living) {
        return CuriosApi.getCuriosHelper().getEquippedCurios(living);
    }

    @Override
    protected ItemStack findItem(Item item, LivingEntity living) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(item, living).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
    }

    @Override
    protected ItemStack findItem(Predicate<ItemStack> pred, LivingEntity living) {
        return CuriosApi.getCuriosHelper().findEquippedCurio(pred, living).map(ImmutableTriple::getRight).orElse(ItemStack.field_190927_a);
    }

    @Override
    protected ICapabilityProvider initCap(ItemStack stack) {
        return new SimpleCapProvider<Wrapper>(CuriosCapability.ITEM, new Wrapper(stack));
    }

    @Override
    public boolean isAccessory(ItemStack stack) {
        return super.isAccessory(stack) || stack.getCapability(CuriosCapability.ITEM).isPresent();
    }

    public static class Wrapper
    implements ICurio {
        private final ItemStack stack;

        Wrapper(ItemStack stack) {
            this.stack = stack;
        }

        private ItemBauble getItem() {
            return (ItemBauble)this.stack.func_77973_b();
        }

        public void curioTick(String identifier, int index, LivingEntity entity) {
            this.getItem().onWornTick(this.stack, entity);
        }

        public void onEquip(String identifier, int index, LivingEntity entity) {
            this.getItem().onEquipped(this.stack, entity);
        }

        public void onUnequip(String identifier, int index, LivingEntity entity) {
            this.getItem().onUnequipped(this.stack, entity);
        }

        public boolean canEquip(String identifier, LivingEntity entity) {
            return this.getItem().canEquip(this.stack, entity);
        }

        public Multimap<Attribute, AttributeModifier> getAttributeModifiers(String identifier) {
            return this.getItem().getEquippedAttributeModifiers(this.stack);
        }

        public boolean canSync(String identifier, int index, LivingEntity livingEntity) {
            return true;
        }

        public void playRightClickEquipSound(LivingEntity entity) {
            entity.field_70170_p.func_184148_a(null, entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), ModSounds.equipBauble, entity.func_184176_by(), 0.1f, 1.3f);
        }

        public boolean canRightClickEquip() {
            return true;
        }

        public boolean canRender(String identifier, int index, LivingEntity entity) {
            return this.getItem().hasRender(this.stack, entity);
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(String identifier, int index, MatrixStack matrixStack, IRenderTypeBuffer renderTypeBuffer, int light, LivingEntity livingEntity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch) {
            EntityRenderer renderer = Minecraft.func_71410_x().func_175598_ae().func_78713_a((Entity)livingEntity);
            if (!(renderer instanceof IEntityRenderer)) {
                return;
            }
            EntityModel model = ((IEntityRenderer)renderer).func_217764_d();
            if (!(model instanceof BipedModel)) {
                return;
            }
            ItemStack cosmetic = this.getItem().getCosmeticItem(this.stack);
            if (!cosmetic.func_190926_b()) {
                cosmetic.getCapability(CuriosCapability.ITEM).ifPresent(curio -> curio.render(identifier, index, matrixStack, renderTypeBuffer, light, livingEntity, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch));
            } else {
                this.getItem().doRender((BipedModel)model, this.stack, livingEntity, matrixStack, renderTypeBuffer, light, limbSwing, limbSwingAmount, partialTicks, ageInTicks, netHeadYaw, headPitch);
            }
        }
    }
}

