/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ItemUseContext;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.NBTUtil;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Direction;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.item.IBlockProvider;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.client.core.handler.ItemsRemainingRenderHandler;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.item.equipment.tool.ToolCommons;
import vazkii.botania.common.item.rod.ItemExchangeRod;

public class ItemAstrolabe
extends Item {
    private static final String TAG_BLOCKSTATE = "blockstate";
    private static final String TAG_SIZE = "size";

    public ItemAstrolabe(Item.Properties props) {
        super(props);
    }

    @Nonnull
    public ActionResultType func_195939_a(ItemUseContext ctx) {
        ItemStack stack = ctx.func_195996_i();
        BlockState state = ctx.func_195991_k().func_180495_p(ctx.func_195995_a());
        PlayerEntity player = ctx.func_195999_j();
        if (player != null && player.func_225608_bj_()) {
            if (this.setBlock(stack, state)) {
                this.displayRemainderCounter(player, stack);
                return ActionResultType.SUCCESS;
            }
        } else if (player != null) {
            boolean did = this.placeAllBlocks(stack, player);
            if (did) {
                this.displayRemainderCounter(player, stack);
            }
            return did ? ActionResultType.SUCCESS : ActionResultType.FAIL;
        }
        return ActionResultType.PASS;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand hand) {
        ItemStack stack = playerIn.func_184586_b(hand);
        if (playerIn.func_225608_bj_()) {
            playerIn.func_184185_a(SoundEvents.field_187604_bf, 0.5f, 1.0f);
            if (!worldIn.field_72995_K) {
                int size = ItemAstrolabe.getSize(stack);
                int newSize = size == 11 ? 3 : size + 2;
                ItemAstrolabe.setSize(stack, newSize);
                ItemsRemainingRenderHandler.send(playerIn, stack, 0, (ITextComponent)new StringTextComponent(newSize + "x" + newSize));
            }
            return ActionResult.func_226248_a_((Object)stack);
        }
        return ActionResult.func_226250_c_((Object)stack);
    }

    public boolean placeAllBlocks(ItemStack stack, PlayerEntity player) {
        List<BlockPos> blocksToPlace = ItemAstrolabe.getBlocksToPlace(stack, player);
        if (!ItemAstrolabe.hasBlocks(stack, player, blocksToPlace)) {
            return false;
        }
        int size = ItemAstrolabe.getSize(stack);
        int cost = size * 320;
        if (!ManaItemHandler.instance().requestManaExact(stack, player, cost, false)) {
            return false;
        }
        ItemStack stackToPlace = new ItemStack((IItemProvider)ItemAstrolabe.getBlock(stack));
        for (BlockPos coords : blocksToPlace) {
            this.placeBlockAndConsume(player, stack, stackToPlace, coords);
        }
        ManaItemHandler.instance().requestManaExact(stack, player, cost, true);
        return true;
    }

    private void placeBlockAndConsume(PlayerEntity player, ItemStack requestor, ItemStack blockToPlace, BlockPos coords) {
        if (blockToPlace.func_190926_b()) {
            return;
        }
        Block block = Block.func_149634_a((Item)blockToPlace.func_77973_b());
        BlockState state = block.func_176223_P();
        player.field_70170_p.func_175656_a(coords, state);
        player.field_70170_p.func_217379_c(2001, coords, Block.func_196246_j((BlockState)state));
        if (player.field_71075_bZ.field_75098_d) {
            return;
        }
        ArrayList<ItemStack> stacksToCheck = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_77973_b() == blockToPlace.func_77973_b()) {
                stackInSlot.func_190918_g(1);
                return;
            }
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IBlockProvider)) continue;
            stacksToCheck.add(stackInSlot);
        }
        for (ItemStack providerStack : stacksToCheck) {
            IBlockProvider prov = (IBlockProvider)providerStack.func_77973_b();
            if (!prov.provideBlock(player, requestor, providerStack, block, false)) continue;
            prov.provideBlock(player, requestor, providerStack, block, true);
            return;
        }
    }

    public static boolean hasBlocks(ItemStack stack, PlayerEntity player, List<BlockPos> blocks) {
        if (player.field_71075_bZ.field_75098_d) {
            return true;
        }
        Block block = ItemAstrolabe.getBlock(stack);
        ItemStack reqStack = new ItemStack((IItemProvider)block);
        int required = blocks.size();
        int current = 0;
        ArrayList<ItemStack> stacksToCheck = new ArrayList<ItemStack>();
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack stackInSlot = player.field_71071_by.func_70301_a(i);
            if (!stackInSlot.func_190926_b() && stackInSlot.func_77973_b() == reqStack.func_77973_b() && (current += stackInSlot.func_190916_E()) >= required) {
                return true;
            }
            if (stackInSlot.func_190926_b() || !(stackInSlot.func_77973_b() instanceof IBlockProvider)) continue;
            stacksToCheck.add(stackInSlot);
        }
        for (ItemStack providerStack : stacksToCheck) {
            IBlockProvider prov = (IBlockProvider)providerStack.func_77973_b();
            int count = prov.getBlockCount(player, stack, providerStack, block);
            if (count == -1) {
                return true;
            }
            if ((current += count) < required) continue;
            return true;
        }
        return false;
    }

    public static List<BlockPos> getBlocksToPlace(ItemStack stack, PlayerEntity player) {
        ArrayList<BlockPos> coords = new ArrayList<BlockPos>();
        BlockRayTraceResult rtr = ToolCommons.raytraceFromEntity((Entity)player, 5.0, true);
        if (rtr.func_216346_c() == RayTraceResult.Type.BLOCK) {
            BlockPos pos = rtr.func_216350_a();
            BlockState state = player.field_70170_p.func_180495_p(pos);
            if (state.func_185904_a().func_76222_j()) {
                pos = pos.func_177977_b();
            }
            int range = (ItemAstrolabe.getSize(stack) ^ 1) / 2;
            Direction dir = rtr.func_216354_b();
            Direction rotationDir = Direction.func_176733_a((double)player.field_70177_z);
            boolean pitchedVertically = Math.abs(player.field_70125_A) > 50.0f;
            boolean axisX = rotationDir.func_176740_k() == Direction.Axis.X;
            boolean axisZ = rotationDir.func_176740_k() == Direction.Axis.Z;
            int xOff = axisZ || pitchedVertically ? range : 0;
            int yOff = pitchedVertically ? 0 : range;
            int zOff = axisX || pitchedVertically ? range : 0;
            for (int x = -xOff; x < xOff + 1; ++x) {
                for (int y = 0; y < yOff * 2 + 1; ++y) {
                    for (int z = -zOff; z < zOff + 1; ++z) {
                        int xp = pos.func_177958_n() + x + dir.func_82601_c();
                        int yp = pos.func_177956_o() + y + dir.func_96559_d();
                        int zp = pos.func_177952_p() + z + dir.func_82599_e();
                        BlockPos newPos = new BlockPos(xp, yp, zp);
                        BlockState state1 = player.field_70170_p.func_180495_p(newPos);
                        if (!player.field_70170_p.func_175723_af().func_177746_a(newPos) || !state1.isAir((IBlockReader)player.field_70170_p, newPos) && !state1.func_185904_a().func_76222_j()) continue;
                        coords.add(newPos);
                    }
                }
            }
        }
        return coords;
    }

    public void displayRemainderCounter(PlayerEntity player, ItemStack stack) {
        Block block = ItemAstrolabe.getBlock(stack);
        int count = ItemExchangeRod.getInventoryItemCount(player, stack, block);
        if (!player.field_70170_p.field_72995_K) {
            ItemsRemainingRenderHandler.send(player, new ItemStack((IItemProvider)block), count);
        }
    }

    private boolean setBlock(ItemStack stack, BlockState state) {
        if (!state.func_196958_f()) {
            ItemNBTHelper.setCompound(stack, TAG_BLOCKSTATE, NBTUtil.func_190009_a((BlockState)state));
            return true;
        }
        return false;
    }

    private static void setSize(ItemStack stack, int size) {
        ItemNBTHelper.setInt(stack, TAG_SIZE, size | 1);
    }

    public static int getSize(ItemStack stack) {
        return ItemNBTHelper.getInt(stack, TAG_SIZE, 3) | 1;
    }

    public static Block getBlock(ItemStack stack) {
        return ItemAstrolabe.getBlockState(stack).func_177230_c();
    }

    public static BlockState getBlockState(ItemStack stack) {
        return NBTUtil.func_190008_d((CompoundNBT)ItemNBTHelper.getCompound(stack, TAG_BLOCKSTATE, false));
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, World world, List<ITextComponent> tip, ITooltipFlag flags) {
        Block block = ItemAstrolabe.getBlock(stack);
        int size = ItemAstrolabe.getSize(stack);
        tip.add((ITextComponent)new StringTextComponent(size + " x " + size));
        if (block != Blocks.field_150350_a) {
            tip.add((ITextComponent)new ItemStack((IItemProvider)block).func_200301_q().func_230531_f_().func_240699_a_(TextFormatting.GRAY));
        }
    }
}

