/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.armor.terrasteel;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.List;
import java.util.UUID;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.entity.model.BipedModel;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.ai.attributes.Attribute;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.ai.attributes.Attributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.LazyValue;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.client.model.armor.ModelArmorTerrasteel;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.armor.manasteel.ItemManasteelArmor;

public class ItemTerrasteelArmor
extends ItemManasteelArmor {
    private static final LazyValue<ItemStack[]> armorSet = new LazyValue(() -> new ItemStack[]{new ItemStack((IItemProvider)ModItems.terrasteelHelm), new ItemStack((IItemProvider)ModItems.terrasteelChest), new ItemStack((IItemProvider)ModItems.terrasteelLegs), new ItemStack((IItemProvider)ModItems.terrasteelBoots)});

    public ItemTerrasteelArmor(EquipmentSlotType type, Item.Properties props) {
        super(type, BotaniaAPI.instance().getTerrasteelArmorMaterial(), props);
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public BipedModel<?> provideArmorModelForSlot(EquipmentSlotType slot) {
        return new ModelArmorTerrasteel(slot);
    }

    @Override
    public String getArmorTextureAfterInk(ItemStack stack, EquipmentSlotType slot) {
        return "botania:textures/model/armor_terrasteel.png";
    }

    @Nonnull
    public Multimap<Attribute, AttributeModifier> func_111205_h(@Nonnull EquipmentSlotType slot) {
        Multimap ret = super.func_111205_h(slot);
        UUID uuid = new UUID(Registry.field_212630_s.func_177774_c((Object)this).hashCode() + slot.toString().hashCode(), 0L);
        if (slot == this.func_185083_B_()) {
            ret = HashMultimap.create((Multimap)ret);
            int reduction = this.field_200882_e.func_200902_b(slot);
            ret.put((Object)Attributes.field_233820_c_, (Object)new AttributeModifier(uuid, "Terrasteel modifier " + this.type, (double)reduction / 20.0, AttributeModifier.Operation.ADDITION));
        }
        return ret;
    }

    @Override
    public ItemStack[] getArmorSetStacks() {
        return (ItemStack[])armorSet.func_179281_c();
    }

    @Override
    public boolean hasArmorSetItem(PlayerEntity player, EquipmentSlotType slot) {
        if (player == null) {
            return false;
        }
        ItemStack stack = player.func_184582_a(slot);
        if (stack.func_190926_b()) {
            return false;
        }
        switch (slot) {
            case HEAD: {
                return stack.func_77973_b() == ModItems.terrasteelHelm;
            }
            case CHEST: {
                return stack.func_77973_b() == ModItems.terrasteelChest;
            }
            case LEGS: {
                return stack.func_77973_b() == ModItems.terrasteelLegs;
            }
            case FEET: {
                return stack.func_77973_b() == ModItems.terrasteelBoots;
            }
        }
        return false;
    }

    @Override
    public IFormattableTextComponent getArmorSetName() {
        return new TranslationTextComponent("botania.armorset.terrasteel.name");
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void addArmorSetDescription(ItemStack stack, List<ITextComponent> list) {
        list.add((ITextComponent)new TranslationTextComponent("botania.armorset.terrasteel.desc0").func_240699_a_(TextFormatting.GRAY));
        list.add((ITextComponent)new TranslationTextComponent("botania.armorset.terrasteel.desc1").func_240699_a_(TextFormatting.GRAY));
        list.add((ITextComponent)new TranslationTextComponent("botania.armorset.terrasteel.desc2").func_240699_a_(TextFormatting.GRAY));
    }

    public boolean makesPiglinsNeutral(ItemStack stack, LivingEntity wearer) {
        return true;
    }
}

