/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool;

import java.util.Arrays;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.block.BlockState;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.enchantment.Enchantments;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.IItemTier;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.ToolItem;
import net.minecraft.util.Hand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.vector.Vector3i;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.mana.ManaItemHandler;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.item.equipment.tool.terrasteel.ItemTerraPick;

public final class ToolCommons {
    public static final List<Material> materialsPick = Arrays.asList(Material.field_151576_e, Material.field_151573_f, Material.field_151588_w, Material.field_151592_s, Material.field_76233_E, Material.field_151574_g, Material.field_215711_w);
    public static final List<Material> materialsShovel = Arrays.asList(Material.field_151577_b, Material.field_151578_c, Material.field_151595_p, Material.field_151597_y, Material.field_151596_z, Material.field_151571_B);
    public static final List<Material> materialsAxe = Arrays.asList(Material.field_151589_v, Material.field_151584_j, Material.field_151585_k, Material.field_151575_d, Material.field_151572_C);
    private static boolean recCall = false;

    public static int damageItemIfPossible(ItemStack stack, int amount, LivingEntity entity, int manaPerDamage) {
        if (!(entity instanceof PlayerEntity)) {
            return amount;
        }
        PlayerEntity player = (PlayerEntity)entity;
        while (amount > 0 && ManaItemHandler.instance().requestManaExactForTool(stack, player, manaPerDamage, true)) {
            --amount;
        }
        return amount;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void removeBlocksInIteration(PlayerEntity player, ItemStack stack, World world, BlockPos centerPos, Vector3i startDelta, Vector3i endDelta, Predicate<BlockState> filter) {
        if (recCall) {
            return;
        }
        recCall = true;
        try {
            for (BlockPos iterPos : BlockPos.func_218278_a((BlockPos)centerPos.func_177971_a(startDelta), (BlockPos)centerPos.func_177971_a(endDelta))) {
                if (iterPos.equals((Object)centerPos)) continue;
                ToolCommons.removeBlockWithDrops(player, stack, world, iterPos, filter);
            }
        }
        finally {
            recCall = false;
        }
    }

    public static void removeBlockWithDrops(PlayerEntity player, ItemStack stack, World world, BlockPos pos, Predicate<BlockState> filter) {
        boolean unminable;
        if (!world.func_175667_e(pos)) {
            return;
        }
        BlockState blockstate = world.func_180495_p(pos);
        boolean bl = unminable = blockstate.func_185903_a(player, (IBlockReader)world, pos) == 0.0f;
        if (!world.field_72995_K && !unminable && filter.test(blockstate) && !blockstate.isAir((IBlockReader)world, pos)) {
            ItemStack save = player.func_184614_ca();
            player.func_184611_a(Hand.MAIN_HAND, stack);
            ((ServerPlayerEntity)player).field_71134_c.func_180237_b(pos);
            player.func_184611_a(Hand.MAIN_HAND, save);
        }
    }

    public static int getToolPriority(ItemStack stack) {
        if (stack.func_190926_b()) {
            return 0;
        }
        Item item = stack.func_77973_b();
        if (!(item instanceof ToolItem)) {
            return 0;
        }
        ToolItem tool = (ToolItem)item;
        IItemTier material = tool.func_200891_e();
        int materialLevel = 0;
        if (material == BotaniaAPI.instance().getManasteelItemTier()) {
            materialLevel = 10;
        }
        if (material == BotaniaAPI.instance().getElementiumItemTier()) {
            materialLevel = 11;
        }
        if (material == BotaniaAPI.instance().getTerrasteelItemTier()) {
            materialLevel = 20;
        }
        int modifier = 0;
        if (item == ModItems.terraPick) {
            modifier = ItemTerraPick.getLevel(stack);
        }
        int efficiency = EnchantmentHelper.func_77506_a((Enchantment)Enchantments.field_185305_q, (ItemStack)stack);
        return materialLevel * 100 + modifier * 10 + efficiency;
    }

    public static BlockRayTraceResult raytraceFromEntity(Entity e, double distance, boolean fluids) {
        return (BlockRayTraceResult)e.func_213324_a(distance, 1.0f, fluids);
    }
}

