/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.item.equipment.tool.terrasteel;

import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.projectile.ThrowableEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.AttackEntityEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import vazkii.botania.api.BotaniaAPI;
import vazkii.botania.api.internal.IManaBurst;
import vazkii.botania.api.mana.BurstProperties;
import vazkii.botania.api.mana.ILensEffect;
import vazkii.botania.common.core.handler.ModSounds;
import vazkii.botania.common.entity.EntityManaBurst;
import vazkii.botania.common.item.equipment.tool.manasteel.ItemManasteelSword;
import vazkii.botania.common.network.PacketHandler;
import vazkii.botania.common.network.PacketLeftClick;

public class ItemTerraSword
extends ItemManasteelSword
implements ILensEffect {
    private static final int MANA_PER_DAMAGE = 100;

    public ItemTerraSword(Item.Properties props) {
        super(BotaniaAPI.instance().getTerrasteelItemTier(), props);
        MinecraftForge.EVENT_BUS.addListener(this::leftClick);
        MinecraftForge.EVENT_BUS.addListener(this::attackEntity);
    }

    private void leftClick(PlayerInteractEvent.LeftClickEmpty evt) {
        if (!evt.getItemStack().func_190926_b() && evt.getItemStack().func_77973_b() == this) {
            PacketHandler.sendToServer(new PacketLeftClick());
        }
    }

    private void attackEntity(AttackEntityEvent evt) {
        if (!evt.getPlayer().field_70170_p.field_72995_K) {
            this.trySpawnBurst(evt.getPlayer());
        }
    }

    public void trySpawnBurst(PlayerEntity player) {
        if (!player.func_184614_ca().func_190926_b() && player.func_184614_ca().func_77973_b() == this && player.func_184825_o(0.0f) == 1.0f) {
            EntityManaBurst burst = this.getBurst(player, player.func_184614_ca());
            player.field_70170_p.func_217376_c((Entity)burst);
            player.func_184614_ca().func_222118_a(1, (LivingEntity)player, p -> p.func_213334_d(Hand.MAIN_HAND));
            player.field_70170_p.func_184148_a(null, player.func_226277_ct_(), player.func_226278_cu_(), player.func_226281_cx_(), ModSounds.terraBlade, SoundCategory.PLAYERS, 0.4f, 1.4f);
        }
    }

    @Override
    public int getManaPerDamage() {
        return 100;
    }

    public EntityManaBurst getBurst(PlayerEntity player, ItemStack stack) {
        EntityManaBurst burst = new EntityManaBurst(player);
        float motionModifier = 7.0f;
        burst.setColor(0x20FF20);
        burst.setMana(100);
        burst.setStartingMana(100);
        burst.setMinManaLoss(40);
        burst.setManaLossPerTick(4.0f);
        burst.setGravity(0.0f);
        burst.setBurstMotion(burst.func_213322_ci().func_82615_a() * (double)motionModifier, burst.func_213322_ci().func_82617_b() * (double)motionModifier, burst.func_213322_ci().func_82616_c() * (double)motionModifier);
        burst.setSourceLens(stack.func_77946_l());
        return burst;
    }

    @Override
    public void apply(ItemStack stack, BurstProperties props) {
    }

    @Override
    public boolean collideBurst(IManaBurst burst, RayTraceResult pos, boolean isManaBlock, boolean dead, ItemStack stack) {
        return dead;
    }

    @Override
    public void updateBurst(IManaBurst burst, ItemStack stack) {
        ThrowableEntity entity = burst.entity();
        AxisAlignedBB axis = new AxisAlignedBB(entity.func_226277_ct_(), entity.func_226278_cu_(), entity.func_226281_cx_(), entity.field_70142_S, entity.field_70137_T, entity.field_70136_U).func_186662_g(1.0);
        List entities = entity.field_70170_p.func_217357_a(LivingEntity.class, axis);
        Entity thrower = entity.func_234616_v_();
        for (LivingEntity living : entities) {
            if (living == thrower || living instanceof PlayerEntity && thrower instanceof PlayerEntity && !((PlayerEntity)thrower).func_96122_a((PlayerEntity)living) || living.field_70737_aN != 0) continue;
            int cost = 33;
            int mana = burst.getMana();
            if (mana < cost) continue;
            burst.setMana(mana - cost);
            float damage = 4.0f + BotaniaAPI.instance().getTerrasteelItemTier().func_200929_c();
            if (burst.isFake() || entity.field_70170_p.field_72995_K) continue;
            DamageSource source = DamageSource.field_76376_m;
            if (thrower instanceof PlayerEntity) {
                source = DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)thrower));
            } else if (thrower instanceof LivingEntity) {
                source = DamageSource.func_76358_a((LivingEntity)((LivingEntity)thrower));
            }
            living.func_70097_a(source, damage);
            entity.func_70106_y();
            break;
        }
    }

    @Override
    public boolean doParticles(IManaBurst burst, ItemStack stack) {
        return true;
    }
}

