/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.common.lib;

import java.util.List;
import java.util.function.Function;
import net.minecraft.block.Block;
import net.minecraft.entity.EntityType;
import net.minecraft.item.DyeColor;
import net.minecraft.item.Item;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.ResourceLocation;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ModTags {
    private static <T> ITag.INamedTag<T> getOrRegister(List<? extends ITag.INamedTag<T>> list, Function<ResourceLocation, ITag.INamedTag<T>> register, ResourceLocation loc) {
        for (ITag.INamedTag<T> existing : list) {
            if (!existing.func_230234_a_().equals((Object)loc)) continue;
            return existing;
        }
        return register.apply(loc);
    }

    public static class Entities {
        public static final ITag.INamedTag<EntityType<?>> SHADED_MESA_BLACKLIST = Entities.tag("shaded_mesa_blacklist");
        public static final ITag.INamedTag<EntityType<?>> COCOON_COMMON = Entities.tag("cocoon/common");
        public static final ITag.INamedTag<EntityType<?>> COCOON_RARE = Entities.tag("cocoon/rare");
        public static final ITag.INamedTag<EntityType<?>> COCOON_COMMON_AQUATIC = Entities.tag("cocoon/common_aquatic");
        public static final ITag.INamedTag<EntityType<?>> COCOON_RARE_AQUATIC = Entities.tag("cocoon/rare_aquatic");

        private static ITag.INamedTag<EntityType<?>> tag(String name) {
            return EntityTypeTags.func_232896_a_((String)ResourceLocationHelper.prefix(name).toString());
        }
    }

    public static class Blocks {
        public static final ITag.INamedTag<Block> MYSTICAL_FLOWERS = Blocks.tag("mystical_flowers");
        public static final ITag.INamedTag<Block> SHINY_FLOWERS = Blocks.tag("shiny_flowers");
        public static final ITag.INamedTag<Block> DOUBLE_MYSTICAL_FLOWERS = Blocks.tag("double_mystical_flowers");
        public static final ITag.INamedTag<Block> SPECIAL_FLOWERS = Blocks.tag("special_flowers");
        public static final ITag.INamedTag<Block> MINI_FLOWERS = Blocks.tag("mini_flowers");
        public static final ITag.INamedTag<Block> MISC_SPECIAL_FLOWERS = Blocks.tag("misc_special_flowers");
        public static final ITag.INamedTag<Block> FUNCTIONAL_SPECIAL_FLOWERS = Blocks.tag("functional_special_flowers");
        public static final ITag.INamedTag<Block> GENERATING_SPECIAL_FLOWERS = Blocks.tag("generating_special_flowers");
        public static final ITag.INamedTag<Block> FLOATING_FLOWERS = Blocks.tag("floating_flowers");
        public static final ITag.INamedTag<Block> MUNDANE_FLOATING_FLOWERS = Blocks.tag("mundane_floating_flowers");
        public static final ITag.INamedTag<Block> SPECIAL_FLOATING_FLOWERS = Blocks.tag("special_floating_flowers");
        public static final ITag.INamedTag<Block> ENCHANTER_FLOWERS = Blocks.tag("enchanter_flowers");
        public static final ITag.INamedTag<Block> LIVINGROCK = Blocks.tag("livingrock");
        public static final ITag.INamedTag<Block> LIVINGWOOD = Blocks.tag("livingwood");
        public static final ITag.INamedTag<Block> BLOCKS_ELEMENTIUM = Blocks.forgeTag("storage_blocks/elementium");
        public static final ITag.INamedTag<Block> BLOCKS_MANASTEEL = Blocks.forgeTag("storage_blocks/manasteel");
        public static final ITag.INamedTag<Block> BLOCKS_QUARTZ = Blocks.forgeTag("storage_blocks/quartz");
        public static final ITag.INamedTag<Block> BLOCKS_TERRASTEEL = Blocks.forgeTag("storage_blocks/terrasteel");
        public static final ITag.INamedTag<Block> GAIA_BREAK_BLACKLIST = Blocks.tag("gaia_break_blacklist");
        public static final ITag.INamedTag<Block> MAGNET_RING_BLACKLIST = Blocks.tag("magnet_ring_blacklist");
        public static final ITag.INamedTag<Block> TERRAFORMABLE = Blocks.tag("terraformable");
        public static final ITag.INamedTag<Block> CORPOREA_SPARK_OVERRIDE = Blocks.tag("corporea_spark_override");
        public static final ITag.INamedTag<Block> TERRA_PLATE_BASE = Blocks.tag("terra_plate_base");

        private static ITag.INamedTag<Block> tag(String name) {
            return BlockTags.func_199894_a((String)ResourceLocationHelper.prefix(name).toString());
        }

        private static ITag.INamedTag<Block> forgeTag(String name) {
            return ModTags.getOrRegister(BlockTags.func_242174_b(), loc -> BlockTags.func_199894_a((String)loc.toString()), new ResourceLocation("forge", name));
        }
    }

    public static class Items {
        public static final ITag.INamedTag<Item> DUSTS_MANA = Items.forgeTag("dusts/mana");
        public static final ITag.INamedTag<Item> GEMS_DRAGONSTONE = Items.forgeTag("gems/dragonstone");
        public static final ITag.INamedTag<Item> GEMS_MANA_DIAMOND = Items.forgeTag("gems/mana_diamond");
        public static final ITag.INamedTag<Item> INGOTS_ELEMENTIUM = Items.forgeTag("ingots/elementium");
        public static final ITag.INamedTag<Item> INGOTS_MANASTEEL = Items.forgeTag("ingots/manasteel");
        public static final ITag.INamedTag<Item> INGOTS_TERRASTEEL = Items.forgeTag("ingots/terrasteel");
        public static final ITag.INamedTag<Item> NUGGETS_ELEMENTIUM = Items.forgeTag("nuggets/elementium");
        public static final ITag.INamedTag<Item> NUGGETS_MANASTEEL = Items.forgeTag("nuggets/manasteel");
        public static final ITag.INamedTag<Item> NUGGETS_TERRASTEEL = Items.forgeTag("nuggets/terrasteel");
        public static final ITag.INamedTag<Item> BLOCKS_ELEMENTIUM = Items.forgeTag("storage_blocks/elementium");
        public static final ITag.INamedTag<Item> BLOCKS_MANASTEEL = Items.forgeTag("storage_blocks/manasteel");
        public static final ITag.INamedTag<Item> BLOCKS_QUARTZ = Items.forgeTag("storage_blocks/quartz");
        public static final ITag.INamedTag<Item> BLOCKS_TERRASTEEL = Items.forgeTag("storage_blocks/terrasteel");
        public static final ITag.INamedTag<Item> MYSTICAL_FLOWERS = Items.tag("mystical_flowers");
        public static final ITag.INamedTag<Item> DOUBLE_MYSTICAL_FLOWERS = Items.tag("double_mystical_flowers");
        public static final ITag.INamedTag<Item> CONTRIBUTOR_HEADFLOWERS = Items.tag("contributor_headflowers");
        public static final ITag.INamedTag<Item> SPECIAL_FLOWERS = Items.tag("special_flowers");
        public static final ITag.INamedTag<Item> MINI_FLOWERS = Items.tag("mini_flowers");
        public static final ITag.INamedTag<Item> MISC_SPECIAL_FLOWERS = Items.tag("misc_special_flowers");
        public static final ITag.INamedTag<Item> FUNCTIONAL_SPECIAL_FLOWERS = Items.tag("functional_special_flowers");
        public static final ITag.INamedTag<Item> GENERATING_SPECIAL_FLOWERS = Items.tag("generating_special_flowers");
        public static final ITag.INamedTag<Item> FLOATING_FLOWERS = Items.tag("floating_flowers");
        public static final ITag.INamedTag<Item> MUNDANE_FLOATING_FLOWERS = Items.tag("mundane_floating_flowers");
        public static final ITag.INamedTag<Item> SPECIAL_FLOATING_FLOWERS = Items.tag("special_floating_flowers");
        public static final ITag.INamedTag<Item> LENS = Items.tag("lens");
        public static final ITag.INamedTag<Item> LIVINGROCK = Items.tag("livingrock");
        public static final ITag.INamedTag<Item> LIVINGWOOD = Items.tag("livingwood");
        public static final ITag.INamedTag<Item> MAGNET_RING_BLACKLIST = Items.tag("magnet_ring_blacklist");
        public static final ITag.INamedTag<Item> LOONIUM_BLACKLIST = Items.tag("loonium_blacklist");
        public static final ITag.INamedTag<Item> DISPOSABLE = Items.tag("disposable");
        public static final ITag.INamedTag<Item> SEMI_DISPOSABLE = Items.tag("semi_disposable");
        public static final ITag.INamedTag<Item> PETALS = Items.tag("petals");
        public static final ITag.INamedTag<Item> PETALS_BLACK = Items.tag("petals/black");
        public static final ITag.INamedTag<Item> PETALS_BLUE = Items.tag("petals/blue");
        public static final ITag.INamedTag<Item> PETALS_BROWN = Items.tag("petals/brown");
        public static final ITag.INamedTag<Item> PETALS_CYAN = Items.tag("petals/cyan");
        public static final ITag.INamedTag<Item> PETALS_GRAY = Items.tag("petals/gray");
        public static final ITag.INamedTag<Item> PETALS_GREEN = Items.tag("petals/green");
        public static final ITag.INamedTag<Item> PETALS_LIGHT_BLUE = Items.tag("petals/light_blue");
        public static final ITag.INamedTag<Item> PETALS_LIGHT_GRAY = Items.tag("petals/light_gray");
        public static final ITag.INamedTag<Item> PETALS_LIME = Items.tag("petals/lime");
        public static final ITag.INamedTag<Item> PETALS_MAGENTA = Items.tag("petals/magenta");
        public static final ITag.INamedTag<Item> PETALS_ORANGE = Items.tag("petals/orange");
        public static final ITag.INamedTag<Item> PETALS_PINK = Items.tag("petals/pink");
        public static final ITag.INamedTag<Item> PETALS_PURPLE = Items.tag("petals/purple");
        public static final ITag.INamedTag<Item> PETALS_RED = Items.tag("petals/red");
        public static final ITag.INamedTag<Item> PETALS_WHITE = Items.tag("petals/white");
        public static final ITag.INamedTag<Item> PETALS_YELLOW = Items.tag("petals/yellow");
        public static final ITag.INamedTag<Item> RUNES = Items.tag("runes");
        public static final ITag.INamedTag<Item> RUNES_AIR = Items.tag("runes/air");
        public static final ITag.INamedTag<Item> RUNES_AUTUMN = Items.tag("runes/autumn");
        public static final ITag.INamedTag<Item> RUNES_EARTH = Items.tag("runes/earth");
        public static final ITag.INamedTag<Item> RUNES_ENVY = Items.tag("runes/envy");
        public static final ITag.INamedTag<Item> RUNES_FIRE = Items.tag("runes/fire");
        public static final ITag.INamedTag<Item> RUNES_GLUTTONY = Items.tag("runes/gluttony");
        public static final ITag.INamedTag<Item> RUNES_GREED = Items.tag("runes/greed");
        public static final ITag.INamedTag<Item> RUNES_LUST = Items.tag("runes/lust");
        public static final ITag.INamedTag<Item> RUNES_MANA = Items.tag("runes/mana");
        public static final ITag.INamedTag<Item> RUNES_PRIDE = Items.tag("runes/pride");
        public static final ITag.INamedTag<Item> RUNES_SLOTH = Items.tag("runes/sloth");
        public static final ITag.INamedTag<Item> RUNES_SPRING = Items.tag("runes/spring");
        public static final ITag.INamedTag<Item> RUNES_SUMMER = Items.tag("runes/summer");
        public static final ITag.INamedTag<Item> RUNES_WATER = Items.tag("runes/water");
        public static final ITag.INamedTag<Item> RUNES_WINTER = Items.tag("runes/winter");
        public static final ITag.INamedTag<Item> RUNES_WRATH = Items.tag("runes/wrath");
        public static final ITag.INamedTag<Item> BURST_VIEWERS = Items.tag("burst_viewers");
        public static final ITag.INamedTag<Item> TERRA_PICK_BLACKLIST = Items.tag("terra_pick_blacklist");

        public static ITag.INamedTag<Item> getPetalTag(DyeColor color) {
            switch (color) {
                default: {
                    return PETALS_WHITE;
                }
                case ORANGE: {
                    return PETALS_ORANGE;
                }
                case MAGENTA: {
                    return PETALS_MAGENTA;
                }
                case LIGHT_BLUE: {
                    return PETALS_LIGHT_BLUE;
                }
                case YELLOW: {
                    return PETALS_YELLOW;
                }
                case LIME: {
                    return PETALS_LIME;
                }
                case PINK: {
                    return PETALS_PINK;
                }
                case GRAY: {
                    return PETALS_GRAY;
                }
                case LIGHT_GRAY: {
                    return PETALS_LIGHT_GRAY;
                }
                case CYAN: {
                    return PETALS_CYAN;
                }
                case PURPLE: {
                    return PETALS_PURPLE;
                }
                case BLUE: {
                    return PETALS_BLUE;
                }
                case BROWN: {
                    return PETALS_BROWN;
                }
                case GREEN: {
                    return PETALS_GREEN;
                }
                case RED: {
                    return PETALS_RED;
                }
                case BLACK: 
            }
            return PETALS_BLACK;
        }

        private static ITag.INamedTag<Item> tag(String name) {
            return ItemTags.func_199901_a((String)ResourceLocationHelper.prefix(name).toString());
        }

        private static ITag.INamedTag<Item> forgeTag(String name) {
            return ModTags.getOrRegister(ItemTags.func_242177_b(), loc -> ItemTags.func_199901_a((String)loc.toString()), new ResourceLocation("forge", name));
        }
    }
}

