/*
 * Decompiled with CFR 0.152.
 */
package vazkii.botania.data.recipes;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.RecipeProvider;
import net.minecraft.item.DyeColor;
import net.minecraft.item.DyeItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.IRecipeSerializer;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.state.Property;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraftforge.common.Tags;
import vazkii.botania.common.block.ModBlocks;
import vazkii.botania.common.block.ModFluffBlocks;
import vazkii.botania.common.block.ModSubtiles;
import vazkii.botania.common.core.helper.ItemNBTHelper;
import vazkii.botania.common.crafting.ModRecipeTypes;
import vazkii.botania.common.crafting.StateIngredientHelper;
import vazkii.botania.common.item.ModItems;
import vazkii.botania.common.lib.ResourceLocationHelper;

public class ManaInfusionProvider
extends RecipeProvider {
    public ManaInfusionProvider(DataGenerator gen) {
        super(gen);
    }

    public String func_200397_b() {
        return "Botania mana pool recipes";
    }

    protected void func_200404_a(Consumer<IFinishedRecipe> consumer) {
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("manasteel"), new ItemStack((IItemProvider)ModItems.manaSteel), Ingredient.func_199805_a((ITag)Tags.Items.INGOTS_IRON), 3000));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("manasteel_block"), new ItemStack((IItemProvider)ModBlocks.manasteelBlock), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150339_S), 27000));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_pearl"), new ItemStack((IItemProvider)ModItems.manaPearl), ManaInfusionProvider.ingr((IItemProvider)Items.field_151079_bi), 6000));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_diamond"), new ItemStack((IItemProvider)ModItems.manaDiamond), Ingredient.func_199805_a((ITag)Tags.Items.GEMS_DIAMOND), 10000));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_diamond_block"), new ItemStack((IItemProvider)ModBlocks.manaDiamondBlock), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150484_ah), 90000));
        Ingredient dust = Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_151016_H, Items.field_151137_ax, Items.field_151114_aO, Items.field_151102_aT});
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_powder_dust"), new ItemStack((IItemProvider)ModItems.manaPowder), dust, 500));
        Ingredient dyeIngredient = Ingredient.func_199804_a((IItemProvider[])((IItemProvider[])Arrays.stream(DyeColor.values()).map(DyeItem::func_195961_a).toArray(Item[]::new)));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_powder_dye"), new ItemStack((IItemProvider)ModItems.manaPowder), dyeIngredient, 400));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("piston_relay"), new ItemStack((IItemProvider)ModBlocks.pistonRelay), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150331_J), 15000));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_cookie"), new ItemStack((IItemProvider)ModItems.manaCookie), ManaInfusionProvider.ingr((IItemProvider)Items.field_151106_aX), 20000));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("grass_seeds"), new ItemStack((IItemProvider)ModItems.grassSeeds), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150349_c), 2500));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("podzol_seeds"), new ItemStack((IItemProvider)ModItems.podzolSeeds), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196555_aI), 2500));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mycel_seeds"), new ItemStack((IItemProvider)ModItems.mycelSeeds), Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Blocks.field_150337_Q, Blocks.field_150338_P}), 6500));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_quartz"), new ItemStack((IItemProvider)ModItems.manaQuartz), ManaInfusionProvider.ingr((IItemProvider)Items.field_151128_bU), 250));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("tiny_potato"), new ItemStack((IItemProvider)ModBlocks.tinyPotato), ManaInfusionProvider.ingr((IItemProvider)Items.field_151174_bG), 1337));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_glass"), new ItemStack((IItemProvider)ModBlocks.manaGlass), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150359_w), 150));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_string"), new ItemStack((IItemProvider)ModItems.manaString), ManaInfusionProvider.ingr((IItemProvider)Items.field_151007_F), 5000));
        consumer.accept(new FinishedRecipe(ManaInfusionProvider.id("mana_bottle"), new ItemStack((IItemProvider)ModItems.manaBottle), ManaInfusionProvider.ingr((IItemProvider)Items.field_151069_bo), 5000));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("rotten_flesh_to_leather"), new ItemStack((IItemProvider)Items.field_151116_aA), ManaInfusionProvider.ingr((IItemProvider)Items.field_151078_bh), 600));
        ManaInfusionProvider.cycle(consumer, 40, "botania:log_cycle", new IItemProvider[]{Blocks.field_196617_K, Blocks.field_196618_L, Blocks.field_196619_M, Blocks.field_196620_N, Blocks.field_196621_O, Blocks.field_196623_P});
        ManaInfusionProvider.cycle(consumer, 120, "botania:sapling_cycle", new IItemProvider[]{Blocks.field_196674_t, Blocks.field_196675_u, Blocks.field_196676_v, Blocks.field_196678_w, Blocks.field_196679_x, Blocks.field_196680_y});
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("glowstone_deconstruct"), new ItemStack((IItemProvider)Items.field_151114_aO, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150426_aN), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("quartz_deconstruct"), new ItemStack((IItemProvider)Items.field_151128_bU, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150371_ca), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("dark_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.darkQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.darkQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("mana_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.manaQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.manaQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("blaze_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.blazeQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.blazeQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("lavender_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.lavenderQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.lavenderQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("red_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.redQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.redQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("elf_quartz_deconstruct"), new ItemStack((IItemProvider)ModItems.elfQuartz, 4), ManaInfusionProvider.ingr((IItemProvider)ModFluffBlocks.elfQuartz), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("chiseled_stone_bricks"), new ItemStack((IItemProvider)Blocks.field_196702_dl, 1), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196696_di), 150));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("ice"), new ItemStack((IItemProvider)Blocks.field_150432_aD), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196604_cC), 2250));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("vine_to_lily_pad"), new ItemStack((IItemProvider)Blocks.field_196651_dG), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150395_bd), 320));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("lily_pad_to_vine"), new ItemStack((IItemProvider)Blocks.field_150395_bd), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196651_dG), 320));
        ManaInfusionProvider.cycle(consumer, 200, "botania:fish_cycle", new IItemProvider[]{Items.field_196086_aW, Items.field_196087_aX, Items.field_196088_aY, Items.field_196089_aZ});
        ManaInfusionProvider.cycle(consumer, 6000, "botania:crop_cycle", new IItemProvider[]{Items.field_196130_bo, Items.field_151014_N, Items.field_151174_bG, Items.field_151172_bF, Items.field_185163_cU, Items.field_151081_bc, Items.field_151080_bb});
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("potato_unpoison"), new ItemStack((IItemProvider)Items.field_151174_bG), ManaInfusionProvider.ingr((IItemProvider)Items.field_151170_bI), 1200));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("blaze_rod_to_nether_wart"), new ItemStack((IItemProvider)Items.field_151075_bm), ManaInfusionProvider.ingr((IItemProvider)Items.field_151072_bj), 4000));
        ManaInfusionProvider.cycle(consumer, 200, "", new IItemProvider[]{Items.field_151016_H, Items.field_151145_ak});
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("book_to_name_tag"), new ItemStack((IItemProvider)Items.field_151057_cb), ManaInfusionProvider.ingr((IItemProvider)Items.field_151099_bA), 6000));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("wool_deconstruct"), new ItemStack((IItemProvider)Items.field_151007_F, 3), Ingredient.func_199805_a((ITag)ItemTags.field_199904_a), 100));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("cactus_to_slime"), new ItemStack((IItemProvider)Items.field_151123_aH), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150434_aF), 1200));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("slime_to_cactus"), new ItemStack((IItemProvider)Blocks.field_150434_aF), ManaInfusionProvider.ingr((IItemProvider)Items.field_151123_aH), 1200));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("ender_pearl_from_ghast_tear"), new ItemStack((IItemProvider)Items.field_151079_bi), ManaInfusionProvider.ingr((IItemProvider)Items.field_151073_bk), 28000));
        ManaInfusionProvider.cycle(consumer, 300, "", new IItemProvider[]{Items.field_151114_aO, Items.field_151137_ax});
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("cobble_to_sand"), new ItemStack((IItemProvider)Blocks.field_150354_m), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150347_e), 50));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("terracotta_to_red_sand"), new ItemStack((IItemProvider)Blocks.field_196611_F), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150405_ch), 50));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("clay_deconstruct"), new ItemStack((IItemProvider)Items.field_151119_aD, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150435_aG), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("brick_deconstruct"), new ItemStack((IItemProvider)Items.field_151118_aC, 4), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196584_bK), 25));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("coarse_dirt"), new ItemStack((IItemProvider)Blocks.field_196660_k), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150346_d), 120));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("stone_to_andesite"), new ItemStack((IItemProvider)Blocks.field_196656_g), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150348_b), 200));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("andesite_to_diorite"), new ItemStack((IItemProvider)Blocks.field_196654_e), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196656_g), 200));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("diorite_to_granite"), new ItemStack((IItemProvider)Blocks.field_196650_c), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196654_e), 200));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("granite_to_andesite"), new ItemStack((IItemProvider)Blocks.field_196656_g), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196650_c), 200));
        ManaInfusionProvider.cycle(consumer, 500, "botania:shrub_cycle", new IItemProvider[]{Blocks.field_196554_aH, Blocks.field_196555_aI, Blocks.field_150349_c});
        ManaInfusionProvider.cycle(consumer, 400, "botania:flower_cycle", new IItemProvider[]{Blocks.field_196605_bc, Blocks.field_196606_bd, Blocks.field_196607_be, Blocks.field_196609_bf, Blocks.field_196610_bg, Blocks.field_196612_bh, Blocks.field_196613_bi, Blocks.field_196614_bj, Blocks.field_196615_bk, Blocks.field_196616_bl, Blocks.field_222387_by, Blocks.field_222383_bA, Blocks.field_196800_gd, Blocks.field_196801_ge, Blocks.field_196802_gf, Blocks.field_196803_gg});
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("chorus_fruit_to_flower"), new ItemStack((IItemProvider)Blocks.field_185766_cS), ManaInfusionProvider.ingr((IItemProvider)Items.field_185162_cT), 10000));
        ManaInfusionProvider.cycle(consumer, 240, "botania:berry_cycle", new IItemProvider[]{Items.field_151034_e, Items.field_222112_pR});
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.agricarnationChibi, (IItemProvider)ModSubtiles.agricarnation));
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.clayconiaChibi, (IItemProvider)ModSubtiles.clayconia));
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.bellethornChibi, (IItemProvider)ModSubtiles.bellethorn));
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.bubbellChibi, (IItemProvider)ModSubtiles.bubbell));
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.hopperhockChibi, (IItemProvider)ModSubtiles.hopperhock));
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.marimorphosisChibi, (IItemProvider)ModSubtiles.marimorphosis));
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.rannuncarpusChibi, (IItemProvider)ModSubtiles.rannuncarpus));
        consumer.accept(ManaInfusionProvider.mini((IItemProvider)ModSubtiles.solegnoliaChibi, (IItemProvider)ModSubtiles.solegnolia));
        consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id("hydroangeas_motif"), new ItemStack((IItemProvider)ModBlocks.motifHydroangeas), ManaInfusionProvider.ingr((IItemProvider)ModSubtiles.hydroangeas), 2500));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("redstone_dupe"), new ItemStack((IItemProvider)Items.field_151137_ax, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151137_ax), 5000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("glowstone_dupe"), new ItemStack((IItemProvider)Items.field_151114_aO, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151114_aO), 5000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("quartz_dupe"), new ItemStack((IItemProvider)Items.field_151128_bU, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151128_bU), 2500));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("coal_dupe"), new ItemStack((IItemProvider)Items.field_151044_h, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151044_h), 2100));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("snowball_dupe"), new ItemStack((IItemProvider)Items.field_151126_ay, 2), ManaInfusionProvider.ingr((IItemProvider)Items.field_151126_ay), 200));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("netherrack_dupe"), new ItemStack((IItemProvider)Blocks.field_150424_aL, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150424_aL), 200));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("soul_sand_dupe"), new ItemStack((IItemProvider)Blocks.field_150425_aM, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150425_aM), 1500));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("gravel_dupe"), new ItemStack((IItemProvider)Blocks.field_150351_n, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150351_n), 720));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("oak_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196642_W, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196642_W), 2000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("birch_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196647_Y, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196647_Y), 2000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("spruce_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196645_X, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196645_X), 2000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("jungle_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196648_Z, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196648_Z), 2000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("acacia_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196572_aa, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196572_aa), 2000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("dark_oak_leaves_dupe"), new ItemStack((IItemProvider)Blocks.field_196574_ab, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_196574_ab), 2000));
        consumer.accept(FinishedRecipe.conjuration(ManaInfusionProvider.id("grass"), new ItemStack((IItemProvider)Blocks.field_150349_c, 2), ManaInfusionProvider.ingr((IItemProvider)Blocks.field_150349_c), 800));
    }

    private static void cycle(Consumer<IFinishedRecipe> consumer, int cost, String group, IItemProvider ... items) {
        for (int i = 0; i < items.length; ++i) {
            Ingredient in = ManaInfusionProvider.ingr(items[i]);
            ItemStack out = new ItemStack(i == items.length - 1 ? items[0] : items[i + 1]);
            String id = String.format("%s_to_%s", Registry.field_212630_s.func_177774_c((Object)items[i].func_199767_j()).func_110623_a(), Registry.field_212630_s.func_177774_c((Object)out.func_77973_b()).func_110623_a());
            consumer.accept(FinishedRecipe.alchemy(ManaInfusionProvider.id(id), out, in, cost, group));
        }
    }

    private static FinishedRecipe mini(IItemProvider mini, IItemProvider full) {
        return FinishedRecipe.alchemy(ManaInfusionProvider.id(Registry.field_212630_s.func_177774_c((Object)mini.func_199767_j()).func_110623_a()), new ItemStack(mini), ManaInfusionProvider.ingr(full), 2500, "botania:flower_shrinking");
    }

    private static ResourceLocation id(String s) {
        return ResourceLocationHelper.prefix("mana_infusion/" + s);
    }

    private static Ingredient ingr(IItemProvider i) {
        return Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{i});
    }

    private static class FinishedRecipe
    implements IFinishedRecipe {
        private final ResourceLocation id;
        private final Ingredient input;
        private final ItemStack output;
        private final int mana;
        private final String group;
        @Nullable
        private final BlockState catalyst;

        public static FinishedRecipe conjuration(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return new FinishedRecipe(id, output, input, mana, "", ModBlocks.conjurationCatalyst.func_176223_P());
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            return FinishedRecipe.alchemy(id, output, input, mana, "");
        }

        public static FinishedRecipe alchemy(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            return new FinishedRecipe(id, output, input, mana, group, ModBlocks.alchemyCatalyst.func_176223_P());
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana) {
            this(id, output, input, mana, "");
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group) {
            this(id, output, input, mana, group, null);
        }

        public FinishedRecipe(ResourceLocation id, ItemStack output, Ingredient input, int mana, String group, @Nullable BlockState catalyst) {
            this.id = id;
            this.input = input;
            this.output = output;
            this.mana = mana;
            this.group = group;
            this.catalyst = catalyst;
        }

        public void func_218610_a(JsonObject json) {
            json.add("input", this.input.func_200304_c());
            json.add("output", (JsonElement)ItemNBTHelper.serializeStack(this.output));
            json.addProperty("mana", (Number)this.mana);
            if (!this.group.isEmpty()) {
                json.addProperty("group", this.group);
            }
            if (this.catalyst != null) {
                json.add("catalyst", (JsonElement)StateIngredientHelper.serializeBlockState(this.catalyst));
            }
        }

        private static <T extends Comparable<T>> String getName(Property<T> prop, Comparable<?> val) {
            return prop.func_177702_a(val);
        }

        public ResourceLocation func_200442_b() {
            return this.id;
        }

        public IRecipeSerializer<?> func_218609_c() {
            return ModRecipeTypes.MANA_INFUSION_SERIALIZER;
        }

        @Nullable
        public JsonObject func_200440_c() {
            return null;
        }

        @Nullable
        public ResourceLocation func_200443_d() {
            return null;
        }
    }
}

