/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier;

import com.possible_triangle.brazier.block.BrazierBlock;
import com.possible_triangle.brazier.block.LazyTorchBlock;
import com.possible_triangle.brazier.block.LazyWallTorchBlock;
import com.possible_triangle.brazier.block.SpawnPowder;
import com.possible_triangle.brazier.block.tile.BrazierTile;
import com.possible_triangle.brazier.block.tile.render.BrazierRenderer;
import com.possible_triangle.brazier.entity.Crazed;
import com.possible_triangle.brazier.entity.CrazedFlame;
import com.possible_triangle.brazier.entity.render.CrazedFlameRenderer;
import com.possible_triangle.brazier.entity.render.CrazedRender;
import com.possible_triangle.brazier.item.LazySpawnEgg;
import com.possible_triangle.brazier.item.LivingTorch;
import com.possible_triangle.brazier.particle.FlameParticle;
import java.awt.Color;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Stream;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.entity.EntityClassification;
import net.minecraft.entity.EntitySpawnPlacementRegistry;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.Rarity;
import net.minecraft.particles.BasicParticleType;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleType;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.EntityTypeTags;
import net.minecraft.tags.ITag;
import net.minecraft.tags.ItemTags;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraft.world.gen.Heightmap;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.client.event.ParticleFactoryRegisterEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.RegistryObject;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class Content {
    public static final ITag<Block> BRAZIER_BASE_BLOCKS = BlockTags.func_199894_a((String)new ResourceLocation("brazier", "brazier_base_blocks").toString());
    public static final ITag<EntityType<?>> BRAZIER_WHITELIST = EntityTypeTags.func_232896_a_((String)new ResourceLocation("brazier", "brazier_whitelist").toString());
    public static final ITag<EntityType<?>> BRAZIER_BLACKLIST = EntityTypeTags.func_232896_a_((String)new ResourceLocation("brazier", "brazier_blacklist").toString());
    public static final ITag<Item> TORCHES = ItemTags.func_199901_a((String)new ResourceLocation("brazier", "torches").toString());
    public static final ITag<Item> ASH_TAG = ItemTags.func_199901_a((String)new ResourceLocation("brazier", "ash").toString());
    public static final ITag<Item> WARPED_WART_TAG = ItemTags.func_199901_a((String)new ResourceLocation("brazier", "warped_wart").toString());
    public static final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"brazier");
    public static final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"brazier");
    public static final DeferredRegister<TileEntityType<?>> TILES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.TILE_ENTITIES, (String)"brazier");
    public static final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"brazier");
    public static final DeferredRegister<ParticleType<?>> PARTICLES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.PARTICLE_TYPES, (String)"brazier");
    public static final RegistryObject<BasicParticleType> FLAME_PARTICLE = PARTICLES.register("flame", () -> new BasicParticleType(false));
    public static final RegistryObject<BrazierBlock> BRAZIER = Content.registerBlock("brazier", BrazierBlock::new, p -> p.func_200916_a(ItemGroup.field_78026_f));
    public static final RegistryObject<TileEntityType<BrazierTile>> BRAZIER_TILE = TILES.register("brazier", () -> TileEntityType.Builder.func_223042_a(BrazierTile::new, (Block[])new Block[]{(Block)BRAZIER.get()}).func_206865_a(null));
    public static final RegistryObject<Block> LIVING_TORCH_BLOCK = BLOCKS.register("living_torch", () -> new LazyTorchBlock((Supplier<? extends IParticleData>)FLAME_PARTICLE));
    public static final RegistryObject<Block> LIVING_TORCH_BLOCK_WALL = BLOCKS.register("living_wall_torch", () -> new LazyWallTorchBlock((Supplier<? extends IParticleData>)FLAME_PARTICLE));
    public static final RegistryObject<Item> LIVING_FLAME = ITEMS.register("living_flame", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l).func_208103_a(Rarity.UNCOMMON)));
    public static final RegistryObject<Item> LIVING_TORCH = ITEMS.register("living_torch", LivingTorch::new);
    public static final RegistryObject<Item> ASH = ITEMS.register("ash", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
    public static final RegistryObject<Item> WARPED_NETHERWART = ITEMS.register("warped_nether_wart", () -> new Item(new Item.Properties().func_200916_a(ItemGroup.field_78035_l)));
    public static final RegistryObject<Block> SPAWN_POWDER = Content.registerBlock("spawn_powder", SpawnPowder::new, p -> p.func_200916_a(ItemGroup.field_78035_l));
    public static final RegistryObject<EntityType<Crazed>> CRAZED = ENTITIES.register("crazed", () -> EntityType.Builder.func_220322_a(Crazed::new, (EntityClassification)EntityClassification.MONSTER).setCustomClientFactory((s, w) -> new Crazed((World)w)).func_220320_c().func_206830_a("crazed"));
    public static final RegistryObject<LazySpawnEgg> CRAZED_SPAWN_EGG = ITEMS.register("crazed_spawn_egg", () -> new LazySpawnEgg(() -> CRAZED.get(), new Color(0x959B9B).getRGB(), new Color(9030407).getRGB()));
    public static final RegistryObject<EntityType<CrazedFlame>> CRAZED_FLAME = ENTITIES.register("crazed_flame", () -> EntityType.Builder.func_220322_a(CrazedFlame::new, (EntityClassification)EntityClassification.MISC).setCustomClientFactory((s, w) -> new CrazedFlame((World)w)).func_220321_a(0.6f, 0.6f).setShouldReceiveVelocityUpdates(false).func_220320_c().func_206830_a("crazed_flame"));

    public static <B extends Block> RegistryObject<B> registerBlock(String name, Supplier<B> supplier, Function<Item.Properties, Item.Properties> props) {
        RegistryObject block = BLOCKS.register(name, supplier);
        ITEMS.register(name, () -> new BlockItem((Block)block.get(), (Item.Properties)props.apply(new Item.Properties())));
        return block;
    }

    public static void init() {
        ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        TILES.register(FMLJavaModLoadingContext.get().getModEventBus());
        PARTICLES.register(FMLJavaModLoadingContext.get().getModEventBus());
    }

    public static void setup() {
        CRAZED.ifPresent(type -> {
            Crazed.init((EntityType<? extends LivingEntity>)type);
            EntitySpawnPlacementRegistry.func_209343_a((EntityType)type, (EntitySpawnPlacementRegistry.PlacementType)EntitySpawnPlacementRegistry.PlacementType.NO_RESTRICTIONS, (Heightmap.Type)Heightmap.Type.MOTION_BLOCKING_NO_LEAVES, Crazed::canSpawnHere);
        });
    }

    @SubscribeEvent
    public static void registerParticles(ParticleFactoryRegisterEvent event) {
        FLAME_PARTICLE.ifPresent(type -> Minecraft.func_71410_x().field_71452_i.func_215234_a((ParticleType)type, FlameParticle.Factory::new));
    }

    @OnlyIn(value=Dist.CLIENT)
    @SubscribeEvent
    public static void itemColors(ColorHandlerEvent.Item event) {
        event.getItemColors().func_199877_a((s, i) -> {
            if (s.func_77973_b() instanceof LazySpawnEgg) {
                LazySpawnEgg egg = (LazySpawnEgg)s.func_77973_b();
                return egg.getColor(i);
            }
            return -1;
        }, new IItemProvider[]{(IItemProvider)CRAZED_SPAWN_EGG.get()});
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientSetup(Minecraft mc) {
        CRAZED.ifPresent(type -> mc.func_175598_ae().func_229087_a_(type, (EntityRenderer)new CrazedRender(mc.func_175598_ae())));
        CRAZED_FLAME.ifPresent(type -> mc.func_175598_ae().func_229087_a_(type, (EntityRenderer)new CrazedFlameRenderer(mc.func_175598_ae())));
        Stream.of(BRAZIER, LIVING_TORCH_BLOCK, LIVING_TORCH_BLOCK_WALL).filter(RegistryObject::isPresent).map(RegistryObject::get).forEach(b -> RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228643_e_()));
        BRAZIER_TILE.ifPresent(tile -> ClientRegistry.bindTileEntityRenderer((TileEntityType)tile, BrazierRenderer::new));
        SPAWN_POWDER.ifPresent(b -> RenderTypeLookup.setRenderLayer((Block)b, (RenderType)RenderType.func_228643_e_()));
    }
}

