/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.block;

import com.possible_triangle.brazier.Content;
import com.possible_triangle.brazier.block.tile.BrazierTile;
import com.possible_triangle.brazier.config.BrazierConfig;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.ContainerBlock;
import net.minecraft.block.material.Material;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SpawnReason;
import net.minecraft.entity.monster.MonsterEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.state.BooleanProperty;
import net.minecraft.state.Property;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BlockStateProperties;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.common.ToolType;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.FORGE)
public class BrazierBlock
extends ContainerBlock {
    public static final BooleanProperty LIT = BlockStateProperties.field_208190_q;
    private static final VoxelShape SHAPE = BrazierBlock.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)4.0, (double)16.0);

    public BrazierBlock() {
        super(AbstractBlock.Properties.func_200945_a((Material)Material.field_151573_f).func_200943_b(3.0f).harvestTool(ToolType.PICKAXE).func_226896_b_().func_235838_a_(s -> (Boolean)s.func_177229_b((Property)LIT) != false ? 15 : 0));
        this.func_180632_j((BlockState)super.func_176223_P().func_206870_a((Property)LIT, (Comparable)Boolean.valueOf(false)));
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        super.func_206840_a(builder);
        builder.func_206894_a(new Property[]{LIT});
    }

    public static boolean prevents(Entity entity) {
        EntityType type = entity.func_200600_R();
        return entity instanceof MonsterEntity && entity.func_184222_aU() && !Content.BRAZIER_WHITELIST.func_230235_a_((Object)type) || Content.BRAZIER_BLACKLIST.func_230235_a_((Object)type);
    }

    public static boolean prevents(SpawnReason reason) {
        switch (reason) {
            case CHUNK_GENERATION: 
            case NATURAL: 
            case PATROL: {
                return true;
            }
        }
        return false;
    }

    @SubscribeEvent
    public static void mobSpawn(LivingSpawnEvent.CheckSpawn event) {
        BlockPos pos = new BlockPos(event.getX(), event.getY(), event.getZ());
        if (((Boolean)BrazierConfig.SERVER.SPAWN_POWDER.get()).booleanValue()) {
            Block block = event.getWorld().func_180495_p(pos).func_177230_c();
            if (Content.SPAWN_POWDER.filter(block::equals).isPresent()) {
                return;
            }
        }
        if (BrazierBlock.prevents(event.getSpawnReason()) && BrazierBlock.prevents(event.getEntity()) && BrazierTile.inRange(pos)) {
            event.setResult(Event.Result.DENY);
        }
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        return SHAPE;
    }

    @Nullable
    public TileEntity func_196283_a_(IBlockReader world) {
        return new BrazierTile();
    }

    public ActionResultType func_225533_a_(BlockState state, World world, BlockPos pos, PlayerEntity player, Hand hand, BlockRayTraceResult hit) {
        return Content.LIVING_TORCH.filter(torch -> {
            ItemStack stack = player.func_184586_b(hand);
            if (!stack.func_190926_b() && Content.TORCHES.func_230235_a_((Object)stack.func_77973_b())) {
                if (!player.func_184812_l_()) {
                    stack.func_190918_g(1);
                }
                player.func_191521_c(new ItemStack((IItemProvider)torch, 1));
                return true;
            }
            return false;
        }).map($ -> ActionResultType.SUCCESS).orElse(ActionResultType.PASS);
    }

    public BlockRenderType func_149645_b(BlockState state) {
        return BlockRenderType.MODEL;
    }

    public void func_196262_a(BlockState state, World world, BlockPos pos, Entity entity) {
        if (!entity.func_230279_az_() && ((Boolean)state.func_177229_b((Property)LIT)).booleanValue() && entity instanceof LivingEntity && !EnchantmentHelper.func_189869_j((LivingEntity)((LivingEntity)entity))) {
            entity.func_70097_a(DamageSource.field_76372_a, 2.0f);
        }
        super.func_196262_a(state, world, pos, entity);
    }
}

