/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.config;

import com.possible_triangle.brazier.config.BrazierClientConfig;
import com.possible_triangle.brazier.config.BrazierServerConfig;
import com.possible_triangle.brazier.network.BrazierNetwork;
import com.possible_triangle.brazier.network.SyncConfigMessage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Path;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.server.ServerLifecycleHooks;
import org.apache.commons.lang3.tuple.Pair;

@Mod.EventBusSubscriber(bus=Mod.EventBusSubscriber.Bus.MOD)
public class BrazierConfig {
    public static final ForgeConfigSpec CLIENT_SPEC;
    public static final ForgeConfigSpec SERVER_SPEC;
    public static final BrazierClientConfig CLIENT;
    public static final BrazierServerConfig SERVER;

    @SubscribeEvent
    public static void configReload(ModConfig.Reloading event) {
        if (event.getConfig().getType() == ModConfig.Type.COMMON) {
            for (ServerPlayerEntity player : ServerLifecycleHooks.getCurrentServer().func_184103_al().func_181057_v()) {
                BrazierConfig.syncServerConfigs((PlayerEntity)player);
            }
        }
    }

    public static void syncServerConfigs(PlayerEntity player) {
        Path config = FMLPaths.CONFIGDIR.get().resolve("brazier-common.toml").toAbsolutePath();
        try {
            byte[] configData = Files.readAllBytes(config);
            BrazierNetwork.sendTo(new SyncConfigMessage(configData), player);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(BrazierClientConfig::new);
        CLIENT_SPEC = (ForgeConfigSpec)specPair.getRight();
        CLIENT = (BrazierClientConfig)specPair.getLeft();
        specPair = new ForgeConfigSpec.Builder().configure(BrazierServerConfig::new);
        SERVER_SPEC = (ForgeConfigSpec)specPair.getRight();
        SERVER = (BrazierServerConfig)specPair.getLeft();
    }
}

