/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.data;

import com.possible_triangle.brazier.data.BaseLootTableProvider;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.loot.LootEntry;
import net.minecraft.loot.LootPool;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.TableLootEntry;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.LootTableLoadEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class InjectingLootTableProvider {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<Inject> injects = new ArrayList<Inject>();
    private final List<Consumer<BaseLootTableProvider>> tables = new ArrayList<Consumer<BaseLootTableProvider>>();

    public InjectingLootTableProvider() {
        MinecraftForge.EVENT_BUS.addListener(EventPriority.LOWEST, this::onLootLoaded);
    }

    protected void addInject(String injectName, ResourceLocation into, LootPool.Builder pool) {
        this.addInject(injectName, into, pool, () -> true);
    }

    protected void addInject(String injectName, ResourceLocation into, LootPool.Builder pool, Supplier<Boolean> predicate) {
        ResourceLocation loc = new ResourceLocation("brazier", "inject/" + injectName);
        if (this.injects.stream().anyMatch(i -> i.name.equals((Object)loc))) {
            LOGGER.warn(String.format("Attempted to add duplicate inject table '%s'", injectName));
        } else {
            this.addLootTable(loc, LootTable.func_216119_b().func_216040_a(pool.name("inject")));
            this.injects.add(new Inject(loc, into, predicate));
        }
    }

    protected abstract void addTables();

    protected void addLootTable(ResourceLocation name, LootTable.Builder table) {
        this.tables.add(provider -> provider.addLootTable(name, table));
    }

    public IDataProvider getProvider(DataGenerator generator) {
        return new BaseLootTableProvider(generator){

            @Override
            protected void addTables() {
                InjectingLootTableProvider.this.addTables();
                InjectingLootTableProvider.this.tables.forEach(c -> c.accept(this));
            }
        };
    }

    public void onLootLoaded(LootTableLoadEvent event) {
        if (this.injects.isEmpty()) {
            this.addTables();
        }
        long injected = this.injects.stream().filter(i -> i.predicate.get()).filter(i -> i.into.equals((Object)event.getName())).map(i -> LootPool.func_216096_a().func_216045_a((LootEntry.Builder)TableLootEntry.func_216171_a((ResourceLocation)i.name)).name(i.name.func_110623_a()).func_216044_b()).peek(arg_0 -> ((LootTable)event.getTable()).addPool(arg_0)).count();
        if (injected > 0L) {
            LOGGER.info(String.format("Injected %d pools into '%s'", injected, event.getName()));
        }
    }

    public static class Inject {
        public final ResourceLocation name;
        public final ResourceLocation into;
        public final Supplier<Boolean> predicate;

        private Inject(ResourceLocation inject, ResourceLocation into, Supplier<Boolean> predicate) {
            this.name = inject;
            this.into = into;
            this.predicate = predicate;
        }
    }
}

