/*
 * Decompiled with CFR 0.152.
 */
package com.possible_triangle.brazier.entity;

import com.possible_triangle.brazier.Content;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Blocks;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.LivingEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.particles.IParticleData;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Direction;
import net.minecraft.util.IndirectEntityDamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.fml.network.NetworkHooks;

public class CrazedFlame
extends Entity {
    private static final int INITIAL_LIFE = 80;
    private LivingEntity caster;
    private UUID casterUuid;
    private int life = 80;
    private boolean sentSpikeEvent;

    public CrazedFlame(World world, double x, double y, double z, LivingEntity caster) {
        this(world);
        this.setCaster(caster);
        this.func_70107_b(x, y, z);
    }

    public CrazedFlame(World world) {
        this((EntityType<? extends CrazedFlame>)((EntityType)Content.CRAZED_FLAME.get()), world);
    }

    public CrazedFlame(EntityType<? extends CrazedFlame> type, World world) {
        super(type, world);
    }

    public void func_70071_h_() {
        --this.life;
        if (this.field_70170_p.field_72995_K) {
            if (this.life % 4 == 0) {
                for (int i = 0; i < 2; ++i) {
                    double x = this.func_226277_ct_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                    double y = this.func_226278_cu_() - 0.4;
                    double z = this.func_226281_cx_() + (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * (double)this.func_213311_cf() * 0.5;
                    double dx = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.05;
                    double dy = 0.02 + this.field_70146_Z.nextDouble() * 0.05;
                    double dz = (this.field_70146_Z.nextDouble() * 2.0 - 1.0) * 0.05;
                    this.field_70170_p.func_195594_a((IParticleData)Content.FLAME_PARTICLE.get(), x, y + 1.0, z, dx, dy, dz);
                }
            }
        } else {
            if (this.life <= 0) {
                this.func_70106_y();
            }
            if (60 > this.life && this.life % 5 == 0) {
                this.field_70170_p.func_217357_a(LivingEntity.class, this.func_174813_aQ().func_72314_b(0.2, 0.2, 0.2)).forEach(this::damage);
                BlockPos pos = new BlockPos(this.func_213303_ch());
                if (this.field_70170_p.func_180495_p(pos).isAir((IBlockReader)this.field_70170_p, pos) && this.field_70170_p.func_180495_p(pos.func_177977_b()).isFlammable((IBlockReader)this.field_70170_p, pos.func_177977_b(), Direction.UP)) {
                    this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
                }
            }
        }
    }

    private void damage(LivingEntity target) {
        LivingEntity caster = this.getCaster();
        if (target.func_70089_S() && !target.func_190530_aW() && target != caster) {
            if (caster == null) {
                target.func_70097_a(DamageSource.field_76372_a, 6.0f);
            } else if (!caster.func_184191_r((Entity)target)) {
                target.func_70097_a(new IndirectEntityDamageSource("inFire", (Entity)this, (Entity)caster).func_76361_j(), 6.0f);
            }
        }
    }

    public void setCaster(@Nullable LivingEntity caster) {
        this.caster = caster;
        this.casterUuid = caster == null ? null : caster.func_110124_au();
    }

    @Nullable
    public LivingEntity getCaster() {
        Entity entity;
        if (this.caster == null && this.casterUuid != null && this.field_70170_p instanceof ServerWorld && (entity = ((ServerWorld)this.field_70170_p).func_217461_a(this.casterUuid)) instanceof LivingEntity) {
            this.caster = (LivingEntity)entity;
        }
        return this.caster;
    }

    protected void func_70088_a() {
    }

    protected void func_70037_a(CompoundNBT compound) {
        if (compound.func_186855_b("owner")) {
            this.casterUuid = compound.func_186857_a("owner");
        }
        if (compound.func_74764_b("life")) {
            this.life = compound.func_74762_e("life");
        }
    }

    protected void func_213281_b(CompoundNBT compound) {
        if (this.casterUuid != null) {
            compound.func_186854_a("owner", this.casterUuid);
        }
        compound.func_74768_a("life", this.life);
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }
}

